/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class BaseWindowScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public ArrayList<AbstractWidget> guiEventListeners = new ArrayList();
    public ArrayList<MoveableWindow> moveableWindows = new ArrayList();

    public BaseWindowScreen(T menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
    }

    public <R extends GuiEventListener & Renderable> R addRenderableWidget(R widget) {
        GuiEventListener widget1 = super.addRenderableWidget(widget);
        if (widget1 instanceof MoveableWindow) {
            MoveableWindow window = (MoveableWindow)widget1;
            window.init();
            this.moveableWindows.add(window);
            this.guiEventListeners.add(window);
            this.guiEventListeners.addAll(window.initialWidgetOffsets.keySet());
        }
        return (R)super.addRenderableWidget(widget);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        for (AbstractWidget listener : this.guiEventListeners) {
            if (!listener.visible) continue;
            listener.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (MoveableWindow moveableWindow : this.moveableWindows) {
            if (!moveableWindow.visible) continue;
            moveableWindow.mouseReleased(mouseX, mouseY, button);
        }
        for (AbstractWidget abstractWidget : this.guiEventListeners) {
            if (!abstractWidget.visible) continue;
            abstractWidget.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        for (AbstractWidget listener : this.guiEventListeners) {
            if (!listener.visible) continue;
            listener.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (AbstractWidget listener : this.guiEventListeners) {
            if (!listener.visible) continue;
            listener.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (AbstractWidget listener : this.guiEventListeners) {
            if (!listener.visible) continue;
            listener.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (AbstractWidget listener : this.guiEventListeners) {
            if (!listener.visible) continue;
            listener.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractWidget listener : this.guiEventListeners) {
            if (!listener.visible) continue;
            listener.setFocused(true);
            listener.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        HashMap<MoveableWindow, Consumer> resizeConsumers = new HashMap<MoveableWindow, Consumer>();
        for (MoveableWindow window2 : this.moveableWindows) {
            resizeConsumers.putIfAbsent(window2, window2.resize(minecraft, width, height));
        }
        super.resize(minecraft, width, height);
        resizeConsumers.forEach((window, consumer) -> consumer.accept(window));
    }
}

