/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FuelRefineryBlockEntity;
import com.st0x0ef.stellaris.common.menus.FuelRefineryMenu;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FuelRefineryScreen
extends AbstractContainerScreen<FuelRefineryMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocationUtils.guiTexture("fuel_refinery");
    private final FuelRefineryBlockEntity blockEntity = ((FuelRefineryMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget ingredientTankGauge;
    private GaugeWidget fuelTankGauge;
    private GaugeWidget dieselTankGauge;
    private GaugeWidget energyGauge;

    public FuelRefineryScreen(FuelRefineryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 180;
        this.imageHeight = 224;
        this.titleLabelX = (180 - Minecraft.getInstance().font.width(title.getString())) / 2;
        this.titleLabelY = 2;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        SingleFluidStorage ingredientTank = this.blockEntity.getIngredientTank();
        this.ingredientTankGauge = new GaugeWidget(this.leftPos + 42, this.topPos + 78, 12, 46, (Component)Component.translatable((String)"stellaris.screen.oil"), GUISprites.OIL_OVERLAY, GUISprites.FLUID_TANK_OVERLAY, ingredientTank.getTankCapacity(0), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.ingredientTankGauge);
        SingleFluidStorage fuelTank = this.blockEntity.getOutputFuelTank();
        this.fuelTankGauge = new GaugeWidget(this.leftPos + 80, this.topPos + 78, 12, 46, (Component)Component.translatable((String)"stellaris.screen.fuel"), GUISprites.FUEL_OVERLAY, GUISprites.FLUID_TANK_OVERLAY, fuelTank.getTankCapacity(0), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.fuelTankGauge);
        SingleFluidStorage dieselTank = this.blockEntity.getOutputFuelTank();
        this.dieselTankGauge = new GaugeWidget(this.leftPos + 128, this.topPos + 78, 12, 46, (Component)Component.translatable((String)"stellaris.screen.diesel"), GUISprites.DIESEL_OVERLAY, GUISprites.FLUID_TANK_OVERLAY, dieselTank.getTankCapacity(0), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.dieselTankGauge);
        this.energyGauge = new GaugeWidget(this.leftPos + 68, this.topPos + 20, 44, 6, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.SIDEWAYS_ENERGY_FULL, null, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.LEFT_RIGHT);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.ingredientTankGauge.updateAmount(this.blockEntity.getIngredientTank().getFluidValueInTank());
        this.fuelTankGauge.updateAmount(this.blockEntity.getOutputFuelTank().getFluidValueInTank());
        this.dieselTankGauge.updateAmount(this.blockEntity.getOutputDieselTank().getFluidValueInTank());
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.ingredientTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.fuelTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.dieselTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 5726575, false);
    }
}

