/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.BaseWindowScreen;
import com.st0x0ef.stellaris.client.screens.GalaxyScreen;
import com.st0x0ef.stellaris.client.screens.components.InvisibleButton;
import com.st0x0ef.stellaris.client.screens.etc.Trail;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.info.MoonInfo;
import com.st0x0ef.stellaris.client.screens.info.PSystemInfo;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import com.st0x0ef.stellaris.client.screens.windows.LaunchWindow;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.client.screens.windows.SpaceStationWindow;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.network.packets.OpenMilkyWayMenuPacket;
import com.st0x0ef.stellaris.common.network.packets.PlaceStationPacket;
import com.st0x0ef.stellaris.common.network.packets.TeleportEntityToPlanetPacket;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWScrollCallback;

@OnlyIn(value=Dist.CLIENT)
public class PlanetSelectionScreen
extends BaseWindowScreen<PlanetSelectionMenu> {
    public static final ResourceLocation HIGHLIGHTER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/planet_highlighter.png");
    public static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/planet_selection.png");
    public static final List<CelestialBody> STARS = new ArrayList<CelestialBody>();
    public static final List<PlanetInfo> PLANETS = new ArrayList<PlanetInfo>();
    public static final List<MoonInfo> MOONS = new ArrayList<MoonInfo>();
    public static final List<PSystemInfo> PSYSTEMS = new ArrayList<PSystemInfo>();
    public static LaunchPad.LaunchPadContainer LAUNCH_PADS = new LaunchPad.LaunchPadContainer(new ArrayList<LaunchPad>());
    private boolean showHelpMenu = true;
    private boolean showSpaceStationMenu = false;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double lastMouseX;
    private double lastMouseY;
    public boolean dragging = false;
    public boolean isPausePressed = false;
    private boolean isWheelButtonDown = false;
    public boolean isPlanetScreenOpened;
    @Nullable
    public CelestialBody focusedBody = null;
    @Nullable
    public CelestialBody hoveredBody = null;
    private double zoomLevel = 1.0;
    private double targetZoomLevel = 1.0;
    public boolean canZoom;
    private double targetOffsetX = 0.0;
    private double targetOffsetY = 0.0;
    private GLFWScrollCallback prevScrollCallback;
    private final List<InvisibleButton> planetButtons = new ArrayList<InvisibleButton>();
    private final List<InvisibleButton> moonButtons = new ArrayList<InvisibleButton>();
    public ArrayList<MoveableWindow> moveableWindows = new ArrayList();
    private LaunchWindow launchWindow;
    private SpaceStationWindow spaceStationWindow;
    public int windowIndex = -1;
    private int currentHighlighterFrame = 0;
    private final int totalHighlighterFrames = 30;
    private int leftArrowX;
    private int rightArrowX;
    private int arrowY;
    private int arrowWidth = 25;
    private int arrowHeight = 25;
    private final int verticalArrowWidth = 20;
    private final int verticalArrowHeight = 20;
    int galaxyWidth = 21;
    int galaxyHeight = 12;
    int galaxyX = 4;
    int galaxyY = 4;
    private int centerArrowX;

    public PlanetSelectionScreen(PlanetSelectionMenu abstractContainerMenu, Inventory inventory, Component component) {
        super(abstractContainerMenu, inventory, component);
        this.imageWidth = 1200;
        this.imageHeight = 1600;
        this.inventoryLabelY = this.imageHeight - 110;
        this.canZoom = true;
    }

    protected void init() {
        super.init();
        this.getMenu().freeze_gui = false;
        this.initWindows();
        this.centerSun();
        this.isPlanetScreenOpened = true;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)Minecraft.getInstance().getWindow().getWindow(), this::onMouseScroll);
        this.initializeAllButtons();
        this.zoomLevel = 1.0;
        this.targetZoomLevel = 1.0;
    }

    public void initWindows() {
        this.launchWindow = new LaunchWindow(300, 200, (Component)Component.literal((String)"Launch"), this);
        this.launchWindow.visible = false;
        this.addRenderableWidget(this.launchWindow);
        this.launchWindow.changeVisibility(false);
        this.moveableWindows.add(this.launchWindow);
        this.spaceStationWindow = new SpaceStationWindow(300, 200, (Component)Component.literal((String)"Space Station"), this);
        this.spaceStationWindow.visible = false;
        this.addRenderableWidget(this.spaceStationWindow);
        this.spaceStationWindow.changeVisibility(false);
        this.moveableWindows.add(this.spaceStationWindow);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics, partialTicks, mouseX, mouseY);
        super.render(graphics, mouseX, mouseY, partialTicks);
        if (!this.isPausePressed) {
            this.updatePlanets();
        }
        this.updateZoomAndOffsetAnimation();
        if (this.focusedBody != null) {
            this.centerOnBody(this.focusedBody);
        }
        this.drawOrbits();
        this.drawTrails();
        this.renderBodiesAndPlanets(graphics);
        this.hoveredBody = null;
        for (MoonInfo moon : MOONS) {
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            float moonX = (float)(((double)moon.x + this.offsetX) * this.zoomLevel - (double)moonWidth / 2.0);
            float moonY = (float)(((double)moon.y + this.offsetY) * this.zoomLevel - (double)moonHeight / 2.0);
            if (!((float)mouseX >= moonX) || !((float)mouseX <= moonX + (float)moonWidth) || !((float)mouseY >= moonY) || !((float)mouseY <= moonY + (float)moonHeight)) continue;
            this.hoveredBody = moon;
            break;
        }
        if (this.hoveredBody == null) {
            for (PlanetInfo planet : PLANETS) {
                int planetWidth = (int)((double)planet.width * this.zoomLevel);
                int planetHeight = (int)((double)planet.height * this.zoomLevel);
                float planetX = (float)(((double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle) - (double)planetWidth / 2.0) * this.zoomLevel);
                float planetY = (float)(((double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle) - (double)planetHeight / 2.0) * this.zoomLevel);
                if (!((float)mouseX >= planetX) || !((float)mouseX <= planetX + (float)planetWidth) || !((float)mouseY >= planetY) || !((float)mouseY <= planetY + (float)planetHeight)) continue;
                this.hoveredBody = planet;
                break;
            }
        }
        if (this.hoveredBody != null) {
            this.updateHighlighterPosition(graphics, this.hoveredBody);
        }
        if (this.focusedBody != null) {
            this.updateHighlighterPosition(graphics, this.focusedBody);
        }
        this.initTop(graphics, mouseX, mouseY);
        this.renderLaunchPads(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    public boolean canLaunch(Planet planet) {
        if (this.getMenu().getForceCanGoTo()) {
            return true;
        }
        if (planet.dimension() == ResourceLocation.parse((String)"minecraft:overworld")) {
            return true;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return false;
        }
        Entity vehicle = player.getVehicle();
        if (vehicle instanceof RocketEntity) {
            RocketEntity rocket = (RocketEntity)vehicle;
            if (PlanetUtil.isPlanet(player.level().dimension().location())) {
                return rocket.canGoTo(PlanetUtil.getPlanet(player.level().dimension().location()), planet);
            }
            return rocket.canGoTo(PlanetUtil.getPlanet(Level.OVERWORLD.location()), planet);
        }
        return false;
    }

    private void initializeAllButtons() {
        this.initializePlanetButtons();
        this.initializeMoonButtons();
    }

    private void initializePlanetButtons() {
        this.planetButtons.clear();
    }

    private void initializeMoonButtons() {
        this.moonButtons.clear();
    }

    private void initTop(GuiGraphics graphics, int mouseX, int mouseY) {
        List<MutableComponent> tooltipLines;
        ResourceLocation topBarTexture = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/planet_selection_bar.png");
        int tgWidth = 240;
        int tgHeight = 32;
        int tgX = (this.width - tgWidth) / 2;
        int tgY = this.height - 48;
        int infoWidth = 12;
        int infoHeight = 12;
        int infoX = this.width - 20;
        int infoY = 4;
        this.leftArrowX = tgX + 7;
        this.rightArrowX = tgX + tgWidth - this.arrowWidth - 7;
        this.arrowY = tgY + (tgHeight - this.arrowHeight) / 2;
        boolean infoHovering = Utils.isHoveredOnSprite(infoX, infoY, infoWidth, infoHeight, mouseX, mouseY);
        boolean galaxyHovering = Utils.isHoveredOnSprite(this.galaxyX, this.galaxyY, this.galaxyWidth, this.galaxyHeight, mouseX, mouseY);
        graphics.blit(topBarTexture, tgX, tgY, 0.0f, 0.0f, tgWidth, tgHeight, tgWidth, tgHeight);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)("textures/gui/util/" + (infoHovering ? "planet_selection_info_button_hover.png" : "planet_selection_info_button.png"))), infoX, infoY, 0.0f, 0.0f, infoWidth, infoHeight, infoWidth, infoHeight);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)("textures/gui/util/" + (galaxyHovering ? "planet_selection_galaxy_button_hover.png" : "planet_selection_galaxy_button.png"))), this.galaxyX, this.galaxyY, 0.0f, 0.0f, this.galaxyWidth, this.galaxyHeight, this.galaxyWidth, this.galaxyHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean arrowHoveringLeft = Utils.isHoveredOnSprite(this.leftArrowX, this.arrowY, this.arrowWidth, this.arrowHeight, mouseX, mouseY);
        boolean arrowHoveringRight = Utils.isHoveredOnSprite(this.rightArrowX, this.arrowY, this.arrowWidth, this.arrowHeight, mouseX, mouseY);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)("textures/gui/util/" + (arrowHoveringLeft ? "planet_selection_arrow_left_hover.png" : "planet_selection_arrow_left.png"))), this.leftArrowX, this.arrowY, 0.0f, 0.0f, this.arrowWidth, this.arrowHeight, this.arrowWidth, this.arrowHeight);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)("textures/gui/util/" + (arrowHoveringRight ? "planet_selection_arrow_right_hover.png" : "planet_selection_arrow_right.png"))), this.rightArrowX, this.arrowY, 0.0f, 0.0f, this.arrowWidth, this.arrowHeight, this.arrowWidth, this.arrowHeight);
        MutableComponent bodyName = this.focusedBody != null ? this.focusedBody.getTranslatable() : Component.literal((String)"X");
        int nameWidth = this.font.width((FormattedText)bodyName);
        int nameX = tgX + tgWidth / 2 - nameWidth / 2;
        int n = tgY + tgHeight / 2;
        Objects.requireNonNull(this.font);
        int nameY = n - 9 / 2;
        graphics.drawString(this.font, (Component)bodyName, nameX, nameY, 0xFFFFFF, true);
        if (infoHovering) {
            tooltipLines = List.of(Component.translatable((String)"text.stellaris.planetscreen.space"), Component.translatable((String)"text.stellaris.planetscreen.arrows"));
            graphics.renderTooltip(this.font, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
        if (galaxyHovering) {
            tooltipLines = List.of(Component.translatable((String)"text.stellaris.planetscreen.returntogalaxy"));
            graphics.renderTooltip(this.font, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    private void updateZoomAndOffsetAnimation() {
        double smoothing = 0.05;
        this.zoomLevel += (this.targetZoomLevel - this.zoomLevel) * smoothing;
        this.offsetX += (this.targetOffsetX - this.offsetX) * smoothing;
        this.offsetY += (this.targetOffsetY - this.offsetY) * smoothing;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        graphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public void renderBodiesAndPlanets(GuiGraphics graphics) {
        this.renderStars(graphics);
        this.renderPlanets(graphics);
        this.renderMoons(graphics);
        this.initializePlanetButtons();
        this.initializeMoonButtons();
    }

    private void renderStars(GuiGraphics graphics) {
        for (CelestialBody star : STARS) {
            if (!this.isInCurrentGalaxy(star)) continue;
            float bodyX = (float)(((double)star.x + this.offsetX) * this.zoomLevel - (double)(star.width / 2.0f) * this.zoomLevel);
            float bodyY = (float)(((double)star.y + this.offsetY) * this.zoomLevel - (double)(star.height / 2.0f) * this.zoomLevel);
            int bodyWidth = (int)((double)star.width * this.zoomLevel);
            int bodyHeight = (int)((double)star.height * this.zoomLevel);
            graphics.blit(star.texture, (int)bodyX, (int)bodyY, 0.0f, 0.0f, bodyWidth, bodyHeight, bodyWidth, bodyHeight);
            int nameWidth = this.font.width((FormattedText)star.getTranslatable());
            graphics.drawString(this.font, star.getTranslatable(), (int)(bodyX + (float)bodyWidth / 2.0f - (float)nameWidth / 2.0f), (int)(bodyY + (float)bodyHeight), 0xFFFFFF);
        }
    }

    private void renderPlanets(GuiGraphics graphics) {
        for (PlanetInfo planet : PLANETS) {
            if (!this.isInCurrentGalaxy(planet)) continue;
            CelestialBody orbitCenter = planet.orbitCenter;
            float orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            float orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            float planetX = (float)((double)orbitCenterX + planet.orbitRadius * this.zoomLevel * Math.cos(planet.currentAngle) - (double)(planet.width / 2.0f) * this.zoomLevel);
            float planetY = (float)((double)orbitCenterY + planet.orbitRadius * this.zoomLevel * Math.sin(planet.currentAngle) - (double)(planet.height / 2.0f) * this.zoomLevel);
            int planetWidth = (int)((double)planet.width * this.zoomLevel);
            int planetHeight = (int)((double)planet.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, planet.texture, (int)planetX, (int)planetY, 0, 0, planetWidth, planetHeight, planetWidth, planetHeight, (float)planet.currentAngle);
            int nameWidth = this.font.width(planet.name);
            graphics.drawString(this.font, planet.getTranslatable(), (int)(planetX + (float)planetWidth / 2.0f - (float)nameWidth / 2.0f), (int)(planetY + (float)planetHeight), 0xFFFFFF);
        }
    }

    private void renderMoons(GuiGraphics graphics) {
        for (MoonInfo moon : MOONS) {
            if (!this.isInCurrentGalaxy(moon)) continue;
            float moonX = (float)(((double)moon.x + this.offsetX) * this.zoomLevel - (double)(moon.width / 2.0f) * this.zoomLevel);
            float moonY = (float)(((double)moon.y + this.offsetY) * this.zoomLevel - (double)(moon.height / 2.0f) * this.zoomLevel);
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, moon.texture, (int)moonX, (int)moonY, 0, 0, moonWidth, moonHeight, moonWidth, moonHeight, (float)moon.currentAngle);
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 90) {
            if (this.focusedBody != null && this.canLaunch(PlanetUtil.getPlanet(this.focusedBody.dimension))) {
                this.showSpaceStationMenu = !this.showSpaceStationMenu;
            }
        } else if (keyCode == 72) {
            this.showHelpMenu = !this.showHelpMenu;
        } else if (keyCode == 32 || keyCode == 88) {
            this.isPausePressed = !this.isPausePressed;
        } else if (keyCode == 262) {
            if (this.focusedBody == null) {
                this.focusedBody = PlanetSelectionScreen.findByNameStar("stellaris:sun");
            } else if (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo) {
                this.focusedBody = this.getNextBodyByDistance(this.focusedBody);
            } else if (this.focusedBody instanceof CelestialBody) {
                this.focusedBody = this.getNextStarByDistance(this.focusedBody);
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            if (this.focusedBody != null) {
                this.centerOnBody(this.focusedBody);
            }
        } else if (keyCode == 263) {
            if (this.focusedBody == null) {
                this.focusedBody = PlanetSelectionScreen.findByNameStar("stellaris:sun");
            } else if (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo) {
                this.focusedBody = this.getPreviousBodyByDistance(this.focusedBody);
            } else if (this.focusedBody instanceof CelestialBody) {
                this.focusedBody = this.getPreviousStarByDistance(this.focusedBody);
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            if (this.focusedBody != null) {
                this.centerOnBody(this.focusedBody);
            }
        } else if (keyCode == 265) {
            CelestialBody celestialBody = this.focusedBody;
            if (celestialBody instanceof MoonInfo) {
                MoonInfo moon = (MoonInfo)celestialBody;
                this.focusedBody = moon.orbitCenter;
            } else {
                celestialBody = this.focusedBody;
                if (celestialBody instanceof PlanetInfo) {
                    PlanetInfo planet = (PlanetInfo)celestialBody;
                    this.focusedBody = planet.orbitCenter;
                }
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            this.centerOnBody(this.focusedBody);
        } else if (keyCode == 264) {
            CelestialBody celestialBody = this.focusedBody;
            if (celestialBody instanceof PlanetInfo) {
                PlanetInfo planet = (PlanetInfo)celestialBody;
                this.focusedBody = this.getMoonsByDistance(planet);
            } else {
                celestialBody = this.focusedBody;
                if (celestialBody instanceof CelestialBody) {
                    CelestialBody star = celestialBody;
                    List<PlanetInfo> planetsInSystem = PLANETS.stream().filter(p -> p.orbitCenter == star).sorted(Comparator.comparingDouble(p -> p.orbitRadius)).toList();
                    if (!planetsInSystem.isEmpty()) {
                        this.focusedBody = planetsInSystem.getFirst();
                    }
                }
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            this.centerOnBody(this.focusedBody);
        } else if (keyCode == 256 && this.windowIndex != -1) {
            this.showSpaceStationMenu = false;
            this.showPreviousWindow();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void showPreviousWindow() {
        if (this.windowIndex != -1) {
            this.setWindowVisible(--this.windowIndex);
        }
    }

    public void setWindowVisible(int index) {
        for (int i = 0; i < this.moveableWindows.size(); ++i) {
            MoveableWindow window = this.moveableWindows.get(i);
            if (i == index) {
                window.changeVisibility(true);
                window.visible = true;
                this.windowIndex = i;
                continue;
            }
            window.close();
            window.changeVisibility(false);
            window.visible = false;
        }
    }

    private CelestialBody getNextBodyByDistance(CelestialBody currentBody) {
        block7: {
            block8: {
                block6: {
                    if (currentBody == null) {
                        return null;
                    }
                    if (!(currentBody instanceof PlanetInfo)) break block6;
                    PlanetInfo planetInfo = (PlanetInfo)currentBody;
                    ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                    bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                    for (int i = 0; i < bodies.size(); ++i) {
                        if (bodies.get(i) != currentBody) continue;
                        for (int j = i + 1; j < bodies.size(); ++j) {
                            if (((PlanetInfo)bodies.get((int)j)).orbitCenter != planetInfo.orbitCenter) continue;
                            return (CelestialBody)bodies.get(j);
                        }
                    }
                    break block7;
                }
                if (!(currentBody instanceof MoonInfo)) break block8;
                MoonInfo moonInfo = (MoonInfo)currentBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = 0; i < bodies.size(); ++i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i + 1; j < bodies.size(); ++j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != moonInfo.orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break block7;
            }
            if (!STARS.contains(currentBody)) break block7;
            ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
            bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
            for (PlanetInfo planet : bodies) {
                if (planet.orbitCenter != currentBody) continue;
                return planet;
            }
        }
        return currentBody;
    }

    private CelestialBody getPreviousBodyByDistance(CelestialBody currentBody) {
        block7: {
            block8: {
                block6: {
                    if (currentBody == null) {
                        return null;
                    }
                    if (!(currentBody instanceof PlanetInfo)) break block6;
                    PlanetInfo planetInfo = (PlanetInfo)currentBody;
                    ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                    bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                    for (int i = bodies.size() - 1; i >= 0; --i) {
                        if (bodies.get(i) != currentBody) continue;
                        for (int j = i - 1; j >= 0; --j) {
                            if (((PlanetInfo)bodies.get((int)j)).orbitCenter != planetInfo.orbitCenter) continue;
                            return (CelestialBody)bodies.get(j);
                        }
                    }
                    break block7;
                }
                if (!(currentBody instanceof MoonInfo)) break block8;
                MoonInfo moonInfo = (MoonInfo)currentBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = bodies.size() - 1; i >= 0; --i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != moonInfo.orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break block7;
            }
            if (!STARS.contains(currentBody)) break block7;
            ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
            bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
            for (int i = bodies.size() - 1; i >= 0; --i) {
                if (((PlanetInfo)bodies.get((int)i)).orbitCenter != currentBody) continue;
                return (CelestialBody)bodies.get(i);
            }
        }
        return currentBody;
    }

    private CelestialBody getMoonsByDistance(PlanetInfo currentBody) {
        CelestialBody smallestOrbitMoon = null;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody) || smallestOrbitMoon != null && !(moon.orbitRadius < ((MoonInfo)smallestOrbitMoon).orbitRadius)) continue;
            smallestOrbitMoon = moon;
        }
        return smallestOrbitMoon != null ? smallestOrbitMoon : currentBody;
    }

    private CelestialBody getNextStarByDistance(CelestialBody currentBody) {
        ArrayList<CelestialBody> stars = new ArrayList<CelestialBody>(STARS);
        stars.sort(Comparator.comparing(CelestialBody::getId));
        for (int i = 0; i < stars.size(); ++i) {
            if (stars.get(i) != currentBody) continue;
            return (CelestialBody)stars.get((i + 1) % stars.size());
        }
        return currentBody;
    }

    private CelestialBody getPreviousStarByDistance(CelestialBody currentBody) {
        ArrayList<CelestialBody> stars = new ArrayList<CelestialBody>(STARS);
        stars.sort(Comparator.comparing(CelestialBody::getId));
        for (int i = 0; i < stars.size(); ++i) {
            if (stars.get(i) != currentBody) continue;
            return (CelestialBody)stars.get((i - 1 + stars.size()) % stars.size());
        }
        return currentBody;
    }

    private int getMoonsCount(PlanetInfo currentBody) {
        int i = 0;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody)) continue;
            ++i;
        }
        return i;
    }

    public void tpToFocusedPlanet(ResourceLocation dimension) {
        this.tpToFocusedPlanet(new Vec3(this.getPlayer().getX(), (double)Stellaris.CONFIG.rocketTpHeight, this.getPlayer().getZ()), dimension);
    }

    public void tpToFocusedPlanet(Vec3 coords, ResourceLocation focusedBodyDimension) {
        if (focusedBodyDimension != null) {
            NetworkManager.sendToServer((CustomPacketPayload)new TeleportEntityToPlanetPacket(focusedBodyDimension, coords));
            long windowHandle = Minecraft.getInstance().getWindow().getWindow();
            if (this.prevScrollCallback != null) {
                GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((MouseHandler)Minecraft.getInstance().mouseHandler).onScroll(arg_0, arg_1, arg_2));
            }
        } else {
            Stellaris.LOG.error("Destination dimension for teleportation is null");
        }
    }

    private void updatePlanets() {
        long time = Util.getMillis();
        if (!this.getMenu().freeze_gui || !this.isPausePressed) {
            for (PlanetInfo planet : PLANETS) {
                planet.updateAngle(time);
                planet.updatePosition();
                planet.trail.addPosition(planet.x, planet.y);
            }
            for (MoonInfo moon : MOONS) {
                moon.updateAngle(time);
                moon.updatePosition();
                moon.trail.addPosition(moon.x, moon.y);
            }
            double G = 10000.0;
            double dt = 0.1;
            return;
        }
    }

    public void drawTrails() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        for (CelestialBody star : STARS) {
            if (!this.isInCurrentGalaxy(star)) continue;
            this.renderTrail(tesselator, star.trail, 0xFFFFFF, 0.5f);
        }
        RenderSystem.disableBlend();
    }

    public void renderTrail(Tesselator tesselator, Trail trail, int color, float alpha) {
        List<float[]> positions = trail.getPositions();
        if (positions.size() < 2) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        for (float[] pos : positions) {
            float x = (float)(((double)pos[0] + this.offsetX) * this.zoomLevel);
            float y = (float)(((double)pos[1] + this.offsetY) * this.zoomLevel);
            bufferBuilder.addVertex(x, y, 0.0f).setColor(red, green, blue, alpha);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    private void updateChildPositions(CelestialBody orbitCenter, long time) {
        for (PlanetInfo planet : PLANETS) {
            if (planet.orbitCenter != orbitCenter) continue;
            planet.updateAngle(time);
            planet.updatePosition();
            this.updateMoonPositions(planet, time);
        }
    }

    private void updateMoonPositions(PlanetInfo planet, long time) {
        for (MoonInfo moon : MOONS) {
            if (moon.orbitCenter != planet) continue;
            moon.updateAngle(time);
            moon.updatePosition();
        }
    }

    public void drawOrbits() {
        float orbitCenterY;
        float orbitCenterX;
        CelestialBody orbitCenter;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        for (PlanetInfo planet : PLANETS) {
            if (!this.isInCurrentGalaxy(planet) || !this.isInCurrentGalaxy(planet.orbitCenter)) continue;
            orbitCenter = planet.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(tesselator, orbitCenterX, orbitCenterY, planet.orbitRadius * this.zoomLevel, 75, orbitCenter.orbitColor, 1.0f);
        }
        for (MoonInfo moon : MOONS) {
            if (!this.isInCurrentGalaxy(moon) || !this.isInCurrentGalaxy(moon.orbitCenter)) continue;
            orbitCenter = moon.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(tesselator, orbitCenterX, orbitCenterY, moon.orbitRadius * this.zoomLevel, 75, 0x888888, 0.5f);
        }
        RenderSystem.disableBlend();
    }

    public static void renderOrbits(Tesselator tesselator, double centerX, double centerY, double radius, int sides, int color, float alphaL) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float angleStep = (float)(Math.PI * 2 / (double)sides);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i < sides; ++i) {
            float currentAngle = (float)i * angleStep;
            float nextAngle = currentAngle + angleStep;
            float vertex1X = (float)(centerX + radius * Math.cos(currentAngle));
            float vertex1Y = (float)(centerY + radius * Math.sin(currentAngle));
            float vertex2X = (float)(centerX + radius * Math.cos(nextAngle));
            float vertex2Y = (float)(centerY + radius * Math.sin(nextAngle));
            bufferBuilder.addVertex(vertex1X, vertex1Y, 0.0f).setColor(red, green, blue, alphaL);
            bufferBuilder.addVertex(vertex2X, vertex2Y, 0.0f).setColor(red, green, blue, alphaL);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    private void centerSun() {
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        CelestialBody sun = PlanetSelectionScreen.findByNameStar(GalaxyScreen.findByNameGalaxy(this.getMenu().getGalaxyId()).centerStar());
        if (sun != null) {
            sun.setPosition(centerX, centerY);
        } else {
            Stellaris.LOG.error("center sun is null");
        }
        this.offsetX = 0.0;
        this.offsetY = 0.0;
    }

    private boolean isInCurrentGalaxy(CelestialBody body) {
        return body.galaxy.equals(this.getMenu().getGalaxyId()) || body.galaxy.equals("null");
    }

    public static CelestialBody findByNameStar(String id) {
        for (CelestialBody body : STARS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        Stellaris.LOG.warn("Star not found : {}", (Object)id);
        return null;
    }

    public static PlanetInfo findByNamePlanet(String id) {
        for (PlanetInfo body : PLANETS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    public static MoonInfo findByNameMoon(String id) {
        for (MoonInfo body : MOONS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    public void centerOnBody(CelestialBody body) {
        if (body == null) {
            return;
        }
        this.zoomLevel = 1.0;
        this.targetOffsetX = ((double)body.x - (double)this.width / 2.0) * -1.0;
        this.targetOffsetY = ((double)body.y - (double)this.height / 2.0) * -1.0;
    }

    public void onMouseScroll(long window, double scrollX, double scrollY) {
        double[] mouseX = new double[1];
        double[] mouseY = new double[1];
        GLFW.glfwGetCursorPos((long)window, (double[])mouseX, (double[])mouseY);
        if (this.minecraft != null && this.minecraft.player != null) {
            CreativeModeInventoryScreen creativeScreen;
            Screen screen;
            if (this.minecraft.screen != null) {
                this.handleHotbarScroll(scrollY);
            }
            if ((screen = this.minecraft.screen) instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)screen).mouseScrolled(mouseX[0], mouseY[0], scrollX, scrollY)) {
                return;
            }
            if (this.minecraft.screen instanceof PlanetSelectionScreen) {
                if (this.windowIndex != -1) {
                    this.mouseScrolled(mouseX[0], mouseY[0], scrollX, scrollY);
                    return;
                }
                if (scrollY != 0.0 && this.canZoom) {
                    double screenX = (double)this.width / 4.0;
                    double screenY = (double)this.height / 4.0;
                    double beforeZoomWorldX = screenX / this.zoomLevel - this.offsetX;
                    double beforeZoomWorldY = screenY / this.zoomLevel - this.offsetY;
                    this.targetZoomLevel += scrollY * 0.1;
                    this.targetZoomLevel = Math.max(0.2, Math.min(this.targetZoomLevel, 1.2));
                    double afterZoomWorldX = screenX / this.targetZoomLevel - this.offsetX;
                    double afterZoomWorldY = screenY / this.targetZoomLevel - this.offsetY;
                    double offsetAdjustX = beforeZoomWorldX - afterZoomWorldX;
                    double offsetAdjustY = beforeZoomWorldY - afterZoomWorldY;
                    this.targetOffsetX += offsetAdjustX;
                    this.targetOffsetY += offsetAdjustY;
                }
            }
        }
    }

    private boolean handleHotbarScroll(double scrollY) {
        if (this.minecraft != null && this.minecraft.player != null) {
            int currentSlot = this.minecraft.player.getInventory().selected;
            int newSlot = currentSlot - (int)scrollY;
            if ((newSlot = (newSlot + 9) % 9) != currentSlot) {
                this.minecraft.player.getInventory().selected = newSlot;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 2) {
            this.isWheelButtonDown = true;
        }
        if (button == 0 || button == 1) {
            boolean isArrowHovered;
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            boolean bl = isArrowHovered = mouseX >= (double)this.leftArrowX && mouseX <= (double)(this.leftArrowX + this.arrowWidth) && mouseY >= (double)this.arrowY && mouseY <= (double)(this.arrowY + this.arrowHeight);
            if (isArrowHovered) {
                if (this.focusedBody == null) {
                    this.focusedBody = PlanetSelectionScreen.findByNamePlanet("stellaris:earth");
                } else if (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo) {
                    this.focusedBody = this.getPreviousBodyByDistance(this.focusedBody);
                    this.setWindowCelestialBody(this.focusedBody);
                } else {
                    this.focusedBody = this.getPreviousStarByDistance(this.focusedBody);
                }
                if (!this.isInCurrentGalaxy(this.focusedBody)) {
                    this.focusedBody = null;
                }
                Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
                if (this.focusedBody != null) {
                    this.centerOnBody(this.focusedBody);
                }
                return true;
            }
            if (mouseX >= (double)this.rightArrowX && mouseX <= (double)(this.rightArrowX + this.arrowWidth) && mouseY >= (double)this.arrowY && mouseY <= (double)(this.arrowY + this.arrowHeight)) {
                if (this.focusedBody == null) {
                    this.focusedBody = PlanetSelectionScreen.findByNamePlanet("stellaris:earth");
                } else if (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo) {
                    this.focusedBody = this.getNextBodyByDistance(this.focusedBody);
                    this.setWindowCelestialBody(this.focusedBody);
                } else {
                    this.focusedBody = this.getNextStarByDistance(this.focusedBody);
                }
                if (!this.isInCurrentGalaxy(this.focusedBody)) {
                    this.focusedBody = null;
                }
                Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
                if (this.focusedBody != null) {
                    this.centerOnBody(this.focusedBody);
                }
                return true;
            }
            if (Utils.isHoveredOnSprite(this.galaxyX, this.galaxyY, this.galaxyWidth, this.galaxyHeight, mouseX, mouseY)) {
                Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
                NetworkManager.sendToServer((CustomPacketPayload)new OpenMilkyWayMenuPacket());
            }
            if (!this.showSpaceStationMenu) {
                this.focusedBody = null;
                this.hoveredBody = null;
                for (MoonInfo moon : MOONS) {
                    if (!this.isInCurrentGalaxy(moon)) continue;
                    double mx = (double)moon.orbitCenter.x + this.offsetX + moon.orbitRadius * Math.cos(moon.currentAngle);
                    double my = (double)moon.orbitCenter.y + this.offsetY + moon.orbitRadius * Math.sin(moon.currentAngle);
                    int moonWidth = (int)((double)moon.width * this.zoomLevel);
                    int moonHeight = (int)((double)moon.height * this.zoomLevel);
                    float moonX = (float)((mx - (double)(moon.width / 2.0f)) * this.zoomLevel);
                    float moonY = (float)((my - (double)(moon.height / 2.0f)) * this.zoomLevel);
                    if (!(mouseX >= (double)moonX) || !(mouseX <= (double)(moonX + (float)moonWidth)) || !(mouseY >= (double)moonY) || !(mouseY <= (double)(moonY + (float)moonHeight)) || !moon.clickable) continue;
                    this.focusedBody = moon;
                    this.setWindowCelestialBody(this.focusedBody);
                    this.showSpaceStationMenu = true;
                    double cx = mx - (double)this.width / 2.0;
                    double cy = my - (double)this.height / 2.0;
                    this.targetOffsetX = -cx;
                    this.targetOffsetY = -cy;
                    return true;
                }
                for (PlanetInfo planet : PLANETS) {
                    if (!this.isInCurrentGalaxy(planet)) continue;
                    double px = (double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle);
                    double py = (double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle);
                    int planetWidth = (int)((double)planet.width * this.zoomLevel);
                    int planetHeight = (int)((double)planet.height * this.zoomLevel);
                    float planetX = (float)((px - (double)(planet.width / 2.0f)) * this.zoomLevel);
                    float planetY = (float)((py - (double)(planet.height / 2.0f)) * this.zoomLevel);
                    if (!(mouseX >= (double)planetX) || !(mouseX <= (double)(planetX + (float)planetWidth)) || !(mouseY >= (double)planetY) || !(mouseY <= (double)(planetY + (float)planetHeight))) continue;
                    this.focusedBody = planet;
                    this.setWindowCelestialBody(this.focusedBody);
                    this.showSpaceStationMenu = true;
                    double cx = px - (double)this.width / 2.0;
                    double cy = py - (double)this.height / 2.0;
                    this.targetZoomLevel = 1.0;
                    this.targetOffsetX = -cx;
                    this.targetOffsetY = -cy;
                    return true;
                }
            }
            if (!this.showSpaceStationMenu && !isArrowHovered && button == 0) {
                this.focusedBody = null;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setWindowCelestialBody(CelestialBody body) {
        Stellaris.LOG.error("body id {}", (Object)body.id);
        this.launchWindow.setCelestialBody(body);
        this.spaceStationWindow.setCelestialBody(body);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.dragging = false;
        }
        if (button == 2) {
            this.isWheelButtonDown = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.focusedBody = null;
            if (this.isWheelButtonDown) {
                double rotationSpeed = 0.005;
                double deltaAngle = deltaX * rotationSpeed;
                for (PlanetInfo planet : PLANETS) {
                    planet.currentAngle += deltaAngle;
                    planet.updatePosition();
                }
                for (MoonInfo moon : MOONS) {
                    moon.currentAngle += deltaAngle;
                    moon.updatePosition();
                }
            } else {
                double dx = (mouseX - this.lastMouseX) / this.zoomLevel;
                double dy = (mouseY - this.lastMouseY) / this.zoomLevel;
                this.offsetX += dx;
                this.offsetY += dy;
                this.targetOffsetX = this.offsetX;
                this.targetOffsetY = this.offsetY;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updateHighlighterPosition(GuiGraphics graphics, CelestialBody body) {
        float highlightY;
        float highlightX;
        int highlightWidth = (int)((double)body.width * this.zoomLevel);
        int highlightHeight = (int)((double)body.height * this.zoomLevel);
        if (body instanceof PlanetInfo) {
            PlanetInfo planet = (PlanetInfo)body;
            double px = (double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle);
            double py = (double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle);
            highlightX = (float)((px - (double)(planet.width / 2.0f)) * this.zoomLevel);
            highlightY = (float)((py - (double)(planet.height / 2.0f)) * this.zoomLevel);
        } else if (body instanceof MoonInfo) {
            MoonInfo moon = (MoonInfo)body;
            double mx = (double)moon.orbitCenter.x + this.offsetX + moon.orbitRadius * Math.cos(moon.currentAngle);
            double my = (double)moon.orbitCenter.y + this.offsetY + moon.orbitRadius * Math.sin(moon.currentAngle);
            highlightX = (float)((mx - (double)(moon.width / 2.0f)) * this.zoomLevel);
            highlightY = (float)((my - (double)(moon.height / 2.0f)) * this.zoomLevel);
        } else {
            highlightX = (float)(((double)body.x + this.offsetX) * this.zoomLevel - (double)highlightWidth / 2.0);
            highlightY = (float)(((double)body.y + this.offsetY) * this.zoomLevel - (double)highlightHeight / 2.0);
        }
        this.currentHighlighterFrame = (this.currentHighlighterFrame + 1) % 30;
        int frameY = this.currentHighlighterFrame * highlightHeight;
        float currentAngle = body instanceof PlanetInfo ? (float)((PlanetInfo)body).currentAngle : (body instanceof MoonInfo ? (float)((MoonInfo)body).currentAngle : 0.0f);
        ScreenHelper.drawTexturewithRotation(graphics, HIGHLIGHTER_TEXTURE, (int)highlightX, (int)highlightY, 0, frameY, highlightWidth, highlightHeight, highlightWidth, 30 * highlightHeight, currentAngle);
    }

    public PlanetSelectionMenu getMenu() {
        return (PlanetSelectionMenu)this.menu;
    }

    public void onClose() {
        if (this.getPlayer().stellaris$isPlanetMenuOpen()) {
            return;
        }
        long windowHandle = Minecraft.getInstance().getWindow().getWindow();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((MouseHandler)Minecraft.getInstance().mouseHandler).onScroll(arg_0, arg_1, arg_2));
        super.onClose();
    }

    private void renderLaunchPads(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.windowIndex == -1 && this.showSpaceStationMenu) {
            this.setWindowVisible(0);
        }
        if (this.windowIndex != -1) {
            this.moveableWindows.get(this.windowIndex).renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void onSpaceStationButtonClick(CelestialBody body, SpaceStationRecipesManager.SpaceStationRecipeState stationRecipeState, LaunchPad pad) {
        Planet planet = PlanetUtil.getPlanet(body.dimension);
        this.focusedBody = body;
        this.tpToFocusedPlanet(PlanetUtil.getSpaceStationDimension(planet));
        NetworkManager.sendToServer((CustomPacketPayload)new PlaceStationPacket(PlanetUtil.getSpaceStationDimension(planet), stationRecipeState.recipe(), pad));
    }

    public Player getPlayer() {
        return ((PlanetSelectionMenu)this.menu).getPlayer();
    }
}

