/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.PumpjackBlockEntity;
import com.st0x0ef.stellaris.common.menus.PumpjackMenu;
import com.st0x0ef.stellaris.common.oil.OilUtils;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class PumpjackScreen
extends AbstractContainerScreen<PumpjackMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocationUtils.guiTexture("pumpjack");
    private final PumpjackBlockEntity blockEntity = ((PumpjackMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget resultTankGauge;
    private GaugeWidget energyGauge;

    public PumpjackScreen(PumpjackMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.titleLabelX = (180 - Minecraft.getInstance().font.width(title.getString())) / 2;
        this.titleLabelY = 2;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        SingleFluidStorage resultTank = this.blockEntity.getResultTank();
        this.resultTankGauge = new GaugeWidget(this.leftPos + 114, this.topPos + 46, 12, 46, (Component)Component.translatable((String)"stellaris.screen.oil"), GUISprites.OIL_OVERLAY, GUISprites.FLUID_TANK_OVERLAY, resultTank.getTankCapacity(0), GaugeWidget.Direction4.DOWN_UP);
        this.addRenderableWidget((GuiEventListener)this.resultTankGauge);
        this.energyGauge = new GaugeWidget(this.leftPos + 68, this.topPos + 20, 44, 6, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.SIDEWAYS_ENERGY_FULL, null, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.LEFT_RIGHT);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.blockEntity == null || Minecraft.getInstance().level == null) {
            return;
        }
        guiGraphics.drawString(this.font, "Oil Level", this.leftPos + 19, this.topPos + 40, Utils.getColorHexCode("gray"));
        guiGraphics.drawCenteredString(this.font, String.valueOf(this.blockEntity.chunkOilLevel((Level)Minecraft.getInstance().level)), this.leftPos + 40, this.topPos + 51, OilUtils.getOilLevelColor(this.blockEntity.chunkOilLevel((Level)Minecraft.getInstance().level)));
        this.resultTankGauge.updateAmount(this.blockEntity.getResultTank().getFluidValueInTank());
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.resultTankGauge.renderTooltip(guiGraphics, x, y, this.font);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 5726575, false);
    }
}

