/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.config;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.config.CommonConfig;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;

public class ConfigManager {
    public static CommonConfig loadOrGenerateDefaults() {
        Path systemsFile = Platform.getConfigFolder().resolve("stellaris-config.json");
        try {
            BufferedReader reader = Files.newBufferedReader(systemsFile);
            CommonConfig config = (CommonConfig)Stellaris.GSON.fromJson((Reader)reader, CommonConfig.class);
            FileWriter writer = new FileWriter(systemsFile.toFile());
            Stellaris.GSON.toJson((Object)config, (Appendable)writer);
            ((Writer)writer).close();
            return config;
        }
        catch (Exception e) {
            if (!(e instanceof NoSuchFileException)) {
                e.printStackTrace();
            }
            try {
                File folder = systemsFile.toFile().getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                FileWriter writer = new FileWriter(systemsFile.toFile());
                Stellaris.GSON.toJson((Object)new CommonConfig(), (Appendable)writer);
                ((Writer)writer).close();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return new CommonConfig();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface InnerConfig {
    }
}

