/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.config.CommonConfig;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SyncConfigPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncConfigPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"sync_config"));
    private final String config;
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncConfigPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SyncConfigPacket>(){

        @NotNull
        public SyncConfigPacket decode(RegistryFriendlyByteBuf buf) {
            return new SyncConfigPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, SyncConfigPacket packet) {
            buf.writeUtf(packet.config);
        }
    };

    public SyncConfigPacket(RegistryFriendlyByteBuf buffer) {
        this.config = buffer.readUtf();
    }

    public SyncConfigPacket(CommonConfig config) {
        this.config = Stellaris.GSON.toJson((Object)config, CommonConfig.class);
    }

    public static void handle(SyncConfigPacket packet, NetworkManager.PacketContext context) {
        CommonConfig config;
        try {
            config = (CommonConfig)Stellaris.GSON.fromJson(packet.config, CommonConfig.class);
        }
        catch (Exception e) {
            Stellaris.LOG.error("Failed to parse config packet: {}", (Object)e.getMessage());
            config = new CommonConfig();
        }
        Stellaris.CONFIG = config;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

