/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.CoalGeneratorEntity;
import com.st0x0ef.stellaris.common.menus.CoalGeneratorMenu;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CoalGeneratorScreen
extends AbstractContainerScreen<CoalGeneratorMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocationUtils.guiTexture("coal_generator");
    private final CoalGeneratorEntity blockEntity = ((CoalGeneratorMenu)this.getMenu()).getBlockEntity();
    private GaugeWidget energyGauge;

    public CoalGeneratorScreen(CoalGeneratorMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.titleLabelX = (180 - Minecraft.getInstance().font.width(this.title.getString())) / 2;
        this.titleLabelY = 2;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge = new GaugeWidget(this.leftPos + 68, this.topPos + 20, 44, 6, (Component)Component.translatable((String)"stellaris.screen.energyContainer"), GUISprites.SIDEWAYS_ENERGY_FULL, null, this.blockEntity.getEnergy(null).getMaxEnergy(), GaugeWidget.Direction4.LEFT_RIGHT);
        this.addRenderableWidget((GuiEventListener)this.energyGauge);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.blockEntity == null) {
            return;
        }
        this.energyGauge.updateAmount(this.blockEntity.getEnergy(null).getEnergy());
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        if (((CoalGeneratorMenu)this.menu).isLit()) {
            int i = Mth.ceil((float)(((CoalGeneratorMenu)this.menu).getLitProgress() * 11.0f)) + 1;
            graphics.blitSprite(GUISprites.COAL_GENERATOR_LIT_PROGRESS_SPRITE, 14, 11, 0, 12 - i, this.leftPos + 99, this.topPos + 68 - i, 12, i);
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.energyGauge.renderTooltip(guiGraphics, x, y, this.font);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 5726575, false);
    }
}

