/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.tablet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntryScreen;
import com.st0x0ef.stellaris.common.menus.TabletMenu;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TabletMainScreen
extends AbstractContainerScreen<TabletMenu> {
    public static final ResourceLocation BACKGROUND = ResourceLocationUtils.guiTexture("tablet/tablet_background");
    public static final ResourceLocation MAIN_PAGE_TEXTURE = ResourceLocationUtils.guiTexture("tablet/main_page");
    public static final ResourceLocation MAIN_PAGE_HOVER_TEXTURE = ResourceLocationUtils.guiTexture("tablet/main_page_hover");
    public static Map<String, TabletEntry> ENTRIES = new HashMap<String, TabletEntry>();
    public static Map<ResourceLocation, TabletEntry.ItemInfo> INFOS = new HashMap<ResourceLocation, TabletEntry.ItemInfo>();
    public List<Component> STATS = new ArrayList<Component>();
    public ResourceLocation directEntry = null;
    public static ArrayList<TexturedButton> BUTTONS = new ArrayList();

    public TabletMainScreen(TabletMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, (Component)Component.literal((String)"Tablet"));
        this.imageHeight = 162;
        this.imageWidth = 250;
        if (menu.getEntry() != null && !menu.getEntry().getNamespace().equals("null")) {
            this.directEntry = menu.getEntry();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void init() {
        super.init();
        this.STATS = this.getStats();
        AtomicInteger column = new AtomicInteger(0);
        BUTTONS.clear();
        ENTRIES.forEach((id, entry) -> {
            Object button = ((TexturedButton)((Object)((Object)new TexturedButton(this.leftPos + 61 + column.get() * 28, this.topPos + 129, 18, 18, (Component)Component.translatable((String)entry.id()), button1 -> this.minecraft.setScreen((Screen)new TabletEntryScreen((Component)Component.translatable((String)entry.id()), this, this.leftPos, this.topPos, (TabletEntry)entry))).tex(entry.icon(), entry.hoverIcon())))).tooltip(Tooltip.create((Component)Component.translatable((String)entry.id())));
            column.getAndIncrement();
            BUTTONS.add((TexturedButton)((Object)((Object)button)));
            this.addRenderableWidget((GuiEventListener)button);
            if (BUTTONS.size() == 2) {
                Object homeButton = ((TexturedButton)((Object)((Object)new TexturedButton(this.leftPos + 61 + column.get() * 28, this.topPos + 129, 18, 18, (Component)Component.translatable((String)entry.id()), button1 -> this.minecraft.setScreen((Screen)this)).tex(MAIN_PAGE_TEXTURE, MAIN_PAGE_HOVER_TEXTURE)))).tooltip(Tooltip.create((Component)Component.literal((String)"Home")));
                BUTTONS.add((TexturedButton)((Object)((Object)homeButton)));
                column.getAndIncrement();
                this.addRenderableWidget((GuiEventListener)homeButton);
            }
        });
        if (this.directEntry != null) {
            this.openEntry(this.directEntry);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        for (int i = 0; i < this.STATS.size(); ++i) {
            guiGraphics.drawString(this.font, this.STATS.get(i), this.leftPos + 90, this.topPos + 55 + i * 10, 0xFFFFFF);
        }
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 50), (int)(this.topPos + 45), (int)(this.leftPos + 80), (int)(this.topPos + 115), (int)30, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.minecraft.player);
    }

    public List<Component> getStats() {
        ArrayList<Component> stats = new ArrayList<Component>();
        if (this.minecraft != null) {
            StatsCounter statsCounter = this.minecraft.player.getStats();
            AtomicInteger bossKilled = new AtomicInteger(0);
            for (EntityType entityType : BuiltInRegistries.ENTITY_TYPE) {
                if ((!entityType.is(TagRegistry.ENTITY_BOSS) || statsCounter.getValue(Stats.ENTITY_KILLED.get((Object)entityType)) <= 0) && statsCounter.getValue(Stats.ENTITY_KILLED_BY.get((Object)entityType)) <= 0) continue;
                bossKilled.incrementAndGet();
            }
            stats.add((Component)Component.translatable((String)"stellaris.screen.tablet.rocket_launched", (Object[])new Object[]{statsCounter.getValue(Stats.CUSTOM.get((Object)((ResourceLocation)StatsRegistry.ROCKET_LAUNCHED.get())))}));
            stats.add((Component)Component.translatable((String)"stellaris.screen.tablet.space_traveled", (Object[])new Object[]{statsCounter.getValue(Stats.CUSTOM.get((Object)((ResourceLocation)StatsRegistry.SPACE_TRAVEL.get())))}));
            stats.add((Component)Component.translatable((String)"stellaris.screen.tablet.boss_killed", (Object[])new Object[]{bossKilled.get()}));
        }
        return stats;
    }

    public void openEntry(ResourceLocation location) {
        if (INFOS.containsKey(location) && this.minecraft != null) {
            Screen screen;
            TabletEntry entry = ENTRIES.get(location.getNamespace());
            TabletEntry.ItemInfo info = INFOS.get(location);
            this.minecraft.setScreen((Screen)new TabletEntryScreen((Component)Component.translatable((String)entry.id()), this, this.leftPos, this.topPos, entry));
            if (this.minecraft != null && (screen = this.minecraft.screen) instanceof TabletEntryScreen) {
                TabletEntryScreen screen2 = (TabletEntryScreen)screen;
                screen2.changeInfo(info);
            }
        }
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }
}

