/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.windows;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class MoveableWindow
extends AbstractWidget
implements Renderable,
GuiEventListener {
    private boolean dragging = false;
    private int windowX;
    private int windowY;
    public double dragOffsetX = 0.0;
    public double dragOffsetY = 0.0;
    public int moveLimit;
    public final Map<AbstractWidget, int[]> initialWidgetOffsets = new HashMap<AbstractWidget, int[]>();
    public Render render;
    public Screen parent;

    public MoveableWindow(int width, int height, Component message, Screen parent) {
        this(width, height, message, parent, null);
    }

    public MoveableWindow(int width, int height, Component message, Screen parent, Render render) {
        super(parent.width / 2 - width / 2, parent.height / 2 - height / 2, width, height, message);
        this.parent = parent;
        this.render = render;
        this.windowX = this.getX();
        this.windowY = this.getY();
        this.moveLimit = height;
    }

    public abstract void renderWindow(GuiGraphics var1, int var2, int var3, float var4);

    public void init() {
    }

    public void close() {
        this.changeVisibility(false);
    }

    public void renderWidgets(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (AbstractWidget widget : this.initialWidgetOffsets.keySet()) {
            widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public Consumer<MoveableWindow> resize(Minecraft minecraft, int width, int height) {
        return window -> {};
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.render != null) {
            this.render.render(this);
        }
        this.renderWindow(guiGraphics, mouseX, mouseY, partialTick);
        this.updateWidgetPositions();
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.mouseInside(mouseX, mouseY)) {
            this.dragging = true;
            this.dragOffsetX = mouseX - (double)this.windowX;
            this.dragOffsetY = mouseY - (double)this.windowY;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.dragging) {
            this.windowX = (int)(mouseX - this.dragOffsetX);
            this.windowY = (int)(mouseY - this.dragOffsetY);
            this.setX(this.windowX);
            this.setY(this.windowY);
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private void updateWidgetPositions() {
        for (AbstractWidget widget : this.initialWidgetOffsets.keySet()) {
            int[] offset = this.initialWidgetOffsets.get(widget);
            widget.setX(this.windowX + offset[0]);
            widget.setY(this.windowY + offset[1]);
        }
    }

    public void changeVisibility(boolean visible) {
        this.visible = visible;
        for (AbstractWidget widget : this.initialWidgetOffsets.keySet()) {
            widget.visible = visible;
        }
    }

    public <T extends AbstractWidget> void addWidget(T widget) {
        int relativeX = widget.getX() - this.windowX;
        int relativeY = widget.getY() - this.windowY;
        this.initialWidgetOffsets.put(widget, new int[]{relativeX, relativeY});
    }

    public boolean mouseInside(double mouseX, double mouseY) {
        return mouseX >= (double)this.windowX && mouseX <= (double)(this.windowX + this.width) && mouseY >= (double)this.windowY && mouseY <= (double)(this.windowY + this.getMoveLimit());
    }

    public int getWindowX() {
        return this.windowX;
    }

    public int getWindowY() {
        return this.windowY;
    }

    public int getMoveLimit() {
        return this.height;
    }

    public static interface Render {
        public void render(MoveableWindow var1);
    }
}

