/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities;

import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ImplementedInventory
extends WorldlyContainer {
    public NonNullList<ItemStack> getItems();

    public static ImplementedInventory of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ImplementedInventory ofSize(int size) {
        return ImplementedInventory.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    default public int @NotNull [] getSlotsForFace(Direction direction) {
        int[] result = new int[this.getItems().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    default public boolean canPlaceItemThroughFace(int i, ItemStack itemStack, @Nullable Direction direction) {
        return true;
    }

    default public boolean canTakeItemThroughFace(int i, ItemStack itemStack, Direction direction) {
        return true;
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack getItem(int i) {
        return (ItemStack)this.getItems().get(i);
    }

    @NotNull
    default public ItemStack removeItem(int i, int j) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)i, (int)j);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int i) {
        return ContainerHelper.takeItem(this.getItems(), (int)i);
    }

    default public void setItem(int i, ItemStack itemStack) {
        this.getItems().set(i, (Object)itemStack);
        if (itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void clearContent() {
        this.getItems().clear();
    }
}

