/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.PowerBankBlock;
import com.st0x0ef.stellaris.common.menus.PowerBankMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.energy.EnergyUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PowerBankEntity
extends BaseEnergyContainerBlockEntity {
    private int renderStage = -1;

    public PowerBankEntity(BlockPos pos, BlockState state) {
        this(pos, state, ((PowerBankBlock)state.getBlock()).tier);
    }

    public PowerBankEntity(BlockPos pos, BlockState state, int tier) {
        super(BlockEntityRegistry.POWER_BANK.get(), pos, state, (int)Math.pow(2.0, 4 * tier) * 1000, (int)Math.pow(2.0, 4 * tier) * 1000, (int)Math.pow(2.0, 4 * tier) * 1000);
    }

    @Override
    public void tick() {
        int initialRenderStage = this.renderStage;
        if (!((ItemStack)this.items.getFirst()).isEmpty()) {
            EnergyUtil.moveEnergyFromItem((UniversalEnergyStorage)this.energyContainer, (ItemStack)this.items.getFirst(), this.energyContainer.getMaxEnergy() / 40);
        }
        if (!((ItemStack)this.items.getLast()).isEmpty()) {
            EnergyUtil.moveEnergyToItem((UniversalEnergyStorage)this.energyContainer, (ItemStack)this.items.getLast(), this.energyContainer.getMaxEnergy() / 40);
        }
        EnergyUtil.distributeEnergyNearby(this.level, this.worldPosition, this.energyContainer.getMaxEnergy() / 20);
        this.renderStage = this.energyContainer.getEnergy() * 9 / this.energyContainer.getMaxEnergy();
        if (initialRenderStage != this.renderStage) {
            BlockState state = (BlockState)this.getBlockState().setValue((Property)PowerBankBlock.STAGE, (Comparable)Integer.valueOf(this.renderStage));
            this.level.setBlock(this.getBlockPos(), state, 3);
            this.setChanged();
        }
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"screen.stellaris.power_bank");
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new PowerBankMenu(containerId, inventory, (Container)this, this);
    }
}

