/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.commands.LaunchPadArgument;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadLauncher;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.menus.TestMenu;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StellarisCommands {
    public StellarisCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stellaris").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"oil").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ChunkAccess access = ((CommandSourceStack)context.getSource()).getPlayer().level().getChunk(((CommandSourceStack)context.getSource()).getPlayer().getOnPos());
            access.stellaris$setChunkOilLevel(((Integer)context.getArgument("level", Integer.class)).intValue());
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)("Oil Level : " + access.stellaris$getChunkOilLevel())));
            return 0;
        })))).then(Commands.literal((String)"get").executes(context -> {
            ChunkAccess access = ((CommandSourceStack)context.getSource()).getPlayer().level().getChunk(((CommandSourceStack)context.getSource()).getPlayer().getOnPos());
            ((CommandSourceStack)context.getSource()).getPlayer().sendSystemMessage((Component)Component.literal((String)("Oil Level : " + access.stellaris$getChunkOilLevel())));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"screen").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"galaxyScreen").executes(context -> {
            PlanetUtil.openMilkyWayMenu((Player)((CommandSourceStack)context.getSource()).getPlayer());
            return 0;
        }))).then(Commands.literal((String)"tablet").executes(context -> {
            PlanetUtil.openTabletMenu((Player)((CommandSourceStack)context.getSource()).getPlayer(), ResourceLocation.parse((String)"null:null"));
            return 0;
        }))).then(Commands.literal((String)"waitScreen").executes(context -> {
            PlanetUtil.openWaitMenu((Player)((CommandSourceStack)context.getSource()).getPlayer(), ((CommandSourceStack)context.getSource()).getPlayer().getDisplayName().getString());
            return 0;
        }))).then(Commands.literal((String)"planetScreen").executes(context -> {
            PlanetUtil.openPlanetSelectionMenu((Player)((CommandSourceStack)context.getSource()).getPlayer(), true, "stellaris:milky_way");
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"test").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"dumpPlanetInfos").executes(context -> {
            for (Planet planet : StellarisData.getPlanets()) {
                Stellaris.LOG.info(planet.name());
                Stellaris.LOG.info("[br] [br] Temperature : [color=red]{}\u00b0c [br] Gravity : [color=red]{} [br] Oxygen : [color=red]{} [br] Distance From Earth : {}km", new Object[]{Float.valueOf(planet.temperature()), Float.valueOf(planet.gravity()), planet.oxygen(), planet.distanceFromEarth()});
            }
            return 0;
        }))).then(Commands.literal((String)"getAntennaPos").then(Commands.argument((String)"size", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            BlockPos pos = ((CommandSourceStack)context.getSource()).getPlayer().blockPosition();
            int size = IntegerArgumentType.getInteger((CommandContext)context, (String)"size");
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    for (int k = 0; k < size; ++k) {
                        BlockPos antennaPos = pos.offset(i, j, k);
                        ServerLevel level = ((CommandSourceStack)context.getSource()).getPlayer().serverLevel();
                        BlockState state = level.getBlockState(antennaPos);
                        if (!state.is(BlockTags.WOOL)) continue;
                        Vec3 offset = new Vec3((double)i, (double)j, (double)k);
                        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Antenna should be placed at " + antennaPos.toShortString() + "\nOffest is " + String.valueOf(offset))), false);
                        return 0;
                    }
                }
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No Pink Wool Block found in the area"));
            return 0;
        })))).then(Commands.literal((String)"testScreen").executes(context -> {
            ExtendedMenuProvider provider = new ExtendedMenuProvider(this){

                public void saveExtraData(FriendlyByteBuf buffer) {
                }

                public Component getDisplayName() {
                    return Component.literal((String)"Planets");
                }

                @NotNull
                public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                    FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                    return TestMenu.create(syncId, inv, buffer);
                }
            };
            MenuRegistry.openExtendedMenu((ServerPlayer)((CommandSourceStack)context.getSource()).getPlayer(), (ExtendedMenuProvider)provider);
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"launchpads").then(Commands.literal((String)"create").then(Commands.argument((String)"dimension", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.DIMENSION)).then(Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"public", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            LaunchPad launchPad = new LaunchPad(LaunchPadLauncher.LAUNCH_PADS.launchPads().size(), Utils.blockPosToVec3(Vec3Argument.getCoordinates((CommandContext)context, (String)"pos").getBlockPos((CommandSourceStack)context.getSource())), (ResourceKey<Level>)((ResourceKey)context.getArgument("dimension", ResourceKey.class)), StringArgumentType.getString((CommandContext)context, (String)"name"), BoolArgumentType.getBool((CommandContext)context, (String)"public"), Objects.requireNonNull(((CommandSourceStack)context.getSource()).getPlayer()).getDisplayName().getString(), new ArrayList<String>());
            LaunchPadLauncher.addLaunchPad(launchPad, ((CommandSourceStack)context.getSource()).getServer());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Space Station " + StringArgumentType.getString((CommandContext)context, (String)"name") + " Created")), true);
            return 1;
        }))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(c -> c.hasPermission(2))).then(Commands.argument((String)"dimension", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.DIMENSION)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            LaunchPad pad = LaunchPadUtils.getPadByNameAndDim(StringArgumentType.getString((CommandContext)context, (String)"name"), (ResourceKey<Level>)((ResourceKey)context.getArgument("dimension", ResourceKey.class)));
            if (pad != null && LaunchPadLauncher.removeLaunchpad(pad.id(), ((CommandSourceStack)context.getSource()).getServer())) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Space Station " + StringArgumentType.getString((CommandContext)context, (String)"name") + " Deleted")), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Space Station " + StringArgumentType.getString((CommandContext)context, (String)"name") + " Not Found")));
            }
            return 1;
        })))).then(((RequiredArgumentBuilder)Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).requires(c -> c.hasPermission(2))).executes(context -> {
            LaunchPad pad = LaunchPadUtils.getPadById(IntegerArgumentType.getInteger((CommandContext)context, (String)"id"));
            if (pad != null && LaunchPadLauncher.removeLaunchpad(pad.id(), ((CommandSourceStack)context.getSource()).getServer())) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Space Station " + pad.id() + " Deleted")), true);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Space Station " + StringArgumentType.getString((CommandContext)context, (String)"name") + " Not Found")));
            }
            return 1;
        })))).then(Commands.literal((String)"share").then(Commands.argument((String)"launchpad", (ArgumentType)new LaunchPadArgument()).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            LaunchPad launchPad = LaunchPadUtils.getPadByNameAndPlayer(StringArgumentType.getString((CommandContext)context, (String)"launchpad"), (Player)((CommandSourceStack)context.getSource()).getPlayer());
            if (launchPad == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.stellaris.launchpad_dont_exist"));
                return 0;
            }
            if (!launchPad.owner().equals(player.getName().getString())) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.stellaris.launchpad_not_yours"));
                return 0;
            }
            if (((CommandSourceStack)context.getSource()).getPlayer().getName().equals((Object)player.getName())) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"message.stellaris.launchpad_share_yourself"));
                return 0;
            }
            if (launchPad.whitelist().contains(player.getDisplayName().getString())) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Player " + player.getName().getString() + " already has access to this launchpad")));
                return 0;
            }
            LaunchPadLauncher.modifyLaunchPad(LaunchPadUtils.whitelistPlayer(launchPad, (Player)player), ((CommandSourceStack)context.getSource()).getServer());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> StellarisCommands.lambda$new$21((Player)player, launchPad), false);
            return 1;
        }))))).then(Commands.literal((String)"list").executes(context -> {
            MutableComponent component = Component.empty().append((Component)Component.literal((String)"Your LaunchPads : \n").withStyle(ChatFormatting.UNDERLINE));
            LaunchPadUtils.getPlayerLaunchPad((Player)((CommandSourceStack)context.getSource()).getPlayer()).forEach(launchPad -> {
                component.append(launchPad.name()).append(" (").append((Component)Component.literal((String)launchPad.dimension().location().toString()).withColor(Utils.getColorHexCode("gray"))).append(") ");
                if (launchPad.isPublic().booleanValue()) {
                    component.append((Component)Component.literal((String)"[Private] ").withColor(Utils.getColorHexCode("GREEN")));
                } else {
                    component.append((Component)Component.literal((String)"[Public] ").withColor(Utils.getColorHexCode("GREEN")));
                }
                component.append("\n");
            });
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
            return 1;
        }))));
    }

    private static /* synthetic */ Component lambda$new$21(Player player, LaunchPad launchPad) {
        return Component.translatable((String)"message.stellaris.launchpad_share_success", (Object[])new Object[]{player.getName(), launchPad.name()});
    }
}

