/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.phys.Vec3;

public abstract class IVehicleEntity
extends Entity {
    public int FUEL;
    public FuelType.Type FUEL_TYPE = FuelType.Type.FUEL;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float speed;
    private boolean discardFriction = false;
    public float xxa;
    public float yya;
    public float zza;

    public IVehicleEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public boolean isPickable() {
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public void tick() {
        super.tick();
        this.tickLerp();
        this.rotAnim();
        Vec3 vec3 = this.getDeltaMovement();
        double d1 = vec3.x;
        double d3 = vec3.y;
        double d5 = vec3.z;
        if (Math.abs(vec3.x) < 0.003) {
            d1 = 0.0;
        }
        if (Math.abs(vec3.y) < 0.003) {
            d3 = 0.0;
        }
        if (Math.abs(vec3.z) < 0.003) {
            d5 = 0.0;
        }
        this.setDeltaMovement(d1, d3, d5);
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
        this.travel(new Vec3((double)this.xxa, (double)this.yya, (double)this.zza));
    }

    public void rotAnim() {
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = steps;
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double d2 = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double d4 = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double d6 = Mth.wrapDegrees((double)(this.lerpYRot - (double)this.getYRot()));
            this.setYRot(this.getYRot() + (float)d6 / (float)this.lerpSteps);
            this.setXRot(this.getXRot() + (float)(this.lerpXRot - (double)this.getXRot()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(d0, d2, d4);
            this.setRot(this.getYRot(), this.getXRot());
        }
    }

    public void travel(Vec3 vec3) {
        if (this.isControlledByLocalInstance()) {
            boolean flag;
            double d0 = 0.08;
            boolean bl = flag = this.getDeltaMovement().y <= 0.0;
            if (this.isInWater()) {
                double d8 = this.getY();
                float f5 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                float f6 = 0.02f;
                this.moveRelative(f6, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                Vec3 vec36 = this.getDeltaMovement();
                if (this.horizontalCollision) {
                    vec36 = new Vec3(vec36.x, 0.2, vec36.z);
                }
                this.setDeltaMovement(vec36.multiply((double)f5, (double)0.8f, (double)f5));
                Vec3 vec32 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                this.setDeltaMovement(vec32);
                if (this.horizontalCollision && this.isFree(vec32.x, vec32.y + (double)0.6f - this.getY() + d8, vec32.z)) {
                    this.setDeltaMovement(vec32.x, 0.3f, vec32.z);
                }
            } else if (this.isInLava()) {
                double d7 = this.getY();
                this.moveRelative(0.02f, vec3);
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, (double)0.8f, 0.5));
                    Vec3 vec33 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec33);
                } else {
                    this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
                }
                if (!this.isNoGravity()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d0 / 4.0, 0.0));
                }
                Vec3 vec34 = this.getDeltaMovement();
                if (this.horizontalCollision && this.isFree(vec34.x, vec34.y + (double)0.6f - this.getY() + d7, vec34.z)) {
                    this.setDeltaMovement(vec34.x, 0.3f, vec34.z);
                }
            } else {
                BlockPos blockpos = this.getBlockPosBelowThatAffectsMyMovement();
                float f3 = 1.0f;
                float f4 = this.onGround() ? f3 * 0.91f : 0.91f;
                Vec3 vec35 = this.handleRelativeFrictionAndCalculateMovement(vec3, f3);
                double d2 = vec35.y;
                if (this.level().isClientSide && !this.level().hasChunkAt(blockpos)) {
                    d2 = this.getY() > (double)this.level().getMinBuildHeight() ? -0.1 : 0.0;
                } else if (!this.isNoGravity()) {
                    d2 -= d0;
                }
                if (this.shouldDiscardFriction()) {
                    this.setDeltaMovement(vec35.x, d2, vec35.z);
                } else {
                    this.setDeltaMovement(vec35.x * (double)f4, d2 * (double)0.98f, vec35.z * (double)f4);
                }
            }
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public Vec3 getFluidFallingAdjustedMovement(double p_20995_, boolean flag, Vec3 deltaMovement) {
        if (!this.isNoGravity() && !this.isSprinting()) {
            double d0 = flag && Math.abs(deltaMovement.y - 0.005) >= 0.003 && Math.abs(deltaMovement.y - p_20995_ / 16.0) < 0.003 ? -0.003 : deltaMovement.y - p_20995_ / 16.0;
            return new Vec3(deltaMovement.x, d0, deltaMovement.z);
        }
        return deltaMovement;
    }

    public float getFrictionInfluencedSpeed(float delta) {
        return this.getSpeed() * (0.216f / (delta * delta * delta));
    }

    public Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 vector, float delta) {
        this.moveRelative(this.getFrictionInfluencedSpeed(delta), vector);
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 vec3 = this.getDeltaMovement();
        if (this.horizontalCollision && this.getBlockStateOn().is(Blocks.POWDER_SNOW) && PowderSnowBlock.canEntityWalkOnPowderSnow((Entity)this)) {
            vec3 = new Vec3(vec3.x, 0.2, vec3.z);
        }
        return vec3;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean discardFriction) {
        this.discardFriction = discardFriction;
    }

    public void setEntityRotation(Entity vehicle, float rotation) {
        vehicle.setYRot(vehicle.getYRot() + rotation);
        vehicle.setYBodyRot(vehicle.getYRot());
        vehicle.yRotO = vehicle.getYRot();
    }

    public int getFuel() {
        return this.FUEL;
    }

    public FuelType.Type getFuelType() {
        return this.FUEL_TYPE;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)entity);
    }

    public boolean setPassengersRiding() {
        return true;
    }
}

