/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.fej1fun.potentials.fluid.ItemFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidCellItem
extends Item
implements FluidProvider.ITEM {
    public FluidCellItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        UniversalFluidItemStorage storage = this.getFluidTank(stack);
        if (!storage.getFluidInTank(0).isEmpty()) {
            tooltipComponents.add((Component)storage.getFluidInTank(0).getName().copy().withStyle(ChatFormatting.GRAY));
        }
        tooltipComponents.add((Component)Component.literal((String)(storage.getFluidInTank(0).getAmount() + "/" + storage.getTankCapacity(0) + "mb")).withStyle(ChatFormatting.GRAY));
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getFluidTank(stack).getFluidInTank(0).getAmount() > 0L;
    }

    public int getBarWidth(ItemStack stack) {
        UniversalFluidItemStorage storage = this.getFluidTank(stack);
        return (int)Mth.clamp((long)((storage.getFluidInTank(0).getAmount() + 1L) * 13L / storage.getTankCapacity(0)), (long)0L, (long)13L);
    }

    public int getBarColor(ItemStack stack) {
        return 8255999;
    }

    @Nullable
    public UniversalFluidItemStorage getFluidTank(@NotNull ItemStack stack) {
        return new ItemFluidStorage(this, (DataComponentType)DataComponentsRegistry.FLUID_LIST.get(), stack, 1, 1000L){};
    }
}

