/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.DieselGeneratorBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.menus.slot.ResultSlot;
import com.st0x0ef.stellaris.common.menus.slot.SpecificFluidContainerSlot;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.material.Fluid;

public class DieselGeneratorMenu
extends BaseContainer {
    private final Container container;
    private final DieselGeneratorBlockEntity blockEntity;

    public static DieselGeneratorMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        DieselGeneratorBlockEntity blockEntity = (DieselGeneratorBlockEntity)inventory.player.level().getBlockEntity(buf.readBlockPos());
        return new DieselGeneratorMenu(containerId, inventory, (Container)new SimpleContainer(2), blockEntity);
    }

    public DieselGeneratorMenu(int containerId, Inventory inventory, Container container, DieselGeneratorBlockEntity blockEntity) {
        super((MenuType)MenuTypesRegistry.DIESEL_GENERATOR_MENU.get(), containerId, 2, inventory, 10, 106);
        this.container = container;
        this.blockEntity = blockEntity;
        this.addSlot(new SpecificFluidContainerSlot(container, (Fluid)FluidRegistry.DIESEL_STILL.get(), 0, 42, 40, false));
        this.addSlot(new ResultSlot(container, 1, 42, 74));
    }

    @Override
    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public DieselGeneratorBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

