/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadLauncher;
import com.st0x0ef.stellaris.common.network.NetworkRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class LaunchPadsOperations
implements CustomPacketPayload {
    private final LaunchPad launchPad;
    private final String action;
    public static final StreamCodec<RegistryFriendlyByteBuf, LaunchPadsOperations> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, LaunchPadsOperations>(){

        @NotNull
        public LaunchPadsOperations decode(RegistryFriendlyByteBuf buf) {
            return new LaunchPadsOperations(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, LaunchPadsOperations packet) {
            LaunchPad.toBuffer(packet.launchPad, buf);
            buf.writeUtf(packet.action);
        }
    };

    public LaunchPadsOperations(RegistryFriendlyByteBuf buffer) {
        this.launchPad = LaunchPad.readFromBuffer(buffer);
        this.action = buffer.readUtf();
    }

    public LaunchPadsOperations(LaunchPad planets, String action) {
        this.launchPad = planets;
        this.action = action;
    }

    public static void handle(LaunchPadsOperations packet, NetworkManager.PacketContext context) {
        LaunchPad launchPad = packet.launchPad;
        Level level = context.getPlayer().level();
        switch (packet.action) {
            case "add": {
                LaunchPadLauncher.addLaunchPad(launchPad, context.getPlayer().getServer());
                break;
            }
            case "modify": {
                LaunchPadLauncher.modifyLaunchPad(launchPad, context.getPlayer().getServer());
                break;
            }
            case "remove": {
                LaunchPadLauncher.removeLaunchpad(launchPad.id(), context.getPlayer().getServer());
                break;
            }
            case "setLaunchPad": {
                BlockEntity blockEntity = context.getPlayer().level().getBlockEntity(Utils.getBlockPosFromVector3i(launchPad.position()));
                if (!(blockEntity instanceof AntennaBlockEntity)) break;
                AntennaBlockEntity blockEntity2 = (AntennaBlockEntity)blockEntity;
                blockEntity2.launchPadId = launchPad.id();
                blockEntity2.setChanged();
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return NetworkRegistry.LAUNCH_PADS_OPERATION;
    }
}

