/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.network.packets;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.BaseFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record SyncFluidPacketWithoutDirection(FluidAmountMapDataComponent fluid, int tank, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncFluidPacketWithoutDirection> TYPE = new CustomPacketPayload.Type(ResourceLocationUtils.id("fluid_sync_packet_without_direction"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncFluidPacketWithoutDirection> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidAmountMapDataComponent.STREAM_CODEC, SyncFluidPacketWithoutDirection::fluid, (StreamCodec)ByteBufCodecs.VAR_INT, SyncFluidPacketWithoutDirection::tank, (StreamCodec)BlockPos.STREAM_CODEC, SyncFluidPacketWithoutDirection::pos, SyncFluidPacketWithoutDirection::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncFluidPacketWithoutDirection data, NetworkManager.PacketContext context) {
        context.queue(() -> {
            BlockEntity patt0$temp;
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && (patt0$temp = level.getBlockEntity(data.pos)) instanceof FluidProvider.BLOCK) {
                FluidProvider.BLOCK fluidProvider = (FluidProvider.BLOCK)patt0$temp;
                UniversalFluidStorage patt1$temp = fluidProvider.getFluidTank(null);
                if (patt1$temp instanceof BaseFluidStorage) {
                    BaseFluidStorage fluidStorage = (BaseFluidStorage)patt1$temp;
                    fluidStorage.setFluidInTank(data.tank, FluidStack.create((FluidStack)data.fluid.getAsFluidStack(0), (long)data.fluid.getAmount(0)));
                } else {
                    UniversalFluidStorage patt2$temp = fluidProvider.getFluidTank(null);
                    if (patt2$temp instanceof SingleFluidStorage) {
                        SingleFluidStorage fluidStorage = (SingleFluidStorage)patt2$temp;
                        fluidStorage.setFluidInTank(FluidStack.create((FluidStack)data.fluid.getAsFluidStack(0), (long)data.fluid.getAmount(0)));
                    }
                }
            }
        });
    }
}

