/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils.capabilities.fluid;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.BaseFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import dev.architectury.fluid.FluidStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class FluidUtil {
    public static void moveFluidToItem(int tank, UniversalFluidStorage from, int slot, NonNullList<ItemStack> items, long amount) {
        if (((ItemStack)items.get(slot)).isEmpty()) {
            return;
        }
        UniversalFluidItemStorage to = (UniversalFluidItemStorage)Capabilities.Fluid.ITEM.getCapability((ItemStack)items.get(slot));
        if (to == null) {
            return;
        }
        amount = Math.min(amount, to.getTankCapacity(0) - to.getFluidInTank(0).getAmount());
        FluidUtil.moveFluid(from, (UniversalFluidStorage)to, from.getFluidInTank(tank).copyWithAmount(amount));
        items.set(slot, (Object)to.getContainer());
    }

    public static void moveFluidFromItem(int tank, int slot, NonNullList<ItemStack> items, UniversalFluidStorage to, long amount) {
        if (((ItemStack)items.get(slot)).isEmpty()) {
            return;
        }
        UniversalFluidItemStorage from = (UniversalFluidItemStorage)Capabilities.Fluid.ITEM.getCapability((ItemStack)items.get(slot));
        if (from == null) {
            return;
        }
        amount = Math.min(amount, to.getTankCapacity(tank) - to.getFluidInTank(tank).getAmount());
        FluidUtil.moveFluid((UniversalFluidStorage)from, to, from.getFluidInTank(tank).copyWithAmount(amount));
        items.set(slot, (Object)from.getContainer());
    }

    public static FluidStack moveFluid(UniversalFluidStorage from, UniversalFluidStorage to, FluidStack stack) {
        if (stack.isEmpty()) {
            return FluidStack.empty();
        }
        FluidStack inserted = FluidStack.create((FluidStack)stack, (long)to.fill(from.drain(stack, true), true));
        if (inserted.isEmpty()) {
            return FluidStack.empty();
        }
        from.drain(inserted.copy(), false);
        to.fill(inserted.copy(), false);
        return inserted;
    }

    public static FluidStack moveFluidWithSet(BaseFluidStorage from, BaseFluidStorage to, FluidStack stack) {
        FluidStack inserted = FluidStack.create((FluidStack)stack, (long)to.fill(from.drain(stack, true), true));
        if (inserted.isEmpty()) {
            return FluidStack.empty();
        }
        from.drainWithoutLimits(inserted, false);
        to.fillWithoutLimits(inserted, false);
        return inserted;
    }

    public static void distributeFluidNearby(Level level, BlockPos pos, FluidStack stack) {
        FluidUtil.distributeFluidNearby(level, pos, stack, null);
    }

    public static void distributeFluidNearby(Level level, BlockPos pos, FluidStack stack, List<Direction> outputDirections) {
        if (outputDirections == null || outputDirections.isEmpty()) {
            FluidUtil.distributeInAllDirections(level, pos, stack);
            return;
        }
        FluidUtil.distributeInDirections(level, pos, stack, outputDirections);
    }

    private static long distributeInDirections(Level level, BlockPos pos, FluidStack stack, List<Direction> outputDirections) {
        HashMap<UniversalFluidStorage, UniversalFluidStorage> pairs = new HashMap<UniversalFluidStorage, UniversalFluidStorage>();
        for (Direction direction : outputDirections) {
            UniversalFluidStorage to;
            FluidStack drained;
            UniversalFluidStorage from = (UniversalFluidStorage)Capabilities.Fluid.BLOCK.getCapability(level, pos, (Object)direction);
            if (from == null || (drained = from.drain(stack, true)).getAmount() <= 0L || (to = (UniversalFluidStorage)Capabilities.Fluid.BLOCK.getCapability(level, pos.relative(direction), (Object)direction.getOpposite())) == null || to.fill(drained, true) <= 0L) continue;
            pairs.put(from, to);
        }
        AtomicLong toDistribute = new AtomicLong(stack.getAmount());
        AtomicLong receivers = new AtomicLong(pairs.size());
        pairs.forEach((energyFrom, energyTo) -> {
            toDistribute.addAndGet(-FluidUtil.moveFluid(energyFrom, energyTo, stack.copyWithAmount(toDistribute.get() / receivers.get())).getAmount());
            receivers.getAndDecrement();
        });
        return stack.getAmount() - toDistribute.get();
    }

    private static void distributeInAllDirections(Level level, BlockPos pos, FluidStack stack) {
        UniversalFluidStorage from = (UniversalFluidStorage)Capabilities.Fluid.BLOCK.getCapability(level, pos, null);
        if (from == null) {
            return;
        }
        long amount = from.drain(stack, true).getAmount();
        if (amount == 0L) {
            return;
        }
        FluidStack finalStack = stack.copyWithAmount(amount);
        List<UniversalFluidStorage> toSend = Direction.stream().map(direction -> (UniversalFluidStorage)Capabilities.Fluid.BLOCK.getCapability(level, pos.relative(direction), (Object)direction.getOpposite())).filter(Objects::nonNull).sorted(Comparator.comparing(fluidStorage -> fluidStorage.fill(finalStack, true))).filter(fluidStorage -> {
            int i = 0;
            if (i < fluidStorage.getTanks()) {
                fluidStorage.isFluidValid(i, finalStack);
                return true;
            }
            return false;
        }).toList();
        if (toSend.isEmpty()) {
            return;
        }
        int receivers = toSend.size();
        long toDistribute = finalStack.getAmount();
        for (UniversalFluidStorage to : toSend) {
            toDistribute -= FluidUtil.moveFluid(from, to, stack.copyWithAmount(finalStack.getAmount() / (long)receivers)).getAmount();
        }
    }
}

