/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.neoforge.mixin;

import com.st0x0ef.stellaris.common.items.CustomArmorItem;
import com.st0x0ef.stellaris.platform.neoforge.ClientUtilsPlatformImpl;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={CustomArmorItem.class})
public abstract class ArmorRenderMixin
extends Item {
    public ArmorRenderMixin(Item.Properties properties) {
        super(properties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            private ClientUtilsPlatformImpl.ArmorRenderer renderer;

            private static <T extends LivingEntity> void uncheckedCopyTo(HumanoidModel<T> from, HumanoidModel<?> to) {
                from.copyPropertiesTo(to);
            }

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = ClientUtilsPlatformImpl.ARMOR_RENDERERS.get(stack.getItem());
                }
                if (this.renderer == null) {
                    return original;
                }
                ModelPart root = Minecraft.getInstance().getEntityModels().bakeLayer(this.renderer.layer());
                return this.renderer.factory().create(root, slot, stack, original);
            }

            @NotNull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                HumanoidModel<?> replacement = this.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
                if (replacement != original) {
                    1.uncheckedCopyTo(original, replacement);
                    return replacement;
                }
                return original;
            }
        });
    }
}

