/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials;

import java.util.Objects;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bruno.elytraEssentials.api.ElytraEssentialsAPI;
import org.bruno.elytraEssentials.api.ElytraEssentialsAPIImpl;
import org.bruno.elytraEssentials.commands.AchievementsCommand;
import org.bruno.elytraEssentials.commands.ArmorCommand;
import org.bruno.elytraEssentials.commands.EffectsCommand;
import org.bruno.elytraEssentials.commands.ElytraEssentialsCommand;
import org.bruno.elytraEssentials.commands.FlightTimeCommand;
import org.bruno.elytraEssentials.commands.ForgeCommand;
import org.bruno.elytraEssentials.commands.HelpCommand;
import org.bruno.elytraEssentials.commands.ImportDbCommand;
import org.bruno.elytraEssentials.commands.ReloadCommand;
import org.bruno.elytraEssentials.commands.ShopCommand;
import org.bruno.elytraEssentials.commands.StatsCommand;
import org.bruno.elytraEssentials.commands.TandemCommand;
import org.bruno.elytraEssentials.commands.TopCommand;
import org.bruno.elytraEssentials.commands.UpgradeCommand;
import org.bruno.elytraEssentials.gui.GuiListener;
import org.bruno.elytraEssentials.gui.achievements.AchievementsGuiHandler;
import org.bruno.elytraEssentials.gui.effects.EffectsGuiHandler;
import org.bruno.elytraEssentials.gui.forge.ForgeGuiHandler;
import org.bruno.elytraEssentials.gui.shop.ShopGuiHandler;
import org.bruno.elytraEssentials.gui.upgrade.UpgradeGuiHandler;
import org.bruno.elytraEssentials.handlers.AchievementsHandler;
import org.bruno.elytraEssentials.handlers.ArmoredElytraHandler;
import org.bruno.elytraEssentials.handlers.BoostHandler;
import org.bruno.elytraEssentials.handlers.CombatTagHandler;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.EffectsHandler;
import org.bruno.elytraEssentials.handlers.ElytraEquipHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.handlers.JumpAnimationHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.PluginInfoHandler;
import org.bruno.elytraEssentials.handlers.RecoveryHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.handlers.TandemHandler;
import org.bruno.elytraEssentials.handlers.TpsHandler;
import org.bruno.elytraEssentials.handlers.UpdaterHandler;
import org.bruno.elytraEssentials.handlers.UpgradeHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.FileHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.listeners.ArmoredElytraListener;
import org.bruno.elytraEssentials.listeners.BoostListener;
import org.bruno.elytraEssentials.listeners.CombatTagListener;
import org.bruno.elytraEssentials.listeners.DamageListener;
import org.bruno.elytraEssentials.listeners.ElytraEquipListener;
import org.bruno.elytraEssentials.listeners.ElytraFlightListener;
import org.bruno.elytraEssentials.listeners.ElytraUpdaterListener;
import org.bruno.elytraEssentials.listeners.TandemListener;
import org.bruno.elytraEssentials.placeholders.ElytraEssentialsPlaceholders;
import org.bruno.elytraEssentials.utils.ServerVersion;
import org.bruno.util.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class ElytraEssentials
extends JavaPlugin {
    private ConfigHandler configHandler;
    private DatabaseHandler databaseHandler;
    private EffectsHandler effectsHandler;
    private TpsHandler tpsHandler;
    private RecoveryHandler recoveryHandler;
    private StatsHandler statsHandler;
    private AchievementsHandler achievementsHandler;
    private FlightHandler flightHandler;
    private ArmoredElytraHandler armoredElytraHandler;
    private ShopGuiHandler shopGuiHandler;
    private ForgeGuiHandler forgeGuiHandler;
    private EffectsGuiHandler effectsGuiHandler;
    private AchievementsGuiHandler achievementsGuiHandler;
    private ElytraEquipHandler elytraEquipHandler;
    private BoostHandler boostHandler;
    private CombatTagHandler combatTagHandler;
    private PluginInfoHandler pluginInfoHandler;
    private UpdaterHandler updaterHandler;
    private MessagesHandler messagesHandler;
    private TandemHandler tandemHandler;
    private UpgradeGuiHandler upgradeGuiHandler;
    private UpgradeHandler upgradeHandler;
    private JumpAnimationHandler jumpAnimationHandler = null;
    private MessagesHelper messagesHelper;
    private FileHelper fileHelper;
    private ArmoredElytraHelper armoredElytraHelper;
    private FoliaHelper foliaHelper;
    private Economy economy = null;
    private boolean isEconomyEnabled = false;
    private ElytraEssentialsPlaceholders elytraStatsExpansion;
    private boolean isPacketEventsEnabled = false;
    private ServerVersion serverVersion;

    public void onLoad() {
        this.serverVersion = ServerVersion.getCurrent();
        this.saveDefaultConfig();
    }

    public void onEnable() {
        try {
            this.setupEconomy();
            this.setupPacketEvents();
            this.setupComponents();
            this.setupAPI();
            this.setupListeners();
            this.setupCommands();
            this.registerPlaceholders();
            this.startAllPluginTasks();
            this.setupIntegrations();
            this.sendStartupMessages();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "A critical error occurred during plugin startup. Disabling ElytraEssentials.", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        this.sendOnDisableMessages();
        this.shutdownAllPluginTasks();
        if (this.databaseHandler != null) {
            this.databaseHandler.disconnect();
        }
        this.unregisterPlaceholders();
        HandlerList.unregisterAll((Plugin)this);
    }

    public void startAllPluginTasks() {
        if (this.databaseHandler != null) {
            this.databaseHandler.start();
        }
        if (this.recoveryHandler != null) {
            this.recoveryHandler.start();
        }
        if (this.tpsHandler != null) {
            this.tpsHandler.start();
        }
        if (this.statsHandler != null) {
            this.statsHandler.start();
        }
        if (this.achievementsHandler != null) {
            this.achievementsHandler.start();
        }
        if (this.flightHandler != null) {
            this.flightHandler.start();
        }
        if (this.combatTagHandler != null) {
            this.combatTagHandler.start();
        }
        if (this.tandemHandler != null) {
            this.tandemHandler.start();
        }
    }

    public void reload() {
        this.shutdownAllPluginTasks();
        this.reloadConfig();
        this.fileHelper.reloadAll();
        this.configHandler.reload(this.getConfig());
        this.messagesHandler.reload(this.fileHelper.getMessagesConfig());
        this.messagesHelper.setPrefix(this.messagesHandler.getPrefixMessage());
        this.upgradeHandler.reload(this.fileHelper.getUpgradesConfig());
        this.startAllPluginTasks();
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.statsHandler.loadPlayerStats(player);
            this.flightHandler.loadPlayerData(player);
            this.effectsHandler.loadPlayerActiveEffect(player);
        }
    }

    private void setupComponents() throws Exception {
        this.saveDefaultConfig();
        this.serverVersion = ServerVersion.getCurrent();
        this.foliaHelper = new FoliaHelper(this);
        this.fileHelper = new FileHelper(this, this.getLogger());
        this.messagesHelper = new MessagesHelper(this.serverVersion);
        this.armoredElytraHelper = new ArmoredElytraHelper(this, this.getLogger());
        try {
            this.pluginInfoHandler = new PluginInfoHandler(this.getPluginMeta());
        }
        catch (NoSuchMethodError e) {
            this.pluginInfoHandler = new PluginInfoHandler(this.getDescription());
        }
        this.configHandler = new ConfigHandler(this.getConfig(), this.getLogger());
        this.messagesHandler = new MessagesHandler(this.fileHelper.getMessagesConfig());
        this.messagesHelper.setPrefix(this.messagesHandler.getPrefixMessage());
        this.messagesHelper.setDebugMode(this.configHandler.getIsDebugModeEnabled());
        this.databaseHandler = new DatabaseHandler(this, this.configHandler, this.foliaHelper, this.messagesHelper, this.getLogger());
        this.databaseHandler.initialize();
        if (this.isPacketEventsEnabled) {
            this.jumpAnimationHandler = new JumpAnimationHandler(this.foliaHelper, this.getLogger());
        }
        this.upgradeHandler = new UpgradeHandler(this, this.fileHelper.getUpgradesConfig(), this.getLogger());
        this.tpsHandler = new TpsHandler(this.foliaHelper, this.messagesHelper);
        this.effectsHandler = new EffectsHandler(this, this.fileHelper.getShopConfig(), this.foliaHelper, this.databaseHandler, this.messagesHelper, this.serverVersion, this.economy, this.tpsHandler, this.messagesHandler, this.getLogger());
        this.statsHandler = new StatsHandler(this.getLogger(), this.databaseHandler, this.foliaHelper, this.messagesHelper, this.effectsHandler);
        this.achievementsHandler = new AchievementsHandler(this.databaseHandler, this.statsHandler, this.foliaHelper, this.messagesHelper, this.fileHelper.getAchievementsConfig(), this.getLogger(), this.messagesHandler);
        this.boostHandler = new BoostHandler(this, this.foliaHelper, this.messagesHelper, this.serverVersion, this.statsHandler, this.configHandler, this.messagesHandler, this.upgradeHandler, this.jumpAnimationHandler);
        this.flightHandler = new FlightHandler(this.getLogger(), this.configHandler, this.effectsHandler, this.boostHandler, this.foliaHelper, this.messagesHelper, this.databaseHandler, this.statsHandler, this.messagesHandler, this.upgradeHandler, this.armoredElytraHelper);
        this.boostHandler.setFlightHandler(this.flightHandler);
        this.recoveryHandler = new RecoveryHandler(this.flightHandler, this.configHandler, this.foliaHelper);
        this.combatTagHandler = new CombatTagHandler(this.configHandler, this.messagesHelper, this.foliaHelper, this.messagesHandler);
        this.elytraEquipHandler = new ElytraEquipHandler(this.configHandler, this.messagesHelper, this.foliaHelper, this.messagesHandler);
        this.armoredElytraHandler = new ArmoredElytraHandler(this, this.configHandler, this.foliaHelper, this.armoredElytraHelper, this.messagesHelper, this.messagesHandler, this.upgradeHandler);
        this.effectsGuiHandler = new EffectsGuiHandler(this, this.effectsHandler, this.databaseHandler, this.foliaHelper, this.messagesHelper, this.getLogger());
        this.shopGuiHandler = new ShopGuiHandler(this, this.effectsHandler, this.effectsGuiHandler, this.getLogger());
        this.effectsGuiHandler.setShopGuiHandler(this.shopGuiHandler);
        this.forgeGuiHandler = new ForgeGuiHandler(this.configHandler, this.armoredElytraHelper, this.foliaHelper, this.messagesHandler, this.messagesHelper, this.economy, this);
        this.achievementsGuiHandler = new AchievementsGuiHandler(this.getLogger(), this.databaseHandler, this.foliaHelper, this.messagesHelper, this.achievementsHandler, this.statsHandler);
        this.upgradeGuiHandler = new UpgradeGuiHandler(this, this.armoredElytraHelper, this.configHandler, this.messagesHelper, this.economy, this.armoredElytraHandler, this.upgradeHandler);
        this.tandemHandler = new TandemHandler(this.configHandler, this.messagesHelper, this.foliaHelper, this.flightHandler, this.messagesHandler);
        this.updaterHandler = new UpdaterHandler(this.getLogger(), this.foliaHelper, this.configHandler, this.pluginInfoHandler);
    }

    private void setupIntegrations() {
        new Metrics((Plugin)this, 26164);
        this.updaterHandler.performCheck();
    }

    private void setupListeners() {
        this.getLogger().info("Registering event listeners...");
        ElytraFlightListener elytraFlightListener = new ElytraFlightListener(this.flightHandler, this.statsHandler, this.effectsHandler);
        BoostListener elytraBoostListener = new BoostListener(this.boostHandler);
        ElytraEquipListener elytraEquipListener = new ElytraEquipListener(this.elytraEquipHandler);
        ElytraUpdaterListener elytraUpdaterListener = new ElytraUpdaterListener(this.messagesHelper, this.configHandler, this.pluginInfoHandler);
        ArmoredElytraListener armoredElytraListener = new ArmoredElytraListener(this.armoredElytraHandler, this.configHandler);
        CombatTagListener combatTagListener = new CombatTagListener(this.combatTagHandler);
        DamageListener damageListener = new DamageListener(this.flightHandler, this.statsHandler, this.armoredElytraHandler, this.upgradeHandler);
        GuiListener guiListener = new GuiListener(this.shopGuiHandler, this.forgeGuiHandler, this.effectsGuiHandler, this.achievementsGuiHandler, this.upgradeGuiHandler);
        TandemListener tandemListener = new TandemListener(this.tandemHandler);
        Bukkit.getPluginManager().registerEvents((Listener)elytraFlightListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)elytraBoostListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)elytraEquipListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)elytraUpdaterListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)armoredElytraListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)combatTagListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)damageListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)guiListener, (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)tandemListener, (Plugin)this);
    }

    private void setupCommands() {
        this.getLogger().info("Registering commands...");
        HelpCommand helpCommand = new HelpCommand(this);
        ReloadCommand reloadCommand = new ReloadCommand(this, this.messagesHelper, this.messagesHandler);
        FlightTimeCommand flightTimeCommand = new FlightTimeCommand(this.flightHandler, this.configHandler, this.messagesHelper, this.foliaHelper, this.messagesHandler);
        ShopCommand shopCommand = new ShopCommand(this.shopGuiHandler, this.messagesHelper, this.messagesHandler);
        EffectsCommand effectsCommand = new EffectsCommand(this.getLogger(), this.effectsGuiHandler, this.effectsHandler, this.databaseHandler, this.foliaHelper, this.messagesHelper, this.messagesHandler);
        StatsCommand statsCommand = new StatsCommand(this.statsHandler, this.messagesHelper, this.messagesHandler);
        TopCommand topCommand = new TopCommand(this.statsHandler, this.messagesHelper, this.messagesHandler);
        ForgeCommand forgeCommand = new ForgeCommand(this.forgeGuiHandler, this.configHandler, this.messagesHelper, this.messagesHandler);
        ArmorCommand armorCommand = new ArmorCommand(this, this.messagesHelper, this.economy, this.configHandler, this.messagesHandler, this.armoredElytraHelper);
        ImportDbCommand importDbCommand = new ImportDbCommand(this, this.messagesHandler, this.messagesHelper, this.databaseHandler);
        AchievementsCommand achievementsCommand = new AchievementsCommand(this.achievementsGuiHandler, this.messagesHelper, this.messagesHandler);
        TandemCommand tandemCommand = new TandemCommand(this.tandemHandler, this.messagesHelper, this.messagesHandler, this.configHandler);
        UpgradeCommand upgradeCommand = new UpgradeCommand(this.upgradeGuiHandler, this.armoredElytraHelper, this.messagesHelper, this.messagesHandler);
        ElytraEssentialsCommand mainCommand = new ElytraEssentialsCommand(this.getLogger(), this.messagesHelper);
        mainCommand.registerSubCommand("help", helpCommand);
        mainCommand.registerSubCommand("reload", reloadCommand);
        mainCommand.registerSubCommand("ft", flightTimeCommand);
        mainCommand.registerSubCommand("shop", shopCommand);
        mainCommand.registerSubCommand("effects", effectsCommand);
        mainCommand.registerSubCommand("stats", statsCommand);
        mainCommand.registerSubCommand("top", topCommand);
        mainCommand.registerSubCommand("forge", forgeCommand);
        mainCommand.registerSubCommand("armor", armorCommand);
        mainCommand.registerSubCommand("importdb", importDbCommand);
        mainCommand.registerSubCommand("achievements", achievementsCommand);
        mainCommand.registerSubCommand("tandem", tandemCommand);
        mainCommand.registerSubCommand("upgrade", upgradeCommand);
        Objects.requireNonNull(this.getCommand("ee")).setExecutor((CommandExecutor)mainCommand);
        Objects.requireNonNull(this.getCommand("ee")).setTabCompleter((TabCompleter)mainCommand);
    }

    private void setupAPI() {
        ElytraEssentialsAPIImpl api = new ElytraEssentialsAPIImpl(this.flightHandler, this.effectsHandler);
        this.getServer().getServicesManager().register(ElytraEssentialsAPI.class, (Object)api, (Plugin)this, ServicePriority.Normal);
        this.getLogger().info("ElytraEssentials API has been successfully registered.");
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found! All economy features will be disabled.");
            this.isEconomyEnabled = false;
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("Vault found, but no economy plugin is hooked into it. Economy features will be disabled.");
            this.isEconomyEnabled = false;
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.getLogger().info("Successfully hooked into Vault & found economy provider: " + ((Economy)rsp.getProvider()).getName());
        this.isEconomyEnabled = true;
    }

    private void setupPacketEvents() {
        if (Bukkit.getPluginManager().getPlugin("packetevents") == null) {
            this.getLogger().warning("PacketEvents not found \u2014 jump charge animation disabled.");
            this.isPacketEventsEnabled = false;
        } else {
            this.isPacketEventsEnabled = true;
        }
    }

    private void registerPlaceholders() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.elytraStatsExpansion = new ElytraEssentialsPlaceholders(this.flightHandler, this.statsHandler, this.configHandler, this.pluginInfoHandler);
            this.elytraStatsExpansion.register();
            this.getLogger().info("Successfully hooked into PlaceholderAPI.");
        } else {
            this.getLogger().warning("PlaceholderAPI not found! Placeholders will not work.");
        }
    }

    private void unregisterPlaceholders() {
        if (this.elytraStatsExpansion != null) {
            this.elytraStatsExpansion.unregister();
        }
    }

    public void shutdownAllPluginTasks() {
        if (this.recoveryHandler != null) {
            this.recoveryHandler.shutdown();
        }
        if (this.tpsHandler != null) {
            this.tpsHandler.cancel();
        }
        if (this.statsHandler != null) {
            this.statsHandler.shutdown();
        }
        if (this.achievementsHandler != null) {
            this.achievementsHandler.shutdown();
        }
        if (this.combatTagHandler != null) {
            this.combatTagHandler.shutdown();
        }
        if (this.tandemHandler != null) {
            this.tandemHandler.shutdown();
        }
        if (this.flightHandler != null) {
            this.flightHandler.shutdown();
        }
        if (this.databaseHandler != null) {
            this.databaseHandler.shutdown();
        }
    }

    private void sendStartupMessages() {
        this.messagesHelper.sendConsoleMessage("&e\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510");
        this.messagesHelper.sendConsoleMessage(" ");
        this.messagesHelper.sendConsoleMessage("  &6&lElytraEssentials &fv" + this.pluginInfoHandler.getCurrentVersion());
        this.messagesHelper.sendConsoleMessage("  &7by CodingMaestro");
        this.messagesHelper.sendConsoleMessage(" ");
        String platform = this.foliaHelper.isFolia() ? "&dFolia" : "&bSpigot/Paper/Purpur";
        this.messagesHelper.sendConsoleMessage("  &eStatus:");
        this.messagesHelper.sendConsoleMessage("    &7Platform: " + platform);
        this.messagesHelper.sendConsoleMessage("    &7Storage: &f" + this.databaseHandler.getStorageType());
        String economyStatus = this.isEconomyEnabled ? "&aEnabled (&f" + this.economy.getName() + "&a)" : "&cDisabled";
        this.messagesHelper.sendConsoleMessage("    &7Economy: " + economyStatus);
        String papiStatus = this.elytraStatsExpansion != null ? "&aHooked" : "&cNot Found";
        this.messagesHelper.sendConsoleMessage("    &7Placeholders (PAPI): " + papiStatus);
        if (this.isPacketEventsEnabled) {
            this.messagesHelper.sendConsoleMessage("    &7PacketEvents: &aHooked");
        }
        this.messagesHelper.sendConsoleMessage(" ");
        this.messagesHelper.sendConsoleMessage("  &aPlugin has been enabled successfully!");
        this.messagesHelper.sendConsoleMessage(" ");
        this.messagesHelper.sendConsoleMessage("&e\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518");
        this.messagesHelper.sendDebugMessage(" ");
        this.messagesHelper.sendDebugMessage("&6&lDEBUG MODE IS ENABLED. THIS WILL SPAM YOUR CONSOLE.");
        this.messagesHelper.sendDebugMessage("&6&lIT IS NOT INTENDED FOR PRODUCTION USE.");
        this.messagesHelper.sendDebugMessage(" ");
    }

    private void sendOnDisableMessages() {
        this.messagesHelper.sendConsoleMessage("&e\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510");
        this.messagesHelper.sendConsoleMessage(" ");
        this.messagesHelper.sendConsoleMessage("  &6&lElytraEssentials &fv" + this.pluginInfoHandler.getCurrentVersion());
        this.messagesHelper.sendConsoleMessage("  &7by CodingMaestro");
        this.messagesHelper.sendConsoleMessage(" ");
        this.messagesHelper.sendConsoleMessage("  &cPlugin has been disabled. All tasks stopped and data saved.");
        this.messagesHelper.sendConsoleMessage(" ");
        this.messagesHelper.sendConsoleMessage("&e\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518");
    }
}

