/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.milkbowl.vault.economy.Economy;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.UpgradeType;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArmorCommand
implements SubCommand {
    private final ElytraEssentials plugin;
    private final Economy economy;
    private final MessagesHelper messagesHelper;
    private final ConfigHandler configHandler;
    private final MessagesHandler messagesHandler;
    private final ArmoredElytraHelper armoredElytraHelper;

    public ArmorCommand(ElytraEssentials plugin, MessagesHelper messagesHelper, Economy economy, ConfigHandler configHandler, MessagesHandler messagesHandler, ArmoredElytraHelper armoredElytraHelper) {
        this.plugin = plugin;
        this.messagesHelper = messagesHelper;
        this.economy = economy;
        this.configHandler = configHandler;
        this.messagesHandler = messagesHandler;
        this.armoredElytraHelper = armoredElytraHelper;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.handleInfoCommand(sender);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("repair")) {
            this.handleRepairCommand(sender);
            return true;
        }
        this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee armor <repair>");
        return true;
    }

    private void handleInfoCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be run by a player.");
            return;
        }
        Player player = (Player)sender;
        if (!PermissionsHelper.hasArmorPermission((CommandSender)player)) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (!this.isArmoredElytra(chestplate)) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotWearingArmoredElytra());
            return;
        }
        ItemMeta meta = chestplate.getItemMeta();
        if (meta == null) {
            this.messagesHelper.sendPlayerMessage(player, "&cError: Could not read item data.");
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int currentDurability = (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "armor-durability"), PersistentDataType.INTEGER, (Object)0);
        int maxDurability = (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "max-armor-durability"), PersistentDataType.INTEGER, (Object)1);
        String materialName = (String)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "armor-material"), PersistentDataType.STRING, (Object)"Unknown");
        materialName = materialName.replace("_CHESTPLATE", "").replace("_", " ");
        double damageAbsorbed = ((Float)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "damage-absorbed"), PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
        int timesShattered = (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "plating-shattered"), PersistentDataType.INTEGER, (Object)0);
        String forgedBy = (String)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "forged-by"), PersistentDataType.STRING, (Object)"\u00a7kUnknown");
        AttributeInstance armorAttr = this.armoredElytraHelper.getArmorAttribute(player);
        AttributeInstance toughnessAttr = this.armoredElytraHelper.getToughnessAttribute(player);
        double armorPoints = armorAttr != null ? armorAttr.getValue() : 0.0;
        double armorToughness = toughnessAttr != null ? toughnessAttr.getValue() : 0.0;
        this.sendArmorInfoMessage(player, currentDurability, maxDurability, materialName, damageAbsorbed, timesShattered, forgedBy, container, armorPoints, armorToughness);
    }

    private void handleRepairCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be run by a player.");
            return;
        }
        Player player = (Player)sender;
        if (!PermissionsHelper.hasRepairPermission((CommandSender)player)) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (!this.isArmoredElytra(chestplate)) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotWearingArmoredElytraRepair());
            return;
        }
        ItemMeta meta = chestplate.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey durabilityKey = new NamespacedKey((Plugin)this.plugin, "armor-durability");
        NamespacedKey maxDurabilityKey = new NamespacedKey((Plugin)this.plugin, "max-armor-durability");
        int currentDurability = (Integer)container.getOrDefault(durabilityKey, PersistentDataType.INTEGER, (Object)0);
        int maxDurability = (Integer)container.getOrDefault(maxDurabilityKey, PersistentDataType.INTEGER, (Object)1);
        boolean elytraFull = true;
        if (meta instanceof Damageable) {
            Damageable damageableMeta = (Damageable)meta;
            boolean bl = elytraFull = damageableMeta.getDamage() <= 0;
        }
        if (currentDurability >= maxDurability && elytraFull) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getArmoredElytraAlreadyRepaired());
            return;
        }
        if (!this.handleRepairPayment(player)) {
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
            return;
        }
        container.set(durabilityKey, PersistentDataType.INTEGER, (Object)maxDurability);
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(0);
        }
        this.updateDurabilityLore(meta);
        chestplate.setItemMeta(meta);
        player.playSound(player.getLocation(), Sound.ENTITY_IRON_GOLEM_REPAIR, 1.0f, 1.2f);
        this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getArmoredElytraRepairSuccess());
    }

    private boolean handleRepairPayment(Player player) {
        double moneyCost = this.configHandler.getRepairCostMoney();
        int xpCost = this.configHandler.getRepairCostXpLevels();
        if (moneyCost > 0.0) {
            if (this.economy == null) {
                return true;
            }
            if (!this.economy.has((OfflinePlayer)player, moneyCost)) {
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotEnoughMoney());
                return false;
            }
        }
        if (xpCost > 0 && player.getLevel() < xpCost) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotEnoughXP());
            return false;
        }
        if (moneyCost > 0.0) {
            this.economy.withdrawPlayer((OfflinePlayer)player, moneyCost);
        }
        if (xpCost > 0) {
            player.setLevel(player.getLevel() - xpCost);
        }
        return true;
    }

    private void updateDurabilityLore(ItemMeta meta) {
        NamespacedKey maxDurabilityKey = new NamespacedKey((Plugin)this.plugin, "max-armor-durability");
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int max = (Integer)container.getOrDefault(maxDurabilityKey, PersistentDataType.INTEGER, (Object)1);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        String durabilityLine = String.format("\u00a76Armor Plating: \u00a7a%d / %d", max, max);
        boolean found = false;
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains("Armor Plating:")) continue;
            lore.set(i, durabilityLine);
            found = true;
            break;
        }
        if (!found) {
            lore.add(durabilityLine);
        }
        meta.setLore(lore);
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            Player player;
            if (sender instanceof Player && !PermissionsHelper.hasRepairPermission((CommandSender)(player = (Player)sender))) {
                return List.of();
            }
            return List.of("repair");
        }
        return List.of();
    }

    private void sendArmorInfoMessage(Player player, int currentDurability, int maxDurability, String materialName, double damageAbsorbed, int timesShattered, String forgedBy, PersistentDataContainer container, double armorPoints, double armorToughness) {
        List<String> upgradeLines;
        List<String> enchantmentLines;
        String primaryColor = "\u00a7b";
        String textColor = "\u00a77";
        player.sendMessage(primaryColor + "\u00a7m----------------------------------------------------");
        player.sendMessage("");
        player.sendMessage(primaryColor + "\u00a7lArmored Elytra Info");
        player.sendMessage("");
        TextComponent platingTitle = new TextComponent(TextComponent.fromLegacyText((String)"\u00a76Armor Plating: "));
        if (currentDurability < maxDurability) {
            double repairMoneyCost = this.configHandler.getRepairCostMoney();
            int repairXpCost = this.configHandler.getRepairCostXpLevels();
            TextComponent repairButton = new TextComponent("\u00a7e[Repair]");
            repairButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ee armor repair"));
            TextComponent[] hoverText = new TextComponent[]{new TextComponent(TextComponent.fromLegacyText((String)("\u00a7eClick to fully repair the Armor Plating.\n\u00a7eCost: \u00a76$" + String.format("%.2f", repairMoneyCost) + " \u00a7eand \u00a76" + repairXpCost + " \u00a7eLevels")))};
            repairButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text((BaseComponent[])hoverText)}));
            platingTitle.addExtra((BaseComponent)repairButton);
        }
        player.spigot().sendMessage((BaseComponent)platingTitle);
        player.sendMessage(this.armoredElytraHelper.getDurabilityBarString(currentDurability, maxDurability));
        player.sendMessage("");
        player.sendMessage(" \u00a7f\u25aa \u00a77Base Material: \u00a7f" + this.getCapitalizedName(materialName));
        player.sendMessage("");
        player.sendMessage(ColorHelper.parse("&#0067FFArmor Stats:"));
        player.sendMessage(ColorHelper.parse(String.format(" \u00a7f\u25aa \u00a77Armor: &#B0D0FF+%.1f", armorPoints)));
        if (armorToughness > 0.0) {
            player.sendMessage(ColorHelper.parse(String.format(" &f\u25aa &7Armor Toughness: &#B0D0FF+%.1f", armorToughness)));
        }
        if (!(enchantmentLines = this.getEnchantmentLines(container)).isEmpty()) {
            player.sendMessage("");
            player.sendMessage("\u00a7dEnchantments:");
            for (String line : enchantmentLines) {
                player.sendMessage(line);
            }
        }
        if (!(upgradeLines = this.getUpgradeLines(container)).isEmpty()) {
            player.sendMessage("");
            player.sendMessage("\u00a7cUpgrades:");
            for (String line : upgradeLines) {
                player.sendMessage(line);
            }
        }
        player.sendMessage("");
        player.sendMessage("\u00a7bItem History:");
        double damageInHearts = damageAbsorbed / 2.0;
        player.sendMessage(String.format(" %s\u25aa %sTotal Damage Absorbed: %s%.1f \u2764", "\u00a7f", textColor, "\u00a7b", damageInHearts));
        player.sendMessage(String.format(" %s\u25aa %sTimes Plating Shattered: %s%d", "\u00a7f", textColor, "\u00a7b", timesShattered));
        player.sendMessage(String.format(" %s\u25aa %sForged By: %s%s", "\u00a7f", textColor, "\u00a7b", forgedBy));
        player.sendMessage("");
        player.sendMessage(primaryColor + "\u00a7m----------------------------------------------------");
    }

    private boolean isArmoredElytra(ItemStack item) {
        if (item == null || item.getType() != Material.ELYTRA) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "armored-elytra"), PersistentDataType.BYTE);
    }

    private List<String> getEnchantmentLines(PersistentDataContainer container) {
        ArrayList<String> lines = new ArrayList<String>();
        HashMap<Enchantment, Integer> displayEnchants = new HashMap<Enchantment, Integer>();
        for (Enchantment enchantment : Enchantment.values()) {
            int chestplateLevel;
            NamespacedKey elytraEnchantKey = new NamespacedKey((Plugin)this.plugin, "elytra_enchant_" + enchantment.getKey().getKey());
            NamespacedKey chestplateEnchantKey = new NamespacedKey((Plugin)this.plugin, "chestplate_enchant_" + enchantment.getKey().getKey());
            int elytraLevel = (Integer)container.getOrDefault(elytraEnchantKey, PersistentDataType.INTEGER, (Object)0);
            int highestLevel = Math.max(elytraLevel, chestplateLevel = ((Integer)container.getOrDefault(chestplateEnchantKey, PersistentDataType.INTEGER, (Object)0)).intValue());
            if (highestLevel <= 0) continue;
            displayEnchants.put(enchantment, highestLevel);
        }
        if (!displayEnchants.isEmpty()) {
            for (Map.Entry entry : displayEnchants.entrySet()) {
                lines.add(String.format(" \u00a7f\u25aa \u00a77%s %d", this.getCapitalizedName(((Enchantment)entry.getKey()).getKey().getKey()), entry.getValue()));
            }
        }
        return lines;
    }

    private List<String> getUpgradeLines(PersistentDataContainer container) {
        ArrayList<String> upgradeLines = new ArrayList<String>();
        for (UpgradeType type : UpgradeType.values()) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, type.getKey());
            int level = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
            if (level <= 0) continue;
            double bonus = (double)level * type.getValuePerLevel();
            String bonusString = String.format("%.1f", bonus).replace(".0", "");
            upgradeLines.add(ColorHelper.parse(" &f\u25aa &7" + type.getDisplayName() + ": &#FFBFBFLevel " + level + " &7(&4+" + bonusString + type.getSuffix() + "&7)"));
        }
        return upgradeLines;
    }

    private String getCapitalizedName(String name) {
        String[] words = name.toLowerCase().replace("_", " ").split(" ");
        StringBuilder capitalized = new StringBuilder();
        for (String word : words) {
            capitalized.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return capitalized.toString().trim();
    }
}

