/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.gui.effects.EffectsGuiHandler;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.EffectsHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.ElytraEffect;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EffectsCommand
implements SubCommand {
    private final Logger logger;
    private final EffectsGuiHandler effectsGuiHandler;
    private final EffectsHandler effectsHandler;
    private final DatabaseHandler databaseHandler;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;

    public EffectsCommand(Logger logger, EffectsGuiHandler guiHandler, EffectsHandler effectsHandler, DatabaseHandler dbHandler, FoliaHelper fHelper, MessagesHelper messagesHelper, MessagesHandler messagesHandler) {
        this.logger = logger;
        this.effectsGuiHandler = guiHandler;
        this.effectsHandler = effectsHandler;
        this.databaseHandler = dbHandler;
        this.foliaHelper = fHelper;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String action;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be run by a player.");
                return true;
            }
            Player player = (Player)sender;
            if (!PermissionsHelper.hasEffectsPermission((CommandSender)player)) {
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
                return true;
            }
            player.playSound(player.getLocation(), Sound.UI_LOOM_SELECT_PATTERN, 0.8f, 0.8f);
            this.effectsGuiHandler.open(player);
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "clear": {
                this.handleClear(sender, args);
                break;
            }
            case "give": {
                this.handleGive(sender, args);
                break;
            }
            case "remove": {
                this.handleRemove(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender, args);
                break;
            }
            default: {
                this.messagesHelper.sendCommandSenderMessage(sender, "&cUnknown subcommand. Usage: /ee effects <clear, give, remove, list>");
            }
        }
        return true;
    }

    private void handleClear(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be run by a player.");
            return;
        }
        Player player = (Player)sender;
        if (!PermissionsHelper.hasClearEffectsCommandPermission((CommandSender)player)) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        String activeEffectKey = this.effectsHandler.getActiveEffect(player.getUniqueId());
        if (activeEffectKey == null) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoActiveEffectToClear());
            return;
        }
        this.effectsHandler.handleDeselection(player, activeEffectKey);
    }

    private void handleGive(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasGiveEffectPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        if (args.length < 3) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee effects give <player> <effect>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getPlayerNotFound().replace("{0}", args[1]));
            return;
        }
        String effectKey = args[2].toUpperCase();
        if (!this.effectsHandler.getEffectsRegistry().containsKey(effectKey)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cEffect '" + effectKey + "' not found.");
            return;
        }
        if (target.isOnline() && PermissionsHelper.hasAllEffectsPermission(target.getPlayer())) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&e" + target.getName() + " has access to all effects via permissions.");
            return;
        }
        this.foliaHelper.runAsyncTask(() -> {
            try {
                List<String> ownedKeys = this.databaseHandler.getOwnedEffectKeys(target.getUniqueId());
                if (ownedKeys.contains(effectKey)) {
                    this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&c" + target.getName() + " already owns this effect."));
                    return;
                }
                this.databaseHandler.addOwnedEffect(target.getUniqueId(), effectKey);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getGiveEffectSuccess().replace("{0}", effectKey).replace("{1}", target.getName())));
            }
            catch (SQLException e) {
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cA database error occurred."));
                this.logger.log(Level.SEVERE, "Failed to give effect to " + target.getName(), e);
            }
        });
    }

    private void handleRemove(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasRemoveEffectPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        if (args.length < 3) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee effects remove <player> <effect>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getPlayerNotFound().replace("{0}", args[1]));
            return;
        }
        String effectKey = args[2].toUpperCase();
        if (target.isOnline() && PermissionsHelper.hasAllEffectsPermission(target.getPlayer())) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&eCannot remove effects from a player who has wildcard permissions.");
            return;
        }
        this.foliaHelper.runAsyncTask(() -> {
            try {
                List<String> ownedKeys = this.databaseHandler.getOwnedEffectKeys(target.getUniqueId());
                if (!ownedKeys.contains(effectKey)) {
                    this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&c" + target.getName() + " does not own this effect."));
                    return;
                }
                this.databaseHandler.removeOwnedEffect(target.getUniqueId(), effectKey);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&aSuccessfully removed the " + effectKey + " effect from " + target.getName() + "."));
            }
            catch (SQLException e) {
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cA database error occurred."));
                this.logger.log(Level.SEVERE, "Failed to remove effect from " + target.getName(), e);
            }
        });
    }

    private void handleList(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasListEffectsPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        if (args.length < 2) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee effects list <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getPlayerNotFound().replace("{0}", args[1]));
            return;
        }
        this.messagesHelper.sendCommandSenderMessage(sender, "&eFetching owned effects for " + target.getName() + "...");
        this.foliaHelper.runAsyncTask(() -> {
            Player targetPlayer;
            HashSet<String> allOwnedEffects;
            try {
                allOwnedEffects = new HashSet<String>(this.databaseHandler.getOwnedEffectKeys(target.getUniqueId()));
            }
            catch (SQLException e) {
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cA database error occurred while fetching owned effects."));
                this.logger.log(Level.SEVERE, "Failed to list effects for " + target.getName(), e);
                return;
            }
            if (target.isOnline() && (targetPlayer = target.getPlayer()) != null) {
                if (PermissionsHelper.hasAllEffectsPermission(targetPlayer)) {
                    allOwnedEffects.addAll(this.effectsHandler.getEffectsRegistry().keySet());
                } else {
                    for (Map.Entry<String, ElytraEffect> entry : this.effectsHandler.getEffectsRegistry().entrySet()) {
                        if (!targetPlayer.hasPermission(entry.getValue().getPermission())) continue;
                        allOwnedEffects.add(entry.getKey());
                    }
                }
            }
            this.foliaHelper.runTaskOnMainThread(() -> {
                sender.sendMessage("\u00a76--- " + target.getName() + "'s Owned Effects ---");
                if (allOwnedEffects.isEmpty()) {
                    sender.sendMessage("\u00a77This player does not have access to any effects.");
                } else {
                    for (String key : allOwnedEffects) {
                        sender.sendMessage("\u00a7e - " + key);
                    }
                }
            });
        });
    }
}

