/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class ElytraEssentialsCommand
implements CommandExecutor,
TabCompleter {
    private final Logger logger;
    private final MessagesHelper messagesHelper;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public ElytraEssentialsCommand(Logger logger, MessagesHelper messagesHelper) {
        this.logger = logger;
        this.messagesHelper = messagesHelper;
    }

    public void registerSubCommand(String name, SubCommand command) {
        this.subCommands.put(name, command);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            try {
                this.subCommands.get("help").execute(sender, new String[0]);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "A database error occurred while executing command /ee help'' for " + sender.getName(), e);
                this.messagesHelper.sendCommandSenderMessage(sender, "&cAn unexpected database error occurred. Please contact an administrator.");
                return true;
            }
            return true;
        }
        String subCommandName = args[0].toLowerCase();
        SubCommand commandHandler = this.subCommands.get(subCommandName);
        if (commandHandler == null) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cUnknown subcommand. Use /ee help for available commands.");
            return true;
        }
        try {
            String[] subCommandArgs = Arrays.copyOfRange(args, 1, args.length);
            return commandHandler.execute(sender, subCommandArgs);
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "A database error occurred while executing command '" + subCommandName + "' for " + sender.getName(), e);
            this.messagesHelper.sendCommandSenderMessage(sender, "&cAn unexpected database error occurred. Please contact an administrator.");
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "An unexpected error occurred while executing command '" + subCommandName + "' for " + sender.getName(), e);
            this.messagesHelper.sendCommandSenderMessage(sender, "&cAn unexpected error occurred. Please contact an administrator.");
            return true;
        }
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommandName;
        SubCommand subCommand;
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (PermissionsHelper.hasHelpPermission(sender)) {
                completions.add("help");
            }
            if (PermissionsHelper.hasReloadPermission(sender)) {
                completions.add("reload");
            }
            if (PermissionsHelper.hasFlightTimeCommandPermission(sender)) {
                completions.add("ft");
            }
            if (PermissionsHelper.hasShopPermission(sender)) {
                completions.add("shop");
            }
            if (PermissionsHelper.hasEffectsPermission(sender)) {
                completions.add("effects");
            }
            if (PermissionsHelper.hasStatsPermission(sender)) {
                completions.add("stats");
            }
            if (PermissionsHelper.hasTopPermission(sender)) {
                completions.add("top");
            }
            if (PermissionsHelper.hasForgePermission(sender)) {
                completions.add("forge");
            }
            if (PermissionsHelper.hasArmorPermission(sender)) {
                completions.add("armor");
            }
            if (PermissionsHelper.hasImportDbPermission(sender)) {
                completions.add("importdb");
            }
            if (PermissionsHelper.hasAchievementsPermission(sender)) {
                completions.add("achievements");
            }
            if (PermissionsHelper.hasTandemInvitePermission(sender)) {
                completions.add("tandem");
            }
            if (PermissionsHelper.hasUpgradePermission(sender)) {
                completions.add("upgrade");
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length > 1 && (subCommand = this.subCommands.get(subCommandName = args[0].toLowerCase())) != null) {
            return subCommand.getSubcommandCompletions(sender, args);
        }
        return List.of();
    }
}

