/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlightTimeCommand
implements SubCommand {
    private final FlightHandler flightHandler;
    private final ConfigHandler configHandler;
    private final MessagesHelper messagesHelper;
    private final FoliaHelper foliaHelper;
    private final MessagesHandler messagesHandler;

    public FlightTimeCommand(FlightHandler flightHandler, ConfigHandler configHandler, MessagesHelper messagesHelper, FoliaHelper foliaHelper, MessagesHandler messagesHandler) {
        this.flightHandler = flightHandler;
        this.configHandler = configHandler;
        this.messagesHelper = messagesHelper;
        this.foliaHelper = foliaHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String action;
        if (!this.configHandler.getIsTimeLimitEnabled()) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getFeatureNotEnabled());
            return true;
        }
        if (!PermissionsHelper.hasFlightTimeCommandPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return true;
        }
        if (args.length < 2) {
            this.sendUsageMessage(sender);
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "add": {
                this.handleAdd(sender, args);
                break;
            }
            case "remove": {
                this.handleRemove(sender, args);
                break;
            }
            case "set": {
                this.handleSet(sender, args);
                break;
            }
            case "clear": {
                this.handleClear(sender, args);
                break;
            }
            default: {
                this.sendUsageMessage(sender);
            }
        }
        return true;
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        String action;
        if (args.length == 2) {
            return Stream.of("add", "remove", "set", "clear").filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 4 && ((action = args[1].toLowerCase()).equals("add") || action.equals("remove") || action.equals("set"))) {
            return List.of("60", "600", "3600");
        }
        return List.of();
    }

    private void handleAdd(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.sendUsageMessage(sender);
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!this.validateTargetPlayer(sender, target, args[1])) {
            return;
        }
        int amount = this.parsePositiveInteger(args[2], sender);
        if (amount == -1) {
            return;
        }
        this.foliaHelper.runAsyncTask(() -> this.flightHandler.addFlightTime(target.getUniqueId(), amount, sender));
    }

    private void handleRemove(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.sendUsageMessage(sender);
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!this.validateTargetPlayer(sender, target, args[1])) {
            return;
        }
        int amount = this.parsePositiveInteger(args[2], sender);
        if (amount == -1) {
            return;
        }
        this.foliaHelper.runAsyncTask(() -> this.flightHandler.removeFlightTime(target.getUniqueId(), amount, sender));
    }

    private void handleSet(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.sendUsageMessage(sender);
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!this.validateTargetPlayer(sender, target, args[1])) {
            return;
        }
        int amount = this.parsePositiveInteger(args[2], sender);
        if (amount == -1) {
            return;
        }
        this.foliaHelper.runAsyncTask(() -> this.flightHandler.setFlightTime(target.getUniqueId(), amount, sender));
    }

    private void handleClear(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.sendUsageMessage(sender);
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!this.validateTargetPlayer(sender, target, args[1])) {
            return;
        }
        this.foliaHelper.runAsyncTask(() -> this.flightHandler.clearFlightTime(target.getUniqueId(), sender));
    }

    private boolean validateTargetPlayer(CommandSender sender, OfflinePlayer target, String targetName) {
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            String message = this.messagesHandler.getPlayerNotFound().replace("{0}", targetName);
            this.messagesHelper.sendCommandSenderMessage(sender, message);
            return false;
        }
        if (target.isOnline() && PermissionsHelper.playerBypassTimeLimit(target.getPlayer())) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThe player " + targetName + " has time limit bypass and cannot be managed.");
            return false;
        }
        return true;
    }

    private void sendUsageMessage(CommandSender sender) {
        sender.sendMessage("\u00a7cUsage:");
        sender.sendMessage("\u00a7c/ee ft <add|remove|set> <player> <seconds>");
        sender.sendMessage("\u00a7c/ee ft clear <player>");
    }

    private int parsePositiveInteger(String input, CommandSender sender) {
        try {
            int value = Integer.parseInt(input);
            if (value <= 0) {
                throw new NumberFormatException();
            }
            return value;
        }
        catch (NumberFormatException e) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cInvalid number. Please enter a positive integer.");
            return -1;
        }
    }
}

