/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HelpCommand
implements SubCommand {
    private final ElytraEssentials plugin;
    private final List<HelpEntry> allCommands = new ArrayList<HelpEntry>();
    private static final int COMMANDS_PER_PAGE = 5;

    public HelpCommand(ElytraEssentials plugin) {
        this.plugin = plugin;
        this.initializeHelpEntries();
    }

    private void initializeHelpEntries() {
        this.allCommands.add(new HelpEntry("/ee reload", "Reloads the plugin's configuration files.", "elytraessentials.command.reload"));
        this.allCommands.add(new HelpEntry("/ee shop", "Opens the effects shop GUI.", "elytraessentials.command.shop"));
        this.allCommands.add(new HelpEntry("/ee effects", "Opens the owned effects GUI.", "elytraessentials.command.effects"));
        this.allCommands.add(new HelpEntry("/ee effects clear", "Clears your active elytra effect.", "elytraessentials.effects.clear"));
        this.allCommands.add(new HelpEntry("/ee effects give <player> <effect>", "Gives an effect to a player.", "elytraessentials.effects.give"));
        this.allCommands.add(new HelpEntry("/ee effects remove <player> <effect>", "Removes an effect from a player.", "elytraessentials.effects.remove"));
        this.allCommands.add(new HelpEntry("/ee effects list <player>", "Shows the player's owned effects.", "elytraessentials.effects.list"));
        this.allCommands.add(new HelpEntry("/ee ft set <player> <seconds>", "Sets the total player's flight time.", "elytraessentials.command.flighttime"));
        this.allCommands.add(new HelpEntry("/ee ft add <player> <seconds>", "Adds time to the player's flight time.", "elytraessentials.command.flighttime"));
        this.allCommands.add(new HelpEntry("/ee ft remove <player> <seconds>", "Removes time from the player's flight time.", "elytraessentials.command.flighttime"));
        this.allCommands.add(new HelpEntry("/ee ft clear <player>", "Clears all flight time a player has.", "elytraessentials.command.flighttime"));
        this.allCommands.add(new HelpEntry("/ee stats", "View your flight statistics.", "elytraessentials.command.stats"));
        this.allCommands.add(new HelpEntry("/ee stats <player>", "View other player's flight statistics.", "elytraessentials.command.stats.others"));
        this.allCommands.add(new HelpEntry("/ee top <distance, time, longest>", "View leaderboard statistics.", "elytraessentials.command.top"));
        this.allCommands.add(new HelpEntry("/ee forge", "Opens the Armored Elytra forge GUI.", "elytraessentials.command.forge"));
        this.allCommands.add(new HelpEntry("/ee armor", "Shows stats for your worn Armored Elytra.", "elytraessentials.command.armor"));
        this.allCommands.add(new HelpEntry("/ee armor repair", "Repairs your worn Armored Elytra.", "elytraessentials.command.armor.repair"));
        this.allCommands.add(new HelpEntry("/ee importdb <file> --confirm", "Restores a database backup.", "elytraessentials.command.importdb"));
        this.allCommands.add(new HelpEntry("/ee achievements", "Opens the achievements GUI.", "elytraessentials.command.achievements"));
        this.allCommands.add(new HelpEntry("/ee tandem invite <player>", "Invite a player to fly with you.", "elytraessentials.command.tandem.invite"));
        this.allCommands.add(new HelpEntry("/ee tandem accept", "Accept a pending tandem flight invitation.", "elytraessentials.command.tandem.accept"));
        this.allCommands.add(new HelpEntry("/ee tandem leave", "Dismount from a tandem flight. Also the same as sneaking while tandem flying.", "elytraessentials.command.tandem.leave"));
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        List<HelpEntry> allowedCommands = this.allCommands.stream().filter(entry -> sender.hasPermission(entry.permission())).toList();
        int totalPages = (int)Math.ceil((double)allowedCommands.size() / 5.0);
        if (totalPages == 0) {
            totalPages = 1;
        }
        int page = 1;
        if (args.length == 1) {
            try {
                page = Integer.parseInt(args[0]);
                if (page < 1 || page > totalPages) {
                    sender.sendMessage("\u00a7cInvalid page number.");
                    return true;
                }
                if (sender instanceof Player) {
                    ((Player)sender).playSound(((Player)sender).getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.8f, 1.0f);
                }
            }
            catch (NumberFormatException e) {
                sender.sendMessage("\u00a7cInvalid page number. Please use a number.");
                return true;
            }
        }
        this.sendHeader(sender);
        int startIndex = (page - 1) * 5;
        for (int i = 0; i < 5; ++i) {
            int listIndex = startIndex + i;
            if (listIndex >= allowedCommands.size()) continue;
            this.sendHelpLine(sender, allowedCommands.get(listIndex));
        }
        this.sendWebsiteLink(sender);
        this.sendNavigationFooter(sender, page, totalPages);
        return true;
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            long allowedCount = this.allCommands.stream().filter(entry -> sender.hasPermission(entry.permission())).count();
            int totalPages = (int)Math.ceil((double)allowedCount / 5.0);
            return IntStream.rangeClosed(1, totalPages).mapToObj(String::valueOf).filter(s -> s.startsWith(args[1])).collect(Collectors.toList());
        }
        return List.of();
    }

    private void sendHeader(CommandSender sender) {
        String primary = "\u00a76";
        String secondary = "\u00a7e";
        String text = "\u00a77";
        sender.sendMessage(primary + "\u00a7m----------------------------------------------------");
        sender.sendMessage("");
        sender.sendMessage(primary + "\u00a7lElytraEssentials " + secondary + "v" + this.plugin.getDescription().getVersion());
        sender.sendMessage(text + "All available commands are listed below.");
        sender.sendMessage("");
    }

    private void sendHelpLine(CommandSender sender, HelpEntry entry) {
        TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)"\u00a7e\u00bb "));
        TextComponent commandComponent = new TextComponent(TextComponent.fromLegacyText((String)("\u00a7e" + entry.command())));
        commandComponent.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, entry.command()));
        commandComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(TextComponent.fromLegacyText((String)("\u00a7eClick to paste command in the chat.\n\u00a77Permission: \u00a7f" + entry.permission())))}));
        message.addExtra((BaseComponent)commandComponent);
        message.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)(" \u00a77- " + entry.description()))));
        sender.spigot().sendMessage((BaseComponent)message);
    }

    private void sendNavigationFooter(CommandSender sender, int currentPage, int totalPages) {
        sender.sendMessage("");
        TextComponent footer = new TextComponent("\u00a76\u00a7m------------\u00a7r\u00a76[ \u00a7e");
        if (currentPage > 1) {
            TextComponent prevButton = new TextComponent(TextComponent.fromLegacyText((String)"\u00ab Prev"));
            prevButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ee help " + (currentPage - 1)));
            prevButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Go to previous page")}));
            footer.addExtra((BaseComponent)prevButton);
        } else {
            footer.addExtra((BaseComponent)new TextComponent("\u00a77\u00a7m\u00ab Prev"));
        }
        footer.addExtra((BaseComponent)new TextComponent(String.format(" \u00a7r\u00a76| \u00a7fPage %d/%d \u00a76|\u00a7r ", currentPage, totalPages)));
        if (currentPage < totalPages) {
            TextComponent nextButton = new TextComponent(TextComponent.fromLegacyText((String)"Next \u00bb"));
            nextButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ee help " + (currentPage + 1)));
            nextButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Go to next page")}));
            footer.addExtra((BaseComponent)nextButton);
        } else {
            footer.addExtra((BaseComponent)new TextComponent("\u00a77\u00a7mNext \u00bb"));
        }
        footer.addExtra((BaseComponent)new TextComponent(" \u00a7r\u00a76]\u00a7m------------"));
        sender.spigot().sendMessage((BaseComponent)footer);
    }

    private void sendWebsiteLink(CommandSender sender) {
        sender.sendMessage("");
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a76For more information, visit: https://www.spigotmc.org/resources/126002/");
            return;
        }
        Player player = (Player)sender;
        TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)"\u00a76For more information, visit our "));
        TextComponent linkComponent = new TextComponent("\u00a7e\u00a7n[Official Plugin Page]");
        linkComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/resources/126002/"));
        linkComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Click to open the website!")}));
        message.addExtra((BaseComponent)linkComponent);
        player.spigot().sendMessage((BaseComponent)message);
    }

    private record HelpEntry(String command, String description, String permission) {
    }
}

