/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.command.CommandSender;

public class ImportDbCommand
implements SubCommand {
    private final ElytraEssentials plugin;
    private final MessagesHandler messagesHandler;
    private final MessagesHelper messagesHelper;
    private final DatabaseHandler databaseHandler;

    public ImportDbCommand(ElytraEssentials plugin, MessagesHandler messagesHandler, MessagesHelper messagesHelper, DatabaseHandler databaseHandler) {
        this.plugin = plugin;
        this.messagesHandler = messagesHandler;
        this.messagesHelper = messagesHelper;
        this.databaseHandler = databaseHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasImportDbPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return true;
        }
        if (!this.databaseHandler.getStorageType().equalsIgnoreCase("SQLITE")) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be used with the SQLite storage type.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage("\u00a7cUsage: /ee importdb <backup_filename>");
            sender.sendMessage("\u00a7eUse tab-complete to see available backup files.");
            sender.sendMessage("\u00a77If none are shown, please wait for your first backup file to be generated.");
            return true;
        }
        String backupFileName = args[0];
        File backupFile = new File(this.plugin.getDataFolder(), "database/backups/" + backupFileName);
        if (!backupFile.exists()) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cError: Backup file '" + backupFileName + "' not found.");
            return true;
        }
        if (args.length < 2 || !args[1].equalsIgnoreCase("--confirm")) {
            sender.sendMessage("");
            sender.sendMessage("\u00a7c\u00a7lWARNING: \u00a7r\u00a7cThis is a destructive operation!");
            sender.sendMessage("\u00a7eThis will overwrite all current player data with the selected backup.");
            sender.sendMessage("\u00a7eAll online players will be kicked from the server.");
            sender.sendMessage("\u00a76To proceed, run the command again with '--confirm' at the end.");
            sender.sendMessage("\u00a7f/ee importdb " + backupFileName + " --confirm");
            sender.sendMessage("");
            return true;
        }
        this.databaseHandler.importFromBackup(backupFileName, sender, backupFile);
        return true;
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            List<String> backupFiles = this.databaseHandler.getBackupFileNames();
            return backupFiles.stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && "--confirm".startsWith(args[2].toLowerCase())) {
            return List.of("--confirm");
        }
        return List.of();
    }
}

