/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.logging.Level;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.command.CommandSender;

public class ReloadCommand
implements SubCommand {
    private final ElytraEssentials plugin;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;

    public ReloadCommand(ElytraEssentials plugin, MessagesHelper messagesHelper, MessagesHandler messagesHandler) {
        this.plugin = plugin;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasReloadPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return true;
        }
        this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getReloadStartMessage());
        try {
            this.plugin.reload();
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getReloadSuccessMessage());
        }
        catch (Exception e) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cAn error occurred during reload. Please check the console for details.");
            this.plugin.getLogger().log(Level.SEVERE, "A critical error occurred during plugin reload.", e);
        }
        return true;
    }
}

