/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.gui.shop.ShopGuiHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShopCommand
implements SubCommand {
    private final ShopGuiHandler shopGuiHandler;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;

    public ShopCommand(ShopGuiHandler shopGuiHandler, MessagesHelper messagesHelper, MessagesHandler messagesHandler) {
        this.shopGuiHandler = shopGuiHandler;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cOnly players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!PermissionsHelper.hasShopPermission((CommandSender)player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return true;
        }
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.8f, 0.8f);
        this.shopGuiHandler.openShop(player, 0);
        return true;
    }
}

