/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsCommand
implements SubCommand {
    private final StatsHandler statsHandler;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;

    public StatsCommand(StatsHandler statsHandler, MessagesHelper messagesHelper, MessagesHandler messagesHandler) {
        this.statsHandler = statsHandler;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee stats <player> OR /ee stats <subcommand>");
                return true;
            }
            Player player = (Player)sender;
            if (!PermissionsHelper.hasStatsPermission((CommandSender)player)) {
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
                return true;
            }
            this.statsHandler.fetchAndDisplayStats(sender, (OfflinePlayer)player);
            return true;
        }
        String subcommand = args[0].toLowerCase();
        if ("reset".equals(subcommand)) {
            this.handleReset(sender, args);
        } else {
            this.handleView(sender, args);
        }
        return true;
    }

    private void handleView(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasStatsOthersPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getPlayerNotFound().replace("{0}", args[0]));
            return;
        }
        this.statsHandler.fetchAndDisplayStats(sender, target);
    }

    private void handleReset(CommandSender sender, String[] args) {
        if (!PermissionsHelper.hasStatsResetPermission(sender)) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        if (args.length < 2) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee stats reset <player>");
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.messagesHelper.sendCommandSenderMessage(sender, this.messagesHandler.getPlayerNotFound().replace("{0}", args[1]));
            return;
        }
        if (args.length < 3 || !args[2].equalsIgnoreCase("--confirm")) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&c&lWARNING: &r&cThis will permanently delete all stats for " + target.getName() + ".");
            this.messagesHelper.sendCommandSenderMessage(sender, "&eTo proceed, add '--confirm' to the end of the command.");
            return;
        }
        this.statsHandler.resetPlayerStats(target, sender);
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> completions = new ArrayList<String>();
            String input = args[1].toLowerCase();
            if (PermissionsHelper.hasStatsResetPermission(sender)) {
                completions.add("reset");
            }
            if (PermissionsHelper.hasStatsOthersPermission(sender)) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList());
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(input)).collect(Collectors.toList());
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("reset") && PermissionsHelper.hasStatsResetPermission(sender)) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("reset") && "--confirm".startsWith(args[3].toLowerCase())) {
            return List.of("--confirm");
        }
        return List.of();
    }
}

