/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.TandemHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TandemCommand
implements SubCommand {
    private final TandemHandler tandemHandler;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;
    private final ConfigHandler configHandler;

    public TandemCommand(TandemHandler tandemHandler, MessagesHelper messagesHelper, MessagesHandler messagesHandler, ConfigHandler configHandler) {
        this.tandemHandler = tandemHandler;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
        this.configHandler = configHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String subcommand;
        if (!(sender instanceof Player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.configHandler.getIsTandemFlightEnabled()) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getFeatureNotEnabled());
            return true;
        }
        if (args.length == 0) {
            this.sendUsageMessage((CommandSender)player);
            return true;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "invite": {
                this.handleInvite(player, args);
                break;
            }
            case "accept": {
                this.handleAccept(player);
                break;
            }
            case "leave": {
                this.handleLeave(player);
                break;
            }
            default: {
                this.sendUsageMessage((CommandSender)player);
            }
        }
        return true;
    }

    private void handleInvite(Player driver, String[] args) {
        if (!PermissionsHelper.hasTandemFlightPermission(driver)) {
            this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        if (args.length < 2) {
            this.messagesHelper.sendPlayerMessage(driver, "&cUsage: /ee tandem invite <player>");
            return;
        }
        Player invitee = Bukkit.getPlayer((String)args[1]);
        if (invitee == null) {
            this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getPlayerNotFound().replace("{0}", args[1]));
            return;
        }
        if (driver.equals((Object)invitee)) {
            this.messagesHelper.sendPlayerMessage(driver, "&cYou cannot invite yourself to a tandem flight.");
            return;
        }
        this.tandemHandler.invitePlayer(driver, invitee);
    }

    private void handleAccept(Player passenger) {
        if (!PermissionsHelper.hasTandemFlightPermission(passenger)) {
            this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getNoPermissionMessage());
            return;
        }
        this.tandemHandler.acceptInvite(passenger);
    }

    private void handleLeave(Player passenger) {
        this.tandemHandler.dismountPassenger(passenger, null, true);
    }

    private void sendUsageMessage(CommandSender sender) {
        this.messagesHelper.sendCommandSenderMessage(sender, "&6&lTandem Flight Commands");
        this.messagesHelper.sendCommandSenderMessage(sender, "&e/ee tandem invite <player> &7- Invite a player to fly with you.");
        this.messagesHelper.sendCommandSenderMessage(sender, "&e/ee tandem accept &7- Accept a pending flight invitation.");
        this.messagesHelper.sendCommandSenderMessage(sender, "&e/ee tandem leave &7- Dismount from a tandem flight.");
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (args.length == 2) {
            ArrayList<String> subcommands = new ArrayList<String>();
            if (PermissionsHelper.hasTandemInvitePermission((CommandSender)player)) {
                subcommands.add("invite");
            }
            if (PermissionsHelper.hasTandemAcceptPermission((CommandSender)player)) {
                subcommands.add("accept");
            }
            if (PermissionsHelper.hasTandemLeavePermission((CommandSender)player)) {
                subcommands.add("leave");
            }
            return subcommands.stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("invite") && PermissionsHelper.hasTandemInvitePermission((CommandSender)player)) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> !name.equals(player.getName())).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return List.of();
    }
}

