/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class TopCommand
implements SubCommand {
    private final StatsHandler statsHandler;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;

    public TopCommand(StatsHandler statsHandler, MessagesHelper messagesHelper, MessagesHandler messagesHandler) {
        this.statsHandler = statsHandler;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player player;
        if (sender instanceof Player && !PermissionsHelper.hasTopPermission((CommandSender)(player = (Player)sender))) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
            return true;
        }
        if (args.length == 0) {
            this.sendLeaderboardMenu(sender);
            return true;
        }
        if (args.length > 1) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cUsage: /ee top <distance, time, longest>");
            return true;
        }
        this.statsHandler.displayTopStats(sender, args[0].toLowerCase());
        return true;
    }

    private void sendLeaderboardMenu(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a76--- ElytraEssentials Leaderboards ---");
            sender.sendMessage("\u00a7eUse /ee top <category> to view a leaderboard.");
            sender.sendMessage("\u00a77Categories: distance, time, longest");
            return;
        }
        Player player = (Player)sender;
        player.sendMessage("\u00a76\u00a7m----------------------------------------------------");
        player.sendMessage("");
        player.sendMessage("\u00a76\u00a7lElytraEssentials Leaderboards");
        player.sendMessage("\u00a77Click a category to view the top players.");
        player.sendMessage("");
        this.sendLeaderboardLine(player, "\u00a7eTotal Distance Flown", "/ee top distance");
        this.sendLeaderboardLine(player, "\u00a7eTotal Flight Time", "/ee top time");
        this.sendLeaderboardLine(player, "\u00a7eLongest Single Flight", "/ee top longest");
        player.sendMessage("");
        player.sendMessage("\u00a76\u00a7m----------------------------------------------------");
    }

    private void sendLeaderboardLine(Player player, String categoryName, String commandToRun) {
        TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)"\u00a7e\u00bb "));
        TextComponent categoryComponent = new TextComponent(TextComponent.fromLegacyText((String)categoryName));
        categoryComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, commandToRun));
        TextComponent[] hoverText = new TextComponent[]{new TextComponent(TextComponent.fromLegacyText((String)"\u00a7fClick to view the\n")), new TextComponent(TextComponent.fromLegacyText((String)("\u00a7e" + categoryName))), new TextComponent(TextComponent.fromLegacyText((String)"\n\u00a7fleaderboard."))};
        categoryComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text((BaseComponent[])hoverText)}));
        message.addExtra((BaseComponent)categoryComponent);
        player.spigot().sendMessage((BaseComponent)message);
    }

    @Override
    public List<String> getSubcommandCompletions(CommandSender sender, String[] args) {
        if (!(sender instanceof Player) && !(sender instanceof ConsoleCommandSender)) {
            return List.of();
        }
        if (args.length == 2) {
            Player player;
            if (sender instanceof Player && !PermissionsHelper.hasTopPermission((CommandSender)(player = (Player)sender))) {
                return List.of();
            }
            List<String> allCategories = List.of("distance", "time", "longest");
            ArrayList<String> allowedCategories = new ArrayList<String>(allCategories);
            String currentArg = args[1].toLowerCase();
            return allowedCategories.stream().filter(s -> s.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
        }
        return List.of();
    }
}

