/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.commands;

import org.bruno.elytraEssentials.commands.SubCommand;
import org.bruno.elytraEssentials.gui.upgrade.UpgradeGuiHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UpgradeCommand
implements SubCommand {
    private final UpgradeGuiHandler upgradeGuiHandler;
    private final ArmoredElytraHelper armoredElytraHelper;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;

    public UpgradeCommand(UpgradeGuiHandler upgradeGuiHandler, ArmoredElytraHelper armoredElytraHelper, MessagesHelper messagesHelper, MessagesHandler messagesHandler) {
        this.upgradeGuiHandler = upgradeGuiHandler;
        this.armoredElytraHelper = armoredElytraHelper;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cThis command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (!PermissionsHelper.hasUpgradePermission((CommandSender)player)) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNoPermissionMessage());
            return true;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (chestplate == null || !this.armoredElytraHelper.isArmoredElytra(chestplate)) {
            this.messagesHelper.sendPlayerMessage(player, "&cYou must be wearing an Armored Elytra to use the upgrade station.");
            return true;
        }
        if (player.isGliding()) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cYou must be on the ground to upgrade your armored elytra.");
            return true;
        }
        this.upgradeGuiHandler.open(player);
        return true;
    }
}

