/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.gui.achievements;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.gui.achievements.AchievementsHolder;
import org.bruno.elytraEssentials.handlers.AchievementsHandler;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.GuiHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.utils.Constants;
import org.bruno.elytraEssentials.utils.StatType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AchievementsGuiHandler {
    private final Logger logger;
    private final DatabaseHandler databaseHandler;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final AchievementsHandler achievementsHandler;
    private final StatsHandler statsHandler;
    private final Map<UUID, PlayerGuiState> playerStates = new HashMap<UUID, PlayerGuiState>();
    private final List<StatType> filterCycle = Arrays.asList(StatType.UNKNOWN, StatType.TOTAL_DISTANCE, StatType.TOTAL_FLIGHT_TIME, StatType.LONGEST_FLIGHT, StatType.BOOSTS_USED, StatType.SAVES);

    public AchievementsGuiHandler(Logger logger, DatabaseHandler databaseHandler, FoliaHelper foliaHelper, MessagesHelper messagesHelper, AchievementsHandler achievementsHandler, StatsHandler statsHandler) {
        this.logger = logger;
        this.databaseHandler = databaseHandler;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.achievementsHandler = achievementsHandler;
        this.statsHandler = statsHandler;
    }

    public void open(Player player, int page, StatType filter) {
        this.playerStates.put(player.getUniqueId(), new PlayerGuiState(page, filter));
        this.foliaHelper.runAsyncTask(() -> {
            try {
                Set<String> unlockedAchievements = this.databaseHandler.getUnlockedAchievementIds(player.getUniqueId());
                this.foliaHelper.runTaskOnMainThread(() -> {
                    Inventory gui = Bukkit.createInventory((InventoryHolder)new AchievementsHolder(), (int)54, (String)"\u00a78Achievements");
                    this.populateItems(gui, player, page, filter);
                    this.addControlButtons(gui, page, filter);
                    player.openInventory(gui);
                });
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to fetch achievements for player " + player.getName(), e);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendPlayerMessage(player, "&cCould not load your achievement data."));
            }
        });
    }

    public void clearPlayerData(Player player) {
        this.playerStates.remove(player.getUniqueId());
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        PlayerGuiState currentState = this.playerStates.getOrDefault(player.getUniqueId(), new PlayerGuiState(0, StatType.UNKNOWN));
        int clickedSlot = event.getSlot();
        switch (clickedSlot) {
            case 48: {
                if (currentState.page <= 0) break;
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
                this.playerStates.put(player.getUniqueId(), new PlayerGuiState(currentState.page - 1, currentState.filter));
                this.open(player, currentState.page - 1, currentState.filter);
                break;
            }
            case 50: {
                long totalItems = this.achievementsHandler.getAllAchievements().stream().filter(ach -> currentState.filter == StatType.UNKNOWN || ach.type() == currentState.filter).count();
                int totalPages = (int)Math.ceil((double)totalItems / 21.0);
                if (totalPages == 0) {
                    totalPages = 1;
                }
                if (currentState.page >= totalPages - 1) break;
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
                this.playerStates.put(player.getUniqueId(), new PlayerGuiState(currentState.page + 1, currentState.filter));
                this.open(player, currentState.page + 1, currentState.filter);
                break;
            }
            case 53: {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.8f);
                player.closeInventory();
                break;
            }
            case 45: {
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.8f, 1.0f);
                int currentIndex = this.filterCycle.indexOf((Object)currentState.filter);
                int nextIndex = (currentIndex + 1) % this.filterCycle.size();
                StatType newFilter = this.filterCycle.get(nextIndex);
                this.playerStates.put(player.getUniqueId(), new PlayerGuiState(0, newFilter));
                this.open(player, 0, newFilter);
            }
        }
    }

    private void populateItems(Inventory gui, Player player, int page, StatType filter) {
        Set<String> unlockedAchievements;
        List<AchievementsHandler.Achievement> achievementsToDisplay = this.achievementsHandler.getAllAchievements().stream().filter(ach -> filter == StatType.UNKNOWN || ach.type() == filter).sorted(Comparator.comparingDouble(AchievementsHandler.Achievement::value)).toList();
        try {
            unlockedAchievements = this.databaseHandler.getUnlockedAchievementIds(player.getUniqueId());
        }
        catch (SQLException e) {
            this.messagesHelper.sendPlayerMessage(player, "&cCould not load your achievement data.");
            this.logger.log(Level.SEVERE, "Failed to fetch achievements for player " + player.getName(), e);
            return;
        }
        int startIndex = page * 21;
        for (int i = 0; i < 21; ++i) {
            int listIndex = startIndex + i;
            int slot = Constants.GUI.ACHIEVEMENT_ITEM_SLOTS.get(i);
            if (listIndex >= achievementsToDisplay.size()) continue;
            AchievementsHandler.Achievement achievement = achievementsToDisplay.get(listIndex);
            boolean isUnlocked = unlockedAchievements.contains(achievement.id());
            ItemStack displayItem = this.createAchievementItem(player, achievement, isUnlocked);
            gui.setItem(slot, displayItem);
        }
        ItemStack fillerPane = GuiHelper.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < 54; ++i) {
            boolean isControlSlot;
            boolean isItemSlot = Constants.GUI.ACHIEVEMENT_ITEM_SLOTS.contains(i);
            boolean bl = isControlSlot = i >= 45;
            if (gui.getItem(i) != null || isItemSlot || isControlSlot) continue;
            gui.setItem(i, fillerPane);
        }
    }

    private ItemStack createAchievementItem(Player player, AchievementsHandler.Achievement achievement, boolean isUnlocked) {
        Material material = isUnlocked ? Material.YELLOW_DYE : achievement.displayItem();
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ColorHelper.parse(achievement.name()));
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ColorHelper.parse(achievement.description()));
            lore.add("");
            if (isUnlocked) {
                lore.add("\u00a7a\u2714 Completed!");
            } else {
                double playerValue = this.statsHandler.getStatValue(player, achievement.type());
                lore.add("\u00a7eYour Progress:");
                lore.add(this.createProgressBar(playerValue, achievement.value()));
            }
            if (!achievement.rewards().isEmpty()) {
                lore.add("");
                lore.add("\u00a76Rewards:");
                for (String rewardLine : achievement.rewards()) {
                    lore.add(ColorHelper.parse(rewardLine));
                }
            }
            if (isUnlocked) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String createProgressBar(double current, double goal) {
        double percentage;
        double d = percentage = goal > 0.0 ? current / goal : 1.0;
        if (percentage > 1.0) {
            percentage = 1.0;
        }
        int totalBars = 20;
        int greenBars = (int)((double)totalBars * percentage);
        StringBuilder bar = new StringBuilder("\u00a7a");
        for (int i = 0; i < totalBars; ++i) {
            if (i == greenBars) {
                bar.append("\u00a7f\u2586");
            }
            bar.append("\u2586");
        }
        bar.append(String.format(" \u00a7e(%.0f/%.0f)", current, goal));
        return bar.toString();
    }

    private void addControlButtons(Inventory gui, int page, StatType filter) {
        long totalItems = this.achievementsHandler.getAllAchievements().stream().filter(ach -> filter == StatType.UNKNOWN || ach.type() == filter).count();
        int totalPages = (int)Math.ceil((double)totalItems / 21.0);
        if (totalPages == 0) {
            totalPages = 1;
        }
        List<StatType> filterCycle = Arrays.asList(StatType.UNKNOWN, StatType.TOTAL_DISTANCE, StatType.TOTAL_FLIGHT_TIME, StatType.LONGEST_FLIGHT, StatType.BOOSTS_USED, StatType.SAVES);
        gui.setItem(45, GuiHelper.createFilterButton(filter, filterCycle));
        gui.setItem(48, GuiHelper.createPreviousPageButton(page > 0));
        gui.setItem(49, GuiHelper.createPageInfoItem(page + 1, totalPages));
        gui.setItem(50, GuiHelper.createNextPageButton(page < totalPages - 1));
        gui.setItem(53, GuiHelper.createCloseButton());
    }

    private static class PlayerGuiState {
        int page;
        StatType filter;

        PlayerGuiState(int page, StatType filter) {
            this.page = page;
            this.filter = filter;
        }
    }
}

