/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.gui.effects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.gui.effects.EffectsHolder;
import org.bruno.elytraEssentials.gui.shop.ShopGuiHandler;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.EffectsHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.GuiHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.ElytraEffect;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class EffectsGuiHandler {
    private final ElytraEssentials plugin;
    private final EffectsHandler effectsHandler;
    private final DatabaseHandler databaseHandler;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final Logger logger;
    private ShopGuiHandler shopGuiHandler;

    public EffectsGuiHandler(ElytraEssentials plugin, EffectsHandler effectsHandler, DatabaseHandler databaseHandler, FoliaHelper foliaHelper, MessagesHelper messagesHelper, Logger logger) {
        this.plugin = plugin;
        this.effectsHandler = effectsHandler;
        this.databaseHandler = databaseHandler;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.logger = logger;
    }

    public void setShopGuiHandler(ShopGuiHandler shopGuiHandler) {
        this.shopGuiHandler = shopGuiHandler;
    }

    public void open(Player player) {
        this.foliaHelper.runAsyncTask(() -> {
            try {
                List<String> playerEffects;
                if (PermissionsHelper.hasAllEffectsPermission(player)) {
                    playerEffects = new ArrayList<String>(this.effectsHandler.getEffectsRegistry().keySet());
                } else {
                    playerEffects = this.databaseHandler.getOwnedEffectKeys(player.getUniqueId());
                    if (playerEffects.size() < this.effectsHandler.getEffectsRegistry().size()) {
                        for (ElytraEffect effect : this.effectsHandler.getEffectsRegistry().values()) {
                            if (effect == null || !player.hasPermission(effect.getPermission()) || playerEffects.contains(effect.getKey())) continue;
                            playerEffects.add(effect.getKey());
                        }
                    }
                }
                List<String> keysToDisplay = playerEffects;
                this.foliaHelper.runTaskOnMainThread(() -> {
                    Inventory gui = Bukkit.createInventory((InventoryHolder)new EffectsHolder(), (int)45, (String)"\u00a78Owned Effects");
                    this.addControlButtons(gui);
                    if (keysToDisplay.isEmpty()) {
                        gui.setItem(13, this.effectsHandler.createEmptyItemStack());
                    } else {
                        this.populateOwnedItems(gui, player, keysToDisplay);
                    }
                    player.openInventory(gui);
                });
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to open owned effects GUI for " + player.getName(), e);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendPlayerMessage(player, "&cAn error occurred while fetching your effects."));
            }
        });
    }

    public void handleClick(InventoryClickEvent event) {
        boolean deselectionSuccess;
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int clickedSlot = event.getSlot();
        switch (clickedSlot) {
            case 36: {
                player.closeInventory();
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.8f, 0.8f);
                this.shopGuiHandler.openShop(player, 0);
                return;
            }
            case 44: {
                player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.8f);
                player.closeInventory();
                return;
            }
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String effectKey = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "effect_key"), PersistentDataType.STRING);
        if (effectKey == null) {
            return;
        }
        if (event.isLeftClick()) {
            boolean selectionSuccess = this.effectsHandler.handleSelection(player, effectKey);
            if (selectionSuccess) {
                this.open(player);
            }
        } else if (event.isRightClick() && (deselectionSuccess = this.effectsHandler.handleDeselection(player, effectKey))) {
            this.open(player);
        }
    }

    private void populateOwnedItems(Inventory inv, Player player, List<String> playerOwnedKeys) {
        Map<String, ElytraEffect> allEffects = this.effectsHandler.getEffectsRegistry();
        String activeEffectKey = this.effectsHandler.getActiveEffect(player.getUniqueId());
        for (int i = 0; i < playerOwnedKeys.size() && i < 36; ++i) {
            String effectKey = playerOwnedKeys.get(i);
            ElytraEffect templateEffect = allEffects.get(effectKey);
            if (templateEffect == null) continue;
            ElytraEffect playerSpecificEffect = new ElytraEffect(templateEffect);
            playerSpecificEffect.setIsActive(effectKey.equals(activeEffectKey));
            ItemStack item = this.effectsHandler.createOwnedItem(effectKey, playerSpecificEffect);
            inv.setItem(i, item);
        }
    }

    private void addControlButtons(Inventory inv) {
        inv.setItem(36, GuiHelper.createGuiItem(Material.CHEST, "\u00a7aShop", "\u00a77Click here to buy more effects."));
        inv.setItem(39, GuiHelper.createPreviousPageButton(false));
        inv.setItem(40, GuiHelper.createPageInfoItem(1, 1));
        inv.setItem(41, GuiHelper.createNextPageButton(false));
        inv.setItem(44, GuiHelper.createCloseButton());
    }
}

