/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.gui.forge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.Economy;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.gui.forge.ForgeHolder;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.GuiHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.utils.UpgradeType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ForgeGuiHandler {
    private final ElytraEssentials plugin;
    private final ConfigHandler configHandler;
    private final ArmoredElytraHelper armoredElytraHelper;
    private final FoliaHelper foliaHelper;
    private final MessagesHandler messagesHandler;
    private final MessagesHelper messagesHelper;
    private final Economy economy;
    private final Set<UUID> processedAction = ConcurrentHashMap.newKeySet();

    public ForgeGuiHandler(ConfigHandler configHandler, ArmoredElytraHelper armoredElytraHelper, FoliaHelper foliaHelper, MessagesHandler messagesHandler, MessagesHelper messagesHelper, Economy economy, ElytraEssentials plugin) {
        this.plugin = plugin;
        this.configHandler = configHandler;
        this.armoredElytraHelper = armoredElytraHelper;
        this.foliaHelper = foliaHelper;
        this.messagesHandler = messagesHandler;
        this.messagesHelper = messagesHelper;
        this.economy = economy;
    }

    public void openForge(Player player) {
        Inventory forge = Bukkit.createInventory((InventoryHolder)new ForgeHolder(), (int)36, (String)"\u00a78Elytra Forge");
        ItemStack grayPane = GuiHelper.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < 27; ++i) {
            forge.setItem(i, grayPane);
        }
        forge.setItem(10, null);
        forge.setItem(16, null);
        forge.setItem(13, null);
        ItemStack infoAnvil = GuiHelper.createGuiItem(Material.ANVIL, "\u00a76\u00a7lElytra Forge", "\u00a77Combine an elytra with a chestplate to create", "\u00a77a powerful new item, or place an Armored Elytra", "\u00a77in the middle slot to revert it back.", "", "\u00a7f\u25aa \u00a7eForge: \u00a77Place items in the side slots.", "\u00a7f\u25aa \u00a7eRevert: \u00a77Place an Armored Elytra in the middle.");
        forge.setItem(31, infoAnvil);
        if (this.economy != null) {
            forge.setItem(27, GuiHelper.createPlayerHead(player, "\u00a76Your Balance", "\u00a7e$" + String.format("%,.2f", this.economy.getBalance((OfflinePlayer)player))));
        }
        forge.setItem(35, GuiHelper.createCloseButton());
        player.openInventory(forge);
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (!this.configHandler.getIsArmoredElytraEnabled()) {
            return;
        }
        Inventory topInventory = GuiHelper.getTopInventory((InventoryEvent)event);
        if (topInventory.getHolder() == null || !(topInventory.getHolder() instanceof ForgeHolder)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.scheduleResultUpdate(topInventory, player);
        Inventory clickedInventory = event.getClickedInventory();
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedInventory != null && clickedInventory.equals((Object)player.getInventory())) {
            event.setCancelled(true);
            this.handleShiftClick(event.getCurrentItem(), topInventory);
            return;
        }
        if (topInventory.equals((Object)clickedInventory)) {
            int slot = event.getSlot();
            ItemStack clickedItem = event.getCurrentItem();
            switch (slot) {
                case 32: {
                    event.setCancelled(true);
                    if (clickedItem == null || clickedItem.getType() != Material.PLAYER_HEAD && clickedItem.getType() != Material.GREEN_STAINED_GLASS_PANE) break;
                    this.handleConfirmClick(topInventory, player);
                    break;
                }
                case 30: {
                    event.setCancelled(true);
                    if (clickedItem == null || clickedItem.getType() != Material.PLAYER_HEAD && clickedItem.getType() != Material.RED_STAINED_GLASS_PANE) break;
                    player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.8f, 0.8f);
                    this.handleCancelClick(topInventory, player);
                    break;
                }
                case 35: {
                    event.setCancelled(true);
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.8f);
                    this.handleCancelClick(topInventory, player);
                    player.closeInventory();
                    break;
                }
                default: {
                    event.setCancelled(true);
                }
            }
        }
    }

    public void clearPlayerData(Player player) {
        this.processedAction.remove(player.getUniqueId());
    }

    public void handleClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (this.processedAction.remove(player.getUniqueId())) {
            return;
        }
        Inventory forge = event.getInventory();
        this.returnAllItems(forge, player);
    }

    private void scheduleResultUpdate(Inventory forge, Player player) {
        this.foliaHelper.runTask((Entity)player, () -> this.updateForgeResult(forge, player));
    }

    private void returnAllItems(Inventory forge, Player player) {
        this.returnItemToPlayer(player, forge.getItem(10));
        this.returnItemToPlayer(player, forge.getItem(16));
        this.returnItemToPlayer(player, forge.getItem(13));
    }

    private void returnItemToPlayer(Player player, ItemStack item) {
        HashMap leftovers;
        if (item != null && item.getType() != Material.AIR && !this.armoredElytraHelper.isPreviewItem(item) && !(leftovers = player.getInventory().addItem(new ItemStack[]{item})).isEmpty()) {
            player.getWorld().dropItem(player.getLocation(), item);
        }
    }

    private void handleConfirmClick(Inventory forge, Player player) {
        boolean isReverting;
        ItemStack resultItem = forge.getItem(13);
        ItemStack revertedElytra = forge.getItem(10);
        ItemStack revertedArmor = forge.getItem(16);
        this.processedAction.add(player.getUniqueId());
        double moneyCost = this.configHandler.getForgeCostMoney();
        int xpCost = this.configHandler.getForgeCostXpLevels();
        boolean isCrafting = this.armoredElytraHelper.isPreviewItem(resultItem);
        boolean bl = isReverting = this.armoredElytraHelper.isPreviewItem(revertedElytra) && this.armoredElytraHelper.isPreviewItem(revertedArmor);
        if (!isCrafting && !isReverting) {
            this.returnAllItems(forge, player);
            forge.clear();
            player.closeInventory();
            return;
        }
        if (!this.canAfford(player, moneyCost, xpCost)) {
            this.returnAllItems(forge, player);
            forge.clear();
            player.closeInventory();
            return;
        }
        this.deductCosts(player, moneyCost, xpCost);
        if (isCrafting) {
            this.returnItemToPlayer(player, this.armoredElytraHelper.createCleanCopy(resultItem));
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.0f);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getForgeSuccessful());
        } else {
            this.returnItemToPlayer(player, this.armoredElytraHelper.createCleanCopy(revertedElytra));
            this.returnItemToPlayer(player, this.armoredElytraHelper.createCleanCopy(revertedArmor));
            player.playSound(player.getLocation(), Sound.BLOCK_GRINDSTONE_USE, 1.0f, 1.0f);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getRevertSuccessful());
        }
        forge.clear();
        player.closeInventory();
    }

    private boolean canAfford(Player player, double moneyCost, int xpCost) {
        if (moneyCost > 0.0) {
            if (this.economy == null) {
                this.plugin.getLogger().warning("Economy not found while handling forge!");
                return false;
            }
            if (!this.economy.has((OfflinePlayer)player, moneyCost)) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotEnoughMoney());
                return false;
            }
        }
        if (xpCost > 0 && player.getLevel() < xpCost) {
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotEnoughXP());
            return false;
        }
        return true;
    }

    private void deductCosts(Player player, double moneyCost, int xpCost) {
        if (moneyCost > 0.0) {
            this.economy.withdrawPlayer((OfflinePlayer)player, moneyCost);
        }
        if (xpCost > 0) {
            player.setLevel(player.getLevel() - xpCost);
        }
    }

    private void handleShiftClick(ItemStack clickedItem, Inventory forge) {
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemStack singleItem = clickedItem.clone();
        singleItem.setAmount(1);
        if (this.armoredElytraHelper.isPlainElytra(clickedItem) && this.isEmpty(forge.getItem(10))) {
            forge.setItem(10, singleItem);
            clickedItem.setAmount(clickedItem.getAmount() - 1);
        } else if (this.armoredElytraHelper.isChestplate(clickedItem) && this.isEmpty(forge.getItem(16))) {
            forge.setItem(16, singleItem);
            clickedItem.setAmount(clickedItem.getAmount() - 1);
        } else if (this.armoredElytraHelper.isArmoredElytra(clickedItem) && this.isEmpty(forge.getItem(13))) {
            forge.setItem(13, singleItem);
            clickedItem.setAmount(clickedItem.getAmount() - 1);
        }
    }

    private void updateForgeResult(Inventory forge, Player player) {
        boolean isCraftable;
        ItemStack elytraSlot = forge.getItem(10);
        ItemStack armorSlot = forge.getItem(16);
        ItemStack middleSlot = forge.getItem(13);
        boolean isRevertible = this.armoredElytraHelper.isArmoredElytra(middleSlot) && !this.armoredElytraHelper.isPreviewItem(middleSlot) && this.isEmpty(elytraSlot) && this.isEmpty(armorSlot);
        boolean bl = isCraftable = this.armoredElytraHelper.isPlainElytra(elytraSlot) && this.armoredElytraHelper.isChestplate(armorSlot);
        if (isRevertible) {
            this.displayRevertedItems(forge, middleSlot);
            this.showActionButtons(forge, "Revert", middleSlot);
        } else if (isCraftable) {
            if (elytraSlot == null) {
                return;
            }
            ItemStack armoredElytra = this.armoredElytraHelper.createArmoredElytra(elytraSlot, armorSlot, player);
            forge.setItem(13, armoredElytra);
            this.showActionButtons(forge, "Forge", null);
        } else {
            if (this.armoredElytraHelper.isPreviewItem(forge.getItem(13))) {
                forge.setItem(13, null);
            }
            if (this.armoredElytraHelper.isPreviewItem(forge.getItem(10))) {
                forge.setItem(10, null);
                forge.setItem(16, null);
            }
            boolean hasInputs = !this.isEmpty(forge.getItem(10)) || !this.isEmpty(forge.getItem(16)) || !this.isEmpty(forge.getItem(13));
            this.updateActionButtons(forge, hasInputs);
        }
    }

    private void showActionButtons(Inventory forge, String action, ItemStack armoredElytra) {
        ItemMeta meta;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Click to complete the process.");
        if ("Revert".equals(action) && armoredElytra != null && armoredElytra.hasItemMeta() && (meta = armoredElytra.getItemMeta()) != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            boolean hasUpgrades = false;
            for (UpgradeType type : UpgradeType.values()) {
                if (!container.has(new NamespacedKey((Plugin)this.plugin, type.getKey()), PersistentDataType.INTEGER)) continue;
                hasUpgrades = true;
                break;
            }
            if (hasUpgrades) {
                lore.add("");
                lore.add(ColorHelper.parse("&c&lWARNING:"));
                lore.add(ColorHelper.parse("&#FFBFBFThis item has upgrades that will be"));
                lore.add(ColorHelper.parse("&#FFBFBFpermanently lost upon reverting!"));
            }
        }
        double moneyCost = this.configHandler.getForgeCostMoney();
        int xpCost = this.configHandler.getForgeCostXpLevels();
        if (moneyCost > 0.0 || xpCost > 0) {
            lore.add("");
            lore.add("\u00a76Requirements:");
            if (moneyCost > 0.0) {
                lore.add(String.format(" \u00a7f\u25aa \u00a7e$%.2f", moneyCost));
            }
            if (xpCost > 0) {
                lore.add(String.format(" \u00a7f\u25aa \u00a7e%d Levels", xpCost));
            }
        }
        ItemStack confirmButton = GuiHelper.createAcceptButton(action, lore);
        ItemStack cancelButton = GuiHelper.createCancelButton();
        forge.setItem(32, confirmButton);
        forge.setItem(30, cancelButton);
    }

    private void updateActionButtons(Inventory forge, boolean hasInputs) {
        if (hasInputs) {
            forge.setItem(30, GuiHelper.createCancelButton());
        } else {
            forge.setItem(30, null);
            forge.setItem(32, null);
        }
    }

    private void handleCancelClick(Inventory forge, Player player) {
        this.returnAllItems(forge, player);
        forge.setItem(10, null);
        forge.setItem(16, null);
        forge.setItem(13, null);
    }

    private void displayRevertedItems(Inventory forge, ItemStack armoredElytra) {
        ItemStack plainElytra = this.armoredElytraHelper.reassembleElytra(armoredElytra);
        ItemStack chestplate = this.armoredElytraHelper.reassembleChestplate(armoredElytra);
        this.armoredElytraHelper.addPreviewTag(plainElytra);
        this.armoredElytraHelper.addPreviewTag(chestplate);
        forge.setItem(10, plainElytra);
        forge.setItem(16, chestplate);
    }

    private boolean isEmpty(ItemStack item) {
        return item == null || item.getType() == Material.AIR;
    }
}

