/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.gui.shop;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.gui.effects.EffectsGuiHandler;
import org.bruno.elytraEssentials.gui.shop.ShopHolder;
import org.bruno.elytraEssentials.handlers.EffectsHandler;
import org.bruno.elytraEssentials.helpers.GuiHelper;
import org.bruno.elytraEssentials.utils.Constants;
import org.bruno.elytraEssentials.utils.ElytraEffect;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ShopGuiHandler {
    private final ElytraEssentials plugin;
    private final EffectsHandler effectsHandler;
    private final EffectsGuiHandler effectsGuiHandler;
    private final Logger logger;
    private final Map<UUID, Integer> playerPages = new ConcurrentHashMap<UUID, Integer>();

    public ShopGuiHandler(ElytraEssentials plugin, EffectsHandler effectsHandler, EffectsGuiHandler effectsGuiHandler, Logger logger) {
        this.plugin = plugin;
        this.effectsHandler = effectsHandler;
        this.effectsGuiHandler = effectsGuiHandler;
        this.logger = logger;
    }

    public void openShop(Player player, int page) {
        this.playerPages.put(player.getUniqueId(), page);
        Inventory shop = Bukkit.createInventory((InventoryHolder)new ShopHolder(), (int)45, (String)"\u00a78Shop");
        this.populateShopItems(shop, player, page);
        this.addControlButtons(shop, player, page);
        player.openInventory(shop);
    }

    private void populateShopItems(Inventory shop, Player player, int page) {
        ArrayList<Map.Entry<String, ElytraEffect>> effectsList = new ArrayList<Map.Entry<String, ElytraEffect>>(this.effectsHandler.getEffectsRegistry().entrySet());
        if (effectsList.isEmpty()) {
            this.logger.warning("There are no effects created. Shop will not work");
            return;
        }
        ItemStack fillerPane = GuiHelper.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < 45; ++i) {
            boolean isControlSlot;
            boolean isItemSlot = i >= 10 && i <= 16 || i >= 19 && i <= 25;
            boolean bl = isControlSlot = i >= 36;
            if (isItemSlot || isControlSlot) continue;
            shop.setItem(i, fillerPane);
        }
        int startIndex = page * 14;
        int endIndex = Math.min(startIndex + 14, effectsList.size());
        int guiSlotIndex = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Map.Entry entry = (Map.Entry)effectsList.get(i);
            if (entry.getValue() == null) continue;
            ItemStack item = this.effectsHandler.createShopItem((String)entry.getKey(), (ElytraEffect)entry.getValue(), player);
            if (guiSlotIndex >= Constants.GUI.SHOP_ITEM_SLOTS.size()) break;
            shop.setItem(Constants.GUI.SHOP_ITEM_SLOTS.get(guiSlotIndex).intValue(), item);
            ++guiSlotIndex;
        }
    }

    private void addControlButtons(Inventory shop, Player player, int page) {
        int totalItems = this.effectsHandler.getEffectsRegistry().size();
        int totalPages = totalItems == 0 ? 1 : (int)Math.ceil((double)totalItems / 14.0);
        shop.setItem(36, GuiHelper.createPlayerHead(player, "\u00a7aYour Effects", "\u00a77Click to view your collection."));
        shop.setItem(39, GuiHelper.createPreviousPageButton(page > 0));
        shop.setItem(40, GuiHelper.createPageInfoItem(page + 1, totalPages));
        shop.setItem(41, GuiHelper.createNextPageButton(page < totalPages - 1));
        shop.setItem(44, GuiHelper.createCloseButton());
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int currentPage = this.playerPages.getOrDefault(player.getUniqueId(), 0);
        int clickedSlot = event.getSlot();
        switch (clickedSlot) {
            case 39: {
                this.handlePreviousPage(player, currentPage);
                break;
            }
            case 41: {
                this.handleNextPage(player, currentPage);
                break;
            }
            case 44: {
                player.closeInventory();
                player.playSound(player.getLocation(), Sound.BLOCK_CHEST_CLOSE, 0.8f, 0.8f);
                break;
            }
            case 36: {
                player.closeInventory();
                player.playSound(player.getLocation(), Sound.UI_LOOM_SELECT_PATTERN, 0.8f, 0.8f);
                this.effectsGuiHandler.open(player);
                break;
            }
            default: {
                this.handlePurchaseClick(player, clickedItem, currentPage);
            }
        }
    }

    private void handlePreviousPage(Player player, int currentPage) {
        if (currentPage > 0) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
            this.openShop(player, currentPage - 1);
        }
    }

    private void handleNextPage(Player player, int currentPage) {
        int totalItems = this.effectsHandler.getEffectsRegistry().size();
        int totalPages = (int)Math.ceil((double)totalItems / 14.0);
        if (currentPage < totalPages - 1) {
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 1.0f);
            this.openShop(player, currentPage + 1);
        }
    }

    private void handlePurchaseClick(Player player, ItemStack clickedItem, int currentPage) {
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String effectKey = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "effect_key"), PersistentDataType.STRING);
        if (effectKey == null) {
            return;
        }
        String permission = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "effect_permission_key"), PersistentDataType.STRING);
        boolean purchaseSuccess = this.effectsHandler.handlePurchase(player, effectKey, permission);
        if (purchaseSuccess) {
            this.openShop(player, currentPage);
        }
    }

    public void clearPlayerData(Player player) {
        this.playerPages.remove(player.getUniqueId());
    }
}

