/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.gui.upgrade;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.gui.upgrade.UpgradeHolder;
import org.bruno.elytraEssentials.handlers.ArmoredElytraHandler;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.UpgradeHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.GuiHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.utils.ElytraUpgrade;
import org.bruno.elytraEssentials.utils.UpgradeType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class UpgradeGuiHandler {
    private final ElytraEssentials plugin;
    private final ArmoredElytraHelper armoredElytraHelper;
    private final ArmoredElytraHandler armoredElytraHandler;
    private final ConfigHandler configHandler;
    private final MessagesHelper messagesHelper;
    private final UpgradeHandler upgradeHandler;
    private final Economy economy;

    public UpgradeGuiHandler(ElytraEssentials plugin, ArmoredElytraHelper armoredElytraHelper, ConfigHandler configHandler, MessagesHelper messagesHelper, Economy economy, ArmoredElytraHandler armoredElytraHandler, UpgradeHandler upgradeHandler) {
        this.plugin = plugin;
        this.armoredElytraHelper = armoredElytraHelper;
        this.armoredElytraHandler = armoredElytraHandler;
        this.configHandler = configHandler;
        this.messagesHelper = messagesHelper;
        this.economy = economy;
        this.upgradeHandler = upgradeHandler;
    }

    public void open(Player player) {
        ItemStack elytra = player.getInventory().getChestplate();
        if (elytra == null || !this.armoredElytraHelper.isArmoredElytra(elytra)) {
            this.messagesHelper.sendPlayerMessage(player, "&cError: No Armored Elytra equipped.");
            return;
        }
        Inventory gui = Bukkit.createInventory((InventoryHolder)new UpgradeHolder(), (int)45, (String)"Elytra Upgrade Station");
        ItemStack blackPane = GuiHelper.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (i >= 10 && i <= 34 && i % 9 != 0 && (i + 1) % 9 != 0) continue;
            gui.setItem(i, blackPane);
        }
        gui.setItem(4, blackPane);
        gui.setItem(38, blackPane);
        gui.setItem(4, elytra.clone());
        this.populateUpgradeItems(gui, elytra);
        if (this.economy != null) {
            gui.setItem(36, GuiHelper.createPlayerHead(player, "\u00a76Your Balance", "\u00a7e$" + String.format("%,.2f", this.economy.getBalance((OfflinePlayer)player))));
        }
        gui.setItem(44, GuiHelper.createCloseButton());
        player.openInventory(gui);
    }

    private void populateUpgradeItems(Inventory gui, ItemStack elytra) {
        ItemMeta meta = elytra.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int slot = 19;
        for (UpgradeType type : UpgradeType.values()) {
            if (type == UpgradeType.FLIGHT_EFFICIENCY && !this.configHandler.getIsTimeLimitEnabled() || type == UpgradeType.KINETIC_RESISTANCE && this.configHandler.getIsKineticEnergyProtectionEnabled()) continue;
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, type.getKey());
            int currentLevel = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
            gui.setItem(slot, this.createUpgradeItem(type, currentLevel));
            ++slot;
        }
    }

    private ItemStack createUpgradeItem(UpgradeType type, int currentLevel) {
        String[] descriptionLines;
        Map<UpgradeType, ElytraUpgrade> upgradeValues = this.upgradeHandler.getUpgradeValues();
        ElytraUpgrade data = upgradeValues.get((Object)type);
        int maxLevel = data != null ? data.getMaxLevel() : type.getMaxLevel();
        double bonusPerLevel = data != null ? data.getBonusPerLevel() : type.getValuePerLevel();
        String description = data != null ? data.getDescription() : type.getDescription();
        boolean isMaxLevel = currentLevel >= maxLevel;
        boolean exceedsMaxLevel = currentLevel > maxLevel;
        Material material = isMaxLevel ? Material.REDSTONE_BLOCK : type.getDisplayMaterial();
        ArrayList<Object> lore = new ArrayList<Object>();
        for (String line : descriptionLines = description.split("\n")) {
            lore.add("\u00a77" + line);
        }
        lore.add("");
        lore.add("\u00a78\u00a7m--------------------");
        if (exceedsMaxLevel) {
            lore.add("\u00a77Level: \u00a7f" + maxLevel + " \u00a77/ \u00a7f" + maxLevel);
            if (maxLevel > 0) {
                double currentBonus = (double)maxLevel * bonusPerLevel;
                String currentBonusString = String.format("%.1f", currentBonus).replace(".0", "");
                lore.add(ColorHelper.parse("&7Bonus: &#FFBFBF+" + currentBonusString + type.getSuffix()));
            }
        } else {
            lore.add("\u00a77Level: \u00a7f" + currentLevel + " \u00a77/ \u00a7f" + maxLevel);
            if (currentLevel > 0) {
                double currentBonus = (double)currentLevel * bonusPerLevel;
                String currentBonusString = String.format("%.1f", currentBonus).replace(".0", "");
                lore.add(ColorHelper.parse("&7Bonus: &#FFBFBF+" + currentBonusString + type.getSuffix()));
            }
        }
        lore.add("");
        if (isMaxLevel) {
            lore.add("\u00a7c\u00a7lMAX LEVEL REACHED");
            lore.add("\u00a78\u00a7m--------------------");
        } else {
            lore.add("\u00a7cNext Upgrade:");
            double nextBonus = (double)(currentLevel + 1) * bonusPerLevel;
            String nextBonusString = String.format("%.1f", nextBonus).replace(".0", "");
            lore.add(ColorHelper.parse(" &f\u25aa &#FFBFBFLevel: " + (currentLevel + 1) + " &7(&4+" + nextBonusString + type.getSuffix() + "&7)"));
            double cost = data.getBaseCost() * Math.pow(data.getCostMultiplier(), currentLevel);
            lore.add(ColorHelper.parse(" \u00a7f\u25aa &#FFBFBFCost: \u00a7c$" + String.format("%,.0f", cost)));
            lore.add("\u00a78\u00a7m--------------------");
            lore.add("");
            lore.add("\u00a7aClick to Upgrade");
        }
        ItemStack item = GuiHelper.createGuiItem(material, ColorHelper.parse("&#FFBFBF" + type.getDisplayName()), lore.toArray(new String[0]));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "upgrade_type"), PersistentDataType.STRING, (Object)type.name());
            if (isMaxLevel) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public void handleClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemMeta clickedMeta = clickedItem.getItemMeta();
        if (clickedMeta == null) {
            return;
        }
        int clickedSlot = event.getSlot();
        if (clickedSlot == 44) {
            player.closeInventory();
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.8f, 0.8f);
            return;
        }
        String upgradeTypeName = (String)clickedMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "upgrade_type"), PersistentDataType.STRING);
        if (upgradeTypeName == null) {
            return;
        }
        UpgradeType upgradeType = UpgradeType.valueOf(upgradeTypeName);
        ItemStack elytra = player.getInventory().getChestplate();
        if (elytra == null || !this.armoredElytraHelper.isArmoredElytra(elytra)) {
            player.closeInventory();
            this.messagesHelper.sendPlayerMessage(player, "&cYou must be wearing an Armored Elytra.");
            return;
        }
        ItemMeta elytraMeta = elytra.getItemMeta();
        if (elytraMeta == null) {
            return;
        }
        PersistentDataContainer container = elytraMeta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, upgradeType.getKey());
        int currentLevel = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
        ElytraUpgrade data = this.upgradeHandler.getUpgradeValues().get((Object)upgradeType);
        int maxLevel = data != null ? data.getMaxLevel() : upgradeType.getMaxLevel();
        double baseCost = data != null ? data.getBaseCost() : 1000.0;
        double costMultiplier = data != null ? data.getCostMultiplier() : 1.0;
        if ((currentLevel = Math.min(currentLevel, maxLevel)) >= maxLevel) {
            this.messagesHelper.sendPlayerMessage(player, "&cThis upgrade is already at its maximum level.");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        double cost = baseCost * Math.pow(costMultiplier, currentLevel);
        if (this.economy != null) {
            if (this.economy.getBalance((OfflinePlayer)player) < cost) {
                this.messagesHelper.sendPlayerMessage(player, "&cYou don't have enough money for this upgrade.");
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                return;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, cost);
        } else {
            this.plugin.getLogger().warning("No Vault economy provider found. Elytra upgrades will be free.");
        }
        container.set(new NamespacedKey((Plugin)this.plugin, upgradeType.getKey()), PersistentDataType.INTEGER, (Object)(currentLevel + 1));
        elytra.setItemMeta(elytraMeta);
        this.updateElytraLore(elytra, player.getName());
        if (upgradeType == UpgradeType.ARMOR_DURABILITY || upgradeType == UpgradeType.ARMOR_PROTECTION || upgradeType == UpgradeType.ARMOR_TOUGHNESS) {
            this.armoredElytraHandler.removeArmorAttributes(player);
            this.armoredElytraHandler.applyUpgradedAttributes(player, elytra);
        }
        player.getInventory().setChestplate(elytra);
        player.getInventory().setChestplate(elytra);
        this.messagesHelper.sendPlayerMessage(player, "&aSuccessfully upgraded " + upgradeType.getDisplayName() + " to Level " + (currentLevel + 1) + "!");
        player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 1.2f);
        this.open(player);
    }

    private void updateElytraLore(ItemStack elytra, String playerName) {
        ItemMeta elytraMeta = elytra.getItemMeta();
        if (elytraMeta == null) {
            return;
        }
        PersistentDataContainer container = elytraMeta.getPersistentDataContainer();
        ArrayList<String> baseLore = new ArrayList<String>();
        if (elytraMeta.getLore() != null) {
            String line;
            Iterator iterator = elytraMeta.getLore().iterator();
            while (iterator.hasNext() && !(line = (String)iterator.next()).contains("Upgrades:")) {
                baseLore.add(line);
            }
        }
        while (!baseLore.isEmpty() && ((String)baseLore.get(baseLore.size() - 1)).trim().isEmpty()) {
            baseLore.remove(baseLore.size() - 1);
        }
        ArrayList<String> upgradeLines = new ArrayList<String>();
        for (UpgradeType type : UpgradeType.values()) {
            boolean exceeded;
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, type.getKey());
            int level = (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
            if (level <= 0) continue;
            ElytraUpgrade data = this.upgradeHandler.getUpgradeValues().get((Object)type);
            int maxLevel = data != null ? data.getMaxLevel() : type.getMaxLevel();
            boolean bl = exceeded = level > maxLevel;
            if (exceeded) {
                container.set(key, PersistentDataType.INTEGER, (Object)maxLevel);
                elytra.setItemMeta(elytraMeta);
                this.plugin.getLogger().warning(String.format("Corrected elytra upgrade '%s' from '%s' (level %d > max %d). This item has been updated to respect current config limits.", type.name(), playerName, level, maxLevel));
                level = maxLevel;
            }
            double bonus = (double)level * type.getValuePerLevel();
            String bonusString = String.format("%.1f", bonus).replace(".0", "");
            upgradeLines.add(ColorHelper.parse(" &f\u25aa &7" + type.getDisplayName() + ": &#FFBFBFLevel " + level + " &7(&4+" + bonusString + type.getSuffix() + "&7)"));
        }
        if (!upgradeLines.isEmpty()) {
            baseLore.add("");
            baseLore.add(ColorHelper.parse("&cUpgrades:"));
            baseLore.addAll(upgradeLines);
        }
        elytraMeta.setLore(baseLore);
        elytra.setItemMeta(elytraMeta);
    }
}

