/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bruno.elytraEssentials.utils.PlayerStats;
import org.bruno.elytraEssentials.utils.StatType;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;

public class AchievementsHandler {
    private final DatabaseHandler databaseHandler;
    private final StatsHandler statsHandler;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final FileConfiguration fileConfiguration;
    private final Logger logger;
    private final MessagesHandler messagesHandler;
    private final Map<String, Achievement> achievements = new HashMap<String, Achievement>();
    private CancellableTask checkTask;

    public AchievementsHandler(DatabaseHandler databaseHandler, StatsHandler statsHandler, FoliaHelper foliaHelper, MessagesHelper messagesHelper, FileConfiguration fileConfiguration, Logger logger, MessagesHandler messagesHandler) {
        this.databaseHandler = databaseHandler;
        this.statsHandler = statsHandler;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.fileConfiguration = fileConfiguration;
        this.logger = logger;
        this.messagesHandler = messagesHandler;
        this.loadAchievements();
    }

    public void loadAchievements() {
        this.achievements.clear();
        ConfigurationSection achievementsSection = this.fileConfiguration.getConfigurationSection("achievements");
        if (achievementsSection == null) {
            this.logger.warning("No 'achievements' section found in achievements.yml.");
            return;
        }
        for (String key : achievementsSection.getKeys(false)) {
            String path = "achievements." + key;
            try {
                StatType type = StatType.valueOf(this.fileConfiguration.getString(path + ".type", "UNKNOWN").toUpperCase());
                String name = this.fileConfiguration.getString(path + ".name", "Unnamed Achievement");
                double value = this.fileConfiguration.getDouble(path + ".value");
                String description = this.fileConfiguration.getString(path + ".description", "&7No description provided.");
                Material displayItem = Material.matchMaterial((String)this.fileConfiguration.getString(path + ".display-item", "BARRIER"));
                String message = this.fileConfiguration.getString(path + ".message", "");
                List commands = this.fileConfiguration.getStringList(path + ".commands");
                List rewards = this.fileConfiguration.getStringList(path + ".rewards");
                boolean broadcast = this.fileConfiguration.getBoolean(path + ".broadcast", true);
                this.achievements.put(key, new Achievement(key, name, type, value, description, displayItem, message, commands, rewards, broadcast));
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Failed to load achievement '" + key + "'. Please check its format in achievements.yml.", e);
            }
        }
    }

    public void start() {
        if (this.checkTask != null) {
            return;
        }
        this.checkTask = this.foliaHelper.runTaskTimerGlobal(() -> this.foliaHelper.runAsyncTask(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.checkAndAwardAchievements(player);
            }
        }), 1200L, 1200L);
    }

    public void shutdown() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
            this.checkTask = null;
        }
    }

    public Collection<Achievement> getAllAchievements() {
        return this.achievements.values();
    }

    private void checkAndAwardAchievements(Player player) {
        PlayerStats stats = this.statsHandler.getStats(player);
        if (stats == null) {
            return;
        }
        for (Achievement achievement : this.achievements.values()) {
            try {
                double playerValue;
                if (this.databaseHandler.hasAchievement(player.getUniqueId(), achievement.id()) || !((playerValue = this.getStatValue(stats, achievement.type())) >= achievement.value())) continue;
                this.awardAchievement(player, achievement);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Database error while checking achievements for " + player.getName(), e);
            }
        }
    }

    private void awardAchievement(Player player, Achievement achievement) throws SQLException {
        this.databaseHandler.addAchievement(player.getUniqueId(), achievement.id());
        this.foliaHelper.runTask((Entity)player, () -> {
            for (String command : achievement.commands()) {
                try {
                    String formattedCommand = command.replace("{player}", player.getName());
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)formattedCommand);
                }
                catch (Exception e) {
                    this.logger.warning("Failed to execute achievement command: '" + command + "'. Error: " + e.getMessage());
                }
            }
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
            Firework firework = (Firework)player.getWorld().spawn(player.getLocation(), Firework.class);
            FireworkMeta fireworkMeta = firework.getFireworkMeta();
            fireworkMeta.addEffect(FireworkEffect.builder().with(FireworkEffect.Type.BALL_LARGE).withColor(new Color[]{Color.LIME, Color.YELLOW, Color.AQUA, Color.RED, Color.FUCHSIA}).withFade(Color.WHITE).withFlicker().withTrail().build());
            fireworkMeta.setPower(0);
            firework.setFireworkMeta(fireworkMeta);
            if (!achievement.message().isEmpty()) {
                String formattedMessage = ColorHelper.parse(achievement.message()).replace("{player}", player.getName());
                if (achievement.broadcast()) {
                    Bukkit.broadcastMessage((String)formattedMessage);
                } else {
                    this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getAchievementUnlockedMessage().replace("{0}", achievement.name));
                }
            }
        });
    }

    private double getStatValue(PlayerStats stats, StatType type) {
        return switch (type) {
            case StatType.TOTAL_DISTANCE -> stats.getTotalDistance();
            case StatType.LONGEST_FLIGHT -> stats.getLongestFlight();
            case StatType.TOTAL_FLIGHT_TIME -> stats.getTotalTimeSeconds();
            case StatType.BOOSTS_USED -> stats.getBoostsUsed();
            case StatType.SUPER_BOOSTS_USED -> stats.getSuperBoostsUsed();
            case StatType.SAVES -> stats.getPluginSaves();
            default -> 0.0;
        };
    }

    public record Achievement(String id, String name, StatType type, double value, String description, Material displayItem, String message, List<String> commands, List<String> rewards, boolean broadcast) {
    }
}

