/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.UpgradeHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.utils.ServerVersion;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArmoredElytraHandler {
    private final ElytraEssentials plugin;
    private final ConfigHandler configHandler;
    private final FoliaHelper foliaHelper;
    private final ArmoredElytraHelper armoredElytraHelper;
    private final MessagesHelper messagesHelper;
    private final MessagesHandler messagesHandler;
    private final UpgradeHandler upgradeHandler;
    private final NamespacedKey armoredElytraKey;
    private final NamespacedKey toughnessElytraKey;
    private final NamespacedKey materialKey;
    private final NamespacedKey durabilityKey;
    private final NamespacedKey maxDurabilityKey;

    public ArmoredElytraHandler(ElytraEssentials plugin, ConfigHandler configHandler, FoliaHelper foliaHelper, ArmoredElytraHelper armoredElytraHelper, MessagesHelper messagesHelper, MessagesHandler messagesHandler, UpgradeHandler upgradeHandler) {
        this.plugin = plugin;
        this.configHandler = configHandler;
        this.foliaHelper = foliaHelper;
        this.armoredElytraHelper = armoredElytraHelper;
        this.messagesHelper = messagesHelper;
        this.messagesHandler = messagesHandler;
        this.upgradeHandler = upgradeHandler;
        this.armoredElytraKey = new NamespacedKey((Plugin)plugin, "armored-elytra");
        this.toughnessElytraKey = new NamespacedKey((Plugin)plugin, "armor-durability");
        this.materialKey = new NamespacedKey((Plugin)plugin, "armor-material");
        this.durabilityKey = new NamespacedKey((Plugin)plugin, "armor-durability");
        this.maxDurabilityKey = new NamespacedKey((Plugin)plugin, "max-armor-durability");
    }

    public void handleDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.configHandler.getIsArmoredElytraEnabled()) {
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (!this.armoredElytraHelper.isArmoredElytra(chestplate)) {
            return;
        }
        ItemMeta meta = chestplate.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int currentDurability = (Integer)container.getOrDefault(this.durabilityKey, PersistentDataType.INTEGER, (Object)0);
        if (currentDurability <= 0) {
            return;
        }
        double initialDamage = event.getDamage();
        double finalDamage = this.applyAllProtection(initialDamage, container, event.getCause());
        event.setDamage(finalDamage);
        double absorbed = initialDamage - finalDamage;
        double totalAbsorbed = ((Float)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "damage-absorbed"), PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
        container.set(new NamespacedKey((Plugin)this.plugin, "damage-absorbed"), PersistentDataType.FLOAT, (Object)Float.valueOf((float)(totalAbsorbed + absorbed)));
        int newDurability = currentDurability - 1;
        container.set(this.durabilityKey, PersistentDataType.INTEGER, (Object)newDurability);
        this.updateDurabilityLore(meta);
        chestplate.setItemMeta(meta);
        if (newDurability <= 0) {
            int shatteredCount = (Integer)container.getOrDefault(new NamespacedKey((Plugin)this.plugin, "plating-shattered"), PersistentDataType.INTEGER, (Object)0);
            container.set(new NamespacedKey((Plugin)this.plugin, "plating-shattered"), PersistentDataType.INTEGER, (Object)(shatteredCount + 1));
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getArmoredElytraBroken());
        }
    }

    public void scheduleArmorCheck(Player player) {
        this.foliaHelper.runTask((Entity)player, () -> this.checkAndApplyArmor(player));
    }

    private void checkAndApplyArmor(Player player) {
        ItemStack chestplate = player.getInventory().getChestplate();
        this.removeArmorAttributes(player);
        if (this.armoredElytraHelper.isArmoredElytra(chestplate)) {
            ItemMeta meta = chestplate.getItemMeta();
            if (meta == null) {
                return;
            }
            int currentDurability = (Integer)meta.getPersistentDataContainer().getOrDefault(this.durabilityKey, PersistentDataType.INTEGER, (Object)0);
            if (currentDurability > 0) {
                this.applyUpgradedAttributes(player, chestplate);
            }
        }
    }

    public void applyUpgradedAttributes(Player player, ItemStack armoredElytra) {
        ItemMeta meta = armoredElytra.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Material armorType = this.getArmorMaterialFromNbt(armoredElytra);
        if (armorType == null) {
            return;
        }
        int baseArmor = this.getArmorPoints(armorType);
        int baseToughness = this.getArmorToughness(armorType);
        short baseMaxDurability = armorType.getMaxDurability();
        double bonusArmor = this.upgradeHandler.getBonusArmor(armoredElytra);
        double bonusToughness = this.upgradeHandler.getBonusToughness(armoredElytra);
        int bonusDurability = this.upgradeHandler.getBonusArmorDurability(armoredElytra);
        double finalArmor = (double)baseArmor + bonusArmor;
        double finalToughness = (double)baseToughness + bonusToughness;
        int finalMaxDurability = baseMaxDurability + bonusDurability;
        int currentMax = (Integer)container.getOrDefault(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)0);
        if (currentMax < finalMaxDurability) {
            container.set(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)finalMaxDurability);
        }
        this.updateArmorLore(meta, finalArmor);
        this.updateToughnessLore(meta, finalToughness);
        this.updateDurabilityLore(meta);
        armoredElytra.setItemMeta(meta);
        if (finalArmor > 0.0) {
            this.armoredElytraHelper.setArmorModifier(player, this.armoredElytraKey, finalArmor);
        }
        if (finalToughness > 0.0) {
            this.armoredElytraHelper.setToughnessModifier(player, this.toughnessElytraKey, finalToughness);
        }
    }

    public void removeArmorAttributes(Player player) {
        this.armoredElytraHelper.removeArmorModifier(player, this.armoredElytraKey);
        this.armoredElytraHelper.removeToughnessModifier(player, this.toughnessElytraKey);
    }

    private void updateDurabilityLore(ItemMeta meta) {
        double percentage;
        PersistentDataContainer container = meta.getPersistentDataContainer();
        int current = (Integer)container.getOrDefault(this.durabilityKey, PersistentDataType.INTEGER, (Object)0);
        int max = (Integer)container.getOrDefault(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)1);
        ArrayList<String> lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        String durabilityBar = this.armoredElytraHelper.getDurabilityBarString(current, max);
        int barIndex = -1;
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains("\u2586")) continue;
            barIndex = i;
        }
        if (barIndex != -1) {
            lore.set(barIndex, durabilityBar);
        }
        double d = percentage = max > 0 ? (double)current / (double)max : 0.0;
        String durabilityColor = percentage == 1.0 ? "\u00a7a" : (percentage > 0.5 ? "\u00a7e" : (percentage > 0.2 ? "\u00a7c" : "\u00a74"));
        String durabilityLine = String.format("\u00a76Armor Plating: %s%d \u00a77/ \u00a7a%d", durabilityColor, current, max);
        boolean found = false;
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains("Armor Plating:")) continue;
            lore.set(i, durabilityLine);
            found = true;
            break;
        }
        if (!found) {
            lore.add(durabilityLine);
        }
        meta.setLore(lore);
    }

    private void updateArmorLore(ItemMeta meta, double finalArmor) {
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        String armorLine = ColorHelper.parse(String.format(" \u00a7f\u25aa \u00a77Armor: &#B0D0FF+%.1f", finalArmor));
        for (int i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains("Armor:")) continue;
            lore.set(i, armorLine);
            meta.setLore(lore);
            return;
        }
    }

    private void updateToughnessLore(ItemMeta meta, double finalToughness) {
        int i;
        List lore = meta.getLore();
        if (lore == null) {
            return;
        }
        String toughnessLine = ColorHelper.parse(String.format(" &f\u25aa &7Armor Toughness: &#B0D0FF+%.1f", finalToughness));
        boolean found = false;
        for (i = 0; i < lore.size(); ++i) {
            if (!((String)lore.get(i)).contains("Armor Toughness:")) continue;
            lore.set(i, toughnessLine);
            found = true;
            break;
        }
        if (!found && finalToughness > 0.0) {
            for (i = 0; i < lore.size(); ++i) {
                if (!((String)lore.get(i)).contains("Armor:")) continue;
                lore.add(i + 1, toughnessLine);
                break;
            }
        }
        meta.setLore(lore);
    }

    private double applyAllProtection(double damage, PersistentDataContainer container, EntityDamageEvent.DamageCause cause) {
        String protectionKey = this.resolveProtectionKeyAlias("PROTECTION");
        String fireProtKeyStr = this.resolveProtectionKeyAlias("FIRE_PROTECTION");
        String blastProtKeyStr = this.resolveProtectionKeyAlias("BLAST_PROTECTION");
        String projProtKeyStr = this.resolveProtectionKeyAlias("PROJECTILE_PROTECTION");
        int protectionLevel = this.getLevel(container, "chestplate_enchant_" + protectionKey);
        int fireProtLevel = this.getLevel(container, "chestplate_enchant_" + fireProtKeyStr);
        int blastProtLevel = this.getLevel(container, "chestplate_enchant_" + blastProtKeyStr);
        int projProtLevel = this.getLevel(container, "chestplate_enchant_" + projProtKeyStr);
        double reduction = 0.0;
        if (this.isFireDamage(cause)) {
            reduction += (double)fireProtLevel * 0.15;
        }
        if (cause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || cause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            reduction += (double)blastProtLevel * 0.15;
        }
        if (cause == EntityDamageEvent.DamageCause.PROJECTILE) {
            reduction += (double)projProtLevel * 0.15;
        }
        return damage * (1.0 - Math.min(reduction += (double)protectionLevel * 0.04, 0.8));
    }

    private boolean isFireDamage(EntityDamageEvent.DamageCause cause) {
        return cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.LAVA || cause == EntityDamageEvent.DamageCause.HOT_FLOOR;
    }

    private String resolveProtectionKeyAlias(String key) {
        if (ServerVersion.getCurrent().equals((Object)ServerVersion.V_1_18) || ServerVersion.getCurrent().equals((Object)ServerVersion.V_1_19) || ServerVersion.getCurrent().equals((Object)ServerVersion.V_1_20)) {
            return switch (key) {
                case "PROTECTION" -> "PROTECTION_ENVIRONMENTAL";
                case "FIRE_PROTECTION" -> "PROTECTION_FIRE";
                case "BLAST_PROTECTION" -> "PROTECTION_EXPLOSIONS";
                case "PROJECTILE_PROTECTION" -> "PROTECTION_PROJECTILE";
                default -> key;
            };
        }
        return key;
    }

    private int getLevel(PersistentDataContainer container, String key) {
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)this.plugin, key.toLowerCase());
        return (Integer)container.getOrDefault(namespacedKey, PersistentDataType.INTEGER, (Object)0);
    }

    private Material getArmorMaterialFromNbt(ItemStack armoredElytra) {
        if (armoredElytra == null || !armoredElytra.hasItemMeta()) {
            return null;
        }
        String materialName = (String)Objects.requireNonNull(armoredElytra.getItemMeta()).getPersistentDataContainer().get(this.materialKey, PersistentDataType.STRING);
        return materialName != null ? Material.matchMaterial((String)materialName) : null;
    }

    private int getArmorPoints(Material armorType) {
        return switch (armorType) {
            case Material.LEATHER_CHESTPLATE -> 3;
            case Material.CHAINMAIL_CHESTPLATE, Material.GOLDEN_CHESTPLATE -> 5;
            case Material.IRON_CHESTPLATE -> 6;
            case Material.DIAMOND_CHESTPLATE, Material.NETHERITE_CHESTPLATE -> 8;
            default -> 0;
        };
    }

    private int getArmorToughness(Material armorType) {
        return switch (armorType) {
            case Material.DIAMOND_CHESTPLATE -> 2;
            case Material.NETHERITE_CHESTPLATE -> 3;
            default -> 0;
        };
    }
}

