/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.handlers.JumpAnimationHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.handlers.UpgradeHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bruno.elytraEssentials.utils.PlayerStats;
import org.bruno.elytraEssentials.utils.ServerVersion;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class BoostHandler {
    private static final long MINIMUM_SPAM_DELAY_MS = 50L;
    private static final double BOOST_FORCE = 0.05;
    private static final double SUPER_BOOST_FORCE = 0.08;
    private static final int BOOST_DURATION_TICKS = 20;
    private final ElytraEssentials plugin;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final ServerVersion serverVersion;
    private final StatsHandler statsHandler;
    private final ConfigHandler configHandler;
    private final MessagesHandler messagesHandler;
    private final UpgradeHandler upgradeHandler;
    private final JumpAnimationHandler jumpAnimationHandler;
    private FlightHandler flightHandler;
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> cooldownMessageSent = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> superBoostMessageExpirations = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> boostMessageExpirations = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, CancellableTask> chargingTasks = new ConcurrentHashMap<UUID, CancellableTask>();
    private final Map<UUID, BossBar> chargeBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private final Map<UUID, CancellableTask> activeBoostTasks = new ConcurrentHashMap<UUID, CancellableTask>();

    public BoostHandler(ElytraEssentials plugin, FoliaHelper foliaHelper, MessagesHelper messagesHelper, ServerVersion serverVersion, StatsHandler statsHandler, ConfigHandler configHandler, MessagesHandler messagesHandler, UpgradeHandler upgradeHandler, JumpAnimationHandler jumpAnimationHandler) {
        this.plugin = plugin;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.serverVersion = serverVersion;
        this.statsHandler = statsHandler;
        this.configHandler = configHandler;
        this.messagesHandler = messagesHandler;
        this.upgradeHandler = upgradeHandler;
        this.jumpAnimationHandler = jumpAnimationHandler;
    }

    public void setFlightHandler(FlightHandler flightHandler) {
        this.flightHandler = flightHandler;
    }

    public void handleInteract(Player player, boolean isGliding, boolean isSneaking, boolean isOnGround) {
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        Material boostMaterial = Material.valueOf((String)this.configHandler.getBoostItem());
        if (itemInHand.getType() != boostMaterial) {
            return;
        }
        if (isGliding) {
            this.handleInAirBoost(player);
        } else if (isSneaking && isOnGround) {
            this.handleChargedJump(player, boostMaterial);
        }
    }

    public void handlePlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.cooldowns.remove(playerId);
        this.cooldownMessageSent.remove(playerId);
        this.boostMessageExpirations.remove(playerId);
        this.superBoostMessageExpirations.remove(playerId);
        this.cancelCharge(event.getPlayer());
    }

    public void handleToggleSneak(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        if (!event.isSneaking() && this.chargingTasks.containsKey(player.getUniqueId())) {
            player.playSound(player.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, 0.7f, 1.2f);
            this.cancelCharge(player);
        }
    }

    public boolean isBoostActive(UUID uuid) {
        Long expiryTime = this.boostMessageExpirations.get(uuid);
        if (expiryTime == null) {
            return false;
        }
        if (System.currentTimeMillis() > expiryTime) {
            this.boostMessageExpirations.remove(uuid);
            return false;
        }
        return true;
    }

    public boolean isSuperBoostActive(UUID uuid) {
        Long expiryTime = this.superBoostMessageExpirations.get(uuid);
        if (expiryTime == null) {
            return false;
        }
        if (System.currentTimeMillis() > expiryTime) {
            this.superBoostMessageExpirations.remove(uuid);
            return false;
        }
        return true;
    }

    private void handleInAirBoost(Player player) {
        double baseForce;
        if (!this.configHandler.getIsBoostEnabled()) {
            return;
        }
        if (!PermissionsHelper.hasElytraBoostPermission(player) && !PermissionsHelper.hasElytraSuperBoostPermission(player)) {
            return;
        }
        if (this.isOnCooldown(player)) {
            return;
        }
        PlayerStats stats = this.statsHandler.getStats(player);
        boolean isSuperBoost = player.isSneaking();
        if (isSuperBoost) {
            if (!PermissionsHelper.hasElytraSuperBoostPermission(player)) {
                return;
            }
            stats.incrementSuperBoostsUsed();
            baseForce = 0.08;
        } else {
            if (!PermissionsHelper.hasElytraBoostPermission(player)) {
                return;
            }
            stats.incrementBoostsUsed();
            baseForce = 0.05;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        double bonusPowerPercent = this.upgradeHandler.getBonusBoostPower(chestplate);
        double finalForce = baseForce * (1.0 + bonusPowerPercent / 100.0);
        this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        this.cancelBoost(player.getUniqueId());
        AtomicInteger ticksRemaining = new AtomicInteger(20);
        CancellableTask boostTask = this.foliaHelper.runTaskTimerForEntity((Entity)player, () -> {
            if (!player.isOnline() || !player.isGliding() || ticksRemaining.getAndDecrement() <= 0) {
                this.cancelBoost(player.getUniqueId());
                return;
            }
            Vector direction = player.getLocation().getDirection();
            Vector boost = direction.multiply(finalForce);
            player.setVelocity(player.getVelocity().add(boost));
            if (isSuperBoost) {
                player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 2, 0.1, 0.1, 0.1, 0.05);
            } else {
                player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 1, 0.1, 0.1, 0.1, 0.05);
            }
        }, 1L, 1L);
        this.activeBoostTasks.put(player.getUniqueId(), boostTask);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 1.0f, 1.0f);
        if (isSuperBoost) {
            this.superBoostMessageExpirations.put(player.getUniqueId(), System.currentTimeMillis() + 1000L);
        } else {
            this.boostMessageExpirations.put(player.getUniqueId(), System.currentTimeMillis() + 1000L);
        }
    }

    private void cancelBoost(UUID playerId) {
        CancellableTask task = this.activeBoostTasks.remove(playerId);
        if (task != null) {
            task.cancel();
        }
    }

    private void handleChargedJump(Player player, Material boostMaterial) {
        int currentTime;
        if (!this.configHandler.getIsBoostEnabled() || !this.configHandler.getIsChargedJumpEnabled()) {
            return;
        }
        if (this.configHandler.getIsTimeLimitEnabled() && !PermissionsHelper.playerBypassTimeLimit(player) && (currentTime = this.flightHandler.getCurrentFlightTime(player.getUniqueId())) == 0) {
            this.messagesHelper.sendActionBarMessage(player, this.messagesHandler.getElytraFlightTimeExpired());
            return;
        }
        if (this.chargingTasks.containsKey(player.getUniqueId())) {
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (chestplate == null || chestplate.getType() != Material.ELYTRA) {
            return;
        }
        if (!PermissionsHelper.hasChargedJumpPermission(player)) {
            return;
        }
        if (this.isOnCooldown(player)) {
            return;
        }
        double chargeTimeSeconds = this.configHandler.getChargeTime();
        if (chargeTimeSeconds <= 0.0) {
            return;
        }
        long totalTicksToCharge = (long)(chargeTimeSeconds * 20.0);
        BossBar bossBar = this.plugin.getServer().createBossBar("\u00a7aCharging Jump... \u00a720%", BarColor.GREEN, BarStyle.SOLID, new BarFlag[0]);
        bossBar.setProgress(0.0);
        bossBar.addPlayer(player);
        this.chargeBossBars.put(player.getUniqueId(), bossBar);
        AtomicLong ticksElapsed = new AtomicLong(0L);
        CancellableTask task = this.foliaHelper.runTaskTimerForEntity((Entity)player, () -> {
            ItemStack currentItem = player.getInventory().getItemInMainHand();
            if (!(player.isOnline() && player.isSneaking() && player.isOnGround() && currentItem.getType() == boostMaterial)) {
                this.cancelCharge(player);
                return;
            }
            long currentTick = ticksElapsed.incrementAndGet();
            double progress = (double)currentTick / (double)totalTicksToCharge;
            bossBar.setProgress(Math.min(1.0, progress));
            int percentage = (int)(progress * 100.0);
            bossBar.setTitle("\u00a7aCharging Jump... \u00a72" + percentage + "%");
            if (progress > 0.75) {
                bossBar.setTitle("\u00a7cCharging Jump... \u00a74" + percentage + "%");
                bossBar.setColor(BarColor.RED);
            } else if (progress > 0.4) {
                bossBar.setTitle("\u00a7eCharging Jump... \u00a76" + percentage + "%");
                bossBar.setColor(BarColor.YELLOW);
            }
            this.playChargeUpEffect(player, currentTick, totalTicksToCharge);
            if (currentTick % 4L == 0L) {
                player.playSound(player.getLocation(), Sound.BLOCK_TRIPWIRE_CLICK_ON, 0.5f, 1.5f);
            }
            if (currentTick >= totalTicksToCharge) {
                this.messagesHelper.sendTitleMessage(player, "&r", "&#FFD700LAUNCH!", 5, 20, 10);
                double jumpStrength = this.configHandler.getJumpStrength();
                player.setVelocity(player.getVelocity().add(new Vector(0.0, jumpStrength, 0.0)));
                if (this.jumpAnimationHandler != null) {
                    this.jumpAnimationHandler.playLaunchAnimation(player);
                }
                this.foliaHelper.runTaskLater((Entity)player, () -> {
                    if (player.isOnline() && !player.isOnGround()) {
                        player.setGliding(true);
                        this.statsHandler.setGliding(player, true);
                        this.flightHandler.onGlideStartAttempt(player);
                    }
                }, 2L);
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.2f, 1.0f);
                if (this.serverVersion.ordinal() == ServerVersion.V_1_21.ordinal()) {
                    Particle particle = Particle.valueOf((String)"EXPLOSION");
                    player.getWorld().spawnParticle(particle, player.getLocation(), 1);
                    Particle particle2 = Particle.valueOf((String)"FIREWORK");
                    player.getWorld().spawnParticle(particle2, player.getLocation(), 30, 0.5, 0.5, 0.5, 0.1);
                } else {
                    Particle particle = Particle.valueOf((String)"EXPLOSION_NORMAL");
                    player.getWorld().spawnParticle(particle, player.getLocation(), 1);
                    Particle particle2 = Particle.valueOf((String)"FIREWORKS_SPARK");
                    player.getWorld().spawnParticle(particle2, player.getLocation(), 30, 0.5, 0.5, 0.5, 0.1);
                }
                this.cancelCharge(player);
            }
        }, 1L, 1L);
        this.chargingTasks.put(player.getUniqueId(), task);
    }

    private void cancelCharge(Player player) {
        BossBar bossBar;
        CancellableTask task = this.chargingTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
        if ((bossBar = this.chargeBossBars.remove(player.getUniqueId())) != null) {
            bossBar.removeAll();
        }
    }

    private boolean isOnCooldown(Player player) {
        int configuredCooldownMs = this.configHandler.getBoostCooldown();
        long effectiveCooldownMs = PermissionsHelper.playerBypassBoostCooldown(player) ? 50L : Math.max((long)configuredCooldownMs, 50L);
        long lastBoostTime = this.cooldowns.getOrDefault(player.getUniqueId(), 0L);
        long timeSinceLastBoost = System.currentTimeMillis() - lastBoostTime;
        if (timeSinceLastBoost < effectiveCooldownMs) {
            long lastMessageCooldownTime = this.cooldownMessageSent.getOrDefault(player.getUniqueId(), 0L);
            if (lastBoostTime != lastMessageCooldownTime && effectiveCooldownMs > 1000L) {
                long remainingMs = effectiveCooldownMs - timeSinceLastBoost;
                int remainingSeconds = Math.max(1, (int)Math.ceil((double)remainingMs / 1000.0));
                String messageTemplate = this.messagesHandler.getBoostCooldown();
                String message = messageTemplate.replace("{0}", String.valueOf(remainingSeconds));
                this.messagesHelper.sendPlayerMessage(player, message);
                this.cooldownMessageSent.put(player.getUniqueId(), lastBoostTime);
            }
            return true;
        }
        return false;
    }

    private void playChargeUpEffect(Player player, long ticksElapsed, long totalTicksToCharge) {
        Color startColor;
        double radius = 1.0;
        int particleCount = 20;
        double rotationSpeed = 0.1;
        double maxRiseHeight = 1.5;
        Location playerLocation = player.getLocation();
        double progress = (double)ticksElapsed / (double)totalTicksToCharge;
        double angleOffset = (double)ticksElapsed * rotationSpeed;
        double yOffset = progress * maxRiseHeight;
        if (progress < 0.5) {
            float r = (float)(progress * 2.0);
            startColor = Color.fromRGB((int)((int)(r * 255.0f)), (int)255, (int)0);
        } else {
            float g = (float)(1.0 - (progress - 0.5) * 2.0);
            startColor = Color.fromRGB((int)255, (int)((int)(g * 255.0f)), (int)0);
        }
        Particle.DustTransition dustOptions = new Particle.DustTransition(startColor, Color.RED, 1.0f);
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount + angleOffset;
            double x = playerLocation.getX() + radius * Math.cos(angle);
            double z = playerLocation.getZ() + radius * Math.sin(angle);
            Location particleLocation = new Location(player.getWorld(), x, playerLocation.getY() + yOffset, z);
            player.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, particleLocation, 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions, true);
        }
    }
}

