/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.helpers.TimeHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.projectiles.ProjectileSource;

public class CombatTagHandler {
    private final ConfigHandler configHandler;
    private final MessagesHelper messagesHelper;
    private final FoliaHelper foliaHelper;
    private final MessagesHandler messagesHandler;
    private final Map<UUID, Long> combatTaggedPlayers = new ConcurrentHashMap<UUID, Long>();
    private final Set<UUID> fallDamageProtection = ConcurrentHashMap.newKeySet();
    private final Map<UUID, BossBar> combatTagBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private CancellableTask countdownTask;

    public CombatTagHandler(ConfigHandler configHandler, MessagesHelper messagesHelper, FoliaHelper foliaHelper, MessagesHandler messagesHandler) {
        this.configHandler = configHandler;
        this.messagesHelper = messagesHelper;
        this.foliaHelper = foliaHelper;
        this.messagesHandler = messagesHandler;
    }

    public void start() {
        if (!this.configHandler.getIsCombatTagEnabled() || this.countdownTask != null) {
            return;
        }
        this.countdownTask = this.foliaHelper.runTaskTimerGlobal(() -> {
            Iterator<Map.Entry<UUID, Long>> iterator = this.combatTaggedPlayers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Long> entry = iterator.next();
                UUID playerId = entry.getKey();
                long expiryTime = entry.getValue();
                Player player = Bukkit.getPlayer((UUID)playerId);
                BossBar bossBar = this.combatTagBossBars.get(playerId);
                if (player == null || !player.isOnline() || bossBar == null) {
                    if (bossBar != null) {
                        bossBar.removeAll();
                    }
                    this.combatTagBossBars.remove(playerId);
                    iterator.remove();
                    continue;
                }
                long remainingMs = expiryTime - System.currentTimeMillis();
                if (remainingMs > 0L) {
                    double progress = (double)remainingMs / (double)((long)this.configHandler.getCombatTagCooldown() * 1000L);
                    int remainingSeconds = (int)Math.ceil((double)remainingMs / 1000.0);
                    bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                    bossBar.setTitle(ColorHelper.parse(this.messagesHandler.getCombatTagged().replace("{0}", TimeHelper.formatFlightTime(remainingSeconds))));
                    continue;
                }
                bossBar.removeAll();
                this.combatTagBossBars.remove(playerId);
                iterator.remove();
                this.messagesHelper.sendActionBarMessage(player, this.messagesHandler.getCombatTaggedExpired());
            }
        }, 20L, 20L);
    }

    public void shutdown() {
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        this.combatTagBossBars.values().forEach(BossBar::removeAll);
        this.combatTagBossBars.clear();
    }

    public void handleDamage(EntityDamageEvent event) {
        Player player;
        block13: {
            block12: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block12;
                player = (Player)entity;
                if (this.configHandler.getIsCombatTagEnabled() && player.isGliding()) break block13;
            }
            return;
        }
        if (PermissionsHelper.playerBypassCombatTag(player)) {
            return;
        }
        boolean playerDamageOnly = this.configHandler.getIsCombatTagPlayerDamageOnlyEnabled();
        boolean damageSourceIsValid = false;
        if (playerDamageOnly) {
            EntityDamageByEntityEvent damageByEntityEvent;
            Player damageSource;
            if (event instanceof EntityDamageByEntityEvent && (damageSource = this.getPlayerDamager(damageByEntityEvent = (EntityDamageByEntityEvent)event)) != null && !damageSource.getUniqueId().equals(player.getUniqueId())) {
                damageSourceIsValid = true;
            }
        } else if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageByEntityEvent = (EntityDamageByEntityEvent)event;
            Player damageSource = this.getPlayerDamager(damageByEntityEvent);
            if (damageSource != null && !damageSource.getUniqueId().equals(player.getUniqueId())) {
                damageSourceIsValid = true;
            }
        } else {
            damageSourceIsValid = true;
        }
        if (damageSourceIsValid) {
            this.applyCombatTag(player);
        }
    }

    public void handleGlideAttempt(EntityToggleGlideEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (this.configHandler.getIsCombatTagEnabled()) break block5;
            }
            return;
        }
        if (event.isGliding() && this.isCombatTagged(player)) {
            event.setCancelled(true);
            this.messagesHelper.sendActionBarMessage(player, this.messagesHandler.getCannotGlideCombatTagged());
        }
    }

    public void handleFallDamage(EntityDamageEvent event) {
        Player player;
        block5: {
            block4: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (this.configHandler.getIsCombatTagEnabled()) break block5;
            }
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && this.fallDamageProtection.remove(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    public void handlePlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.combatTaggedPlayers.remove(playerId);
        this.fallDamageProtection.remove(playerId);
        BossBar bossBar = this.combatTagBossBars.remove(playerId);
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    private void applyCombatTag(Player player) {
        if (PermissionsHelper.playerBypassCombatTag(player)) {
            return;
        }
        player.setGliding(false);
        long durationMs = (long)this.configHandler.getCombatTagCooldown() * 1000L;
        this.combatTaggedPlayers.put(player.getUniqueId(), System.currentTimeMillis() + durationMs);
        if (this.configHandler.getIsCombatTagPreventFallDamageEnabled()) {
            this.fallDamageProtection.add(player.getUniqueId());
        }
        BossBar bossBar = this.combatTagBossBars.computeIfAbsent(player.getUniqueId(), uuid -> {
            BossBar newBar = Bukkit.createBossBar((String)"Combat Tagged.", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            newBar.addPlayer(player);
            return newBar;
        });
        this.messagesHelper.sendActionBarMessage(player, "\u00a7cYour elytra has been disabled due to combat!");
    }

    private boolean isCombatTagged(Player player) {
        Long expiryTime = this.combatTaggedPlayers.get(player.getUniqueId());
        return expiryTime != null && System.currentTimeMillis() < expiryTime;
    }

    private Player getPlayerDamager(EntityDamageByEntityEvent event) {
        TNTPrimed tnt;
        Projectile proj;
        ProjectileSource projectileSource;
        Entity damager = event.getDamager();
        if (damager instanceof Player) {
            Player p = (Player)damager;
            return p;
        }
        if (damager instanceof Projectile && (projectileSource = (proj = (Projectile)damager).getShooter()) instanceof Player) {
            Player p = (Player)projectileSource;
            return p;
        }
        if (damager instanceof TNTPrimed && (projectileSource = (tnt = (TNTPrimed)damager).getSource()) instanceof Player) {
            Player p = (Player)projectileSource;
            return p;
        }
        return null;
    }
}

