/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import com.google.common.base.Function;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.TimeHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bruno.elytraEssentials.utils.PlayerStats;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseHandler {
    private final ElytraEssentials plugin;
    private final ConfigHandler configHandler;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final Logger logger;
    private HikariDataSource dataSource;
    private StorageType storageType;
    private String prefix;
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;
    private ConfigHandler.DatabaseOptions databaseOptions;
    private CancellableTask backupTask = null;

    public DatabaseHandler(ElytraEssentials plugin, ConfigHandler configHandler, FoliaHelper foliaHelper, MessagesHelper messagesHelper, Logger logger) {
        this.plugin = plugin;
        this.configHandler = configHandler;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.logger = logger;
        this.setDatabaseVariables();
    }

    public void initialize() throws SQLException {
        this.logger.info("Using " + this.storageType.name() + " for data storage.");
        if (this.storageType == StorageType.MYSQL) {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database);
            config.setUsername(this.username);
            config.setPassword(this.password);
            config.setMaximumPoolSize(this.databaseOptions.maximumPoolSize());
            config.setMinimumIdle(this.databaseOptions.minimumIdle());
            config.setConnectionTimeout(this.databaseOptions.connectionTimeout());
            config.setIdleTimeout(600000L);
            config.setKeepaliveTime(this.databaseOptions.keepaliveTime());
            config.setMaxLifetime(this.databaseOptions.maximumLifetime());
            config.setValidationTimeout(5000L);
            config.setConnectionTestQuery("SELECT 1");
            this.databaseOptions.properties().forEach(config::addDataSourceProperty);
            this.dataSource = new HikariDataSource(config);
        } else {
            File databaseFolder = new File(this.plugin.getDataFolder(), "database");
            if (!databaseFolder.exists() && !databaseFolder.mkdirs()) {
                throw new SQLException("FATAL: Failed to create database folder...");
            }
            File dbFile = new File(databaseFolder, "elytraessentials.db");
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:sqlite:" + dbFile.getAbsolutePath());
            config.setMaximumPoolSize(1);
            config.setPoolName("ElytraEssentials-SQLite");
            this.dataSource = new HikariDataSource(config);
        }
        this.logger.info("Database connection established.");
        this.initializeTables();
        this.migrateOldTables();
    }

    @NotNull
    private HikariConfig getHikariConfig() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database);
        config.setUsername(this.username);
        config.setPassword(this.password);
        config.setMaximumPoolSize(this.databaseOptions.maximumPoolSize());
        config.setMinimumIdle(this.databaseOptions.minimumIdle());
        config.setConnectionTimeout(this.databaseOptions.connectionTimeout());
        config.setIdleTimeout(600000L);
        config.setKeepaliveTime(this.databaseOptions.keepaliveTime());
        config.setMaxLifetime(this.databaseOptions.maximumLifetime());
        config.setValidationTimeout(5000L);
        config.setConnectionTestQuery("SELECT 1");
        return config;
    }

    public boolean isConnected() {
        return this.dataSource.isRunning();
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.dataSource.close();
            this.messagesHelper.sendDebugMessage(this.storageType.name() + " database connection closed successfully!");
        }
    }

    public void setDatabaseVariables() {
        String typeFromConfig = this.configHandler.getStorageType().toUpperCase();
        try {
            this.storageType = StorageType.valueOf(typeFromConfig);
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Invalid storage type '" + typeFromConfig + "' in config.yml. Defaulting to SQLITE.");
            this.storageType = StorageType.SQLITE;
        }
        this.prefix = this.configHandler.getPrefix();
        if (this.storageType == StorageType.MYSQL) {
            this.host = this.configHandler.getHost();
            this.port = this.configHandler.getPort();
            this.database = this.configHandler.getDatabase();
            this.username = this.configHandler.getUsername();
            this.password = this.configHandler.getPassword();
            this.databaseOptions = this.configHandler.getDataBaseOptions();
        }
    }

    public String getStorageType() {
        return this.storageType != null ? this.storageType.name() : "SQLITE";
    }

    public void start() {
        if (this.storageType != StorageType.SQLITE) {
            return;
        }
        if (!this.configHandler.getIsAutoBackupEnabled()) {
            return;
        }
        if (this.backupTask != null) {
            return;
        }
        long interval = TimeHelper.minutesToTicks(this.configHandler.getAutoBackupInterval());
        this.logger.info("Starting automatic database backup task...");
        this.backupTask = this.foliaHelper.runTaskTimerGlobal(() -> this.foliaHelper.runAsyncTask(this::backupSQLiteDatabase), interval, interval);
    }

    public void shutdown() {
        if (this.backupTask != null) {
            this.backupTask.cancel();
            this.backupTask = null;
        }
    }

    public void importFromBackup(String backupFileName, CommandSender sender, File backupFile) {
        this.logger.warning("Starting database import from backup: " + backupFileName);
        this.messagesHelper.sendCommandSenderMessage(sender, "&eStarting import process... Kicking all players.");
        try {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.kickPlayer("Server is restoring a data backup. Please reconnect in a moment.");
            }
            this.logger.info("All players kicked. Shutting down plugin services...");
            this.plugin.shutdownAllPluginTasks();
            this.disconnect();
            File databaseFolder = new File(this.plugin.getDataFolder(), "database");
            File liveDbFile = new File(databaseFolder, "elytraessentials.db");
            File tempDbFile = new File(databaseFolder, "import_temp.db");
            Files.copy(backupFile.toPath(), tempDbFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            try (Connection testConnection = DriverManager.getConnection("jdbc:sqlite:" + tempDbFile.getAbsolutePath());){
                if (!testConnection.isValid(2)) {
                    throw new SQLException("Import verification failed: Backup file is corrupted.");
                }
                this.logger.info("Backup file verified successfully.");
            }
            catch (SQLException e) {
                this.messagesHelper.sendCommandSenderMessage(sender, "&cImport failed! The backup file appears corrupted. No changes were made.");
                this.logger.log(Level.SEVERE, "Could not verify backup file '" + backupFileName + "'. Aborting.", e);
                if (!tempDbFile.delete()) {
                    this.logger.warning("Could not delete temporary DB file.");
                }
                this.initialize();
                this.plugin.startAllPluginTasks();
                return;
            }
            if (liveDbFile.exists() && !liveDbFile.delete()) {
                throw new IOException("Could not delete old live DB file.");
            }
            if (!tempDbFile.renameTo(liveDbFile)) {
                throw new IOException("Could not rename temp DB file.");
            }
            this.logger.info("Successfully restored backup. Re-initializing services...");
            this.initialize();
            this.plugin.startAllPluginTasks();
            this.messagesHelper.sendCommandSenderMessage(sender, "&aDatabase import successful! Players can now reconnect.");
            this.logger.info("Database import complete.");
        }
        catch (Exception e) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cA critical error occurred during import. Check console. The server may need a restart.");
            this.logger.log(Level.SEVERE, "Failed to perform database import.", e);
            try {
                this.initialize();
                this.plugin.startAllPluginTasks();
            }
            catch (SQLException ex) {
                this.logger.log(Level.SEVERE, "Failed to re-initialize services after a failed import.", ex);
            }
        }
    }

    public List<String> getBackupFileNames() {
        File[] files;
        if (this.storageType != StorageType.SQLITE) {
            return Collections.emptyList();
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        File backupFolder = new File(this.plugin.getDataFolder(), "database/backups");
        if (backupFolder.exists() && backupFolder.isDirectory() && (files = backupFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".db"))) != null) {
            for (File file : files) {
                fileNames.add(file.getName());
            }
        }
        return fileNames;
    }

    private void backupSQLiteDatabase() {
        File databaseFolder = new File(this.plugin.getDataFolder(), "database");
        File sourceFile = new File(databaseFolder, "elytraessentials.db");
        if (!sourceFile.exists()) {
            this.logger.warning("SQLite database file not found. Skipping backup.");
            return;
        }
        File backupFolder = new File(databaseFolder, "backups");
        if (!backupFolder.exists() && !backupFolder.mkdirs()) {
            this.logger.severe("Could not create backups folder! Please check file system permissions. Skipping backup.");
            return;
        }
        File[] backupFiles = backupFolder.listFiles((dir, name) -> name.endsWith(".db"));
        if (backupFiles != null && backupFiles.length >= this.configHandler.getAutoBackupMaxBackups()) {
            Arrays.sort(backupFiles, Comparator.comparingLong(File::lastModified));
            File oldestFile = backupFiles[0];
            if (oldestFile.delete()) {
                this.messagesHelper.sendDebugMessage("Deleted oldest backup file: " + oldestFile.getName());
            } else {
                this.logger.warning("Could not delete oldest backup file: " + oldestFile.getName());
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy_HH-mm-ss");
        String formattedDate = formatter.format(new Date());
        String backupFileName = "backup_" + formattedDate + ".db";
        File destinationFile = new File(backupFolder, backupFileName);
        try {
            Files.copy(sourceFile.toPath(), destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.messagesHelper.sendDebugMessage("Successfully created database backup: " + destinationFile.getName());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Could not create SQLite database backup! Check file permissions.", e);
        }
    }

    public int getPlayerFlightTime(UUID uuid) throws SQLException {
        String tableName = this.applyPrefix("elytra_flight_time");
        String query = "SELECT flight_time FROM " + tableName + " WHERE uuid = ?";
        return (Integer)this.withConnection(connection -> {
            try (PreparedStatement stmt = connection.prepareStatement(query);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return 0;
                    Integer n = rs.getInt("flight_time");
                    return n;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void setPlayerFlightTime(UUID uuid, int time) throws SQLException {
        String tableName = this.applyPrefix("elytra_flight_time");
        String query = this.storageType == StorageType.MYSQL ? "INSERT INTO " + tableName + " (uuid, flight_time) VALUES (?, ?) ON DUPLICATE KEY UPDATE flight_time = ?" : "REPLACE INTO " + tableName + " (uuid, flight_time) VALUES (?, ?)";
        this.withConnection(connection -> {
            Object var6_7;
            block9: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, uuid.toString());
                    stmt.setInt(2, time);
                    if (this.storageType == StorageType.MYSQL) {
                        stmt.setInt(3, time);
                    }
                    stmt.executeUpdate();
                    var6_7 = null;
                    if (stmt == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var6_7;
        });
    }

    public void addOwnedEffect(UUID playerUuid, String effectKey) throws SQLException {
        String tableName = this.applyPrefix("owned_effects");
        String query = this.storageType == StorageType.MYSQL ? "INSERT IGNORE INTO " + tableName + " (player_uuid, effect_key, is_active) VALUES (?, ?, ?)" : "INSERT OR IGNORE INTO " + tableName + " (player_uuid, effect_key, is_active) VALUES (?, ?, ?)";
        this.withConnection(connection -> {
            Object var5_6;
            block8: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, playerUuid.toString());
                    stmt.setString(2, effectKey);
                    stmt.setBoolean(3, false);
                    stmt.executeUpdate();
                    var5_6 = null;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var5_6;
        });
    }

    public void removeOwnedEffect(UUID playerUuid, String effectKey) throws SQLException {
        String tableName = this.applyPrefix("owned_effects");
        String query = "DELETE FROM " + tableName + " WHERE player_uuid = ? AND effect_key = ?";
        this.withConnection(connection -> {
            Object var5_6;
            block8: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, playerUuid.toString());
                    stmt.setString(2, effectKey);
                    stmt.executeUpdate();
                    var5_6 = null;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var5_6;
        });
    }

    public void updateOwnedEffect(UUID playerId, String effectKey, boolean isActive) throws SQLException {
        String tableName = this.applyPrefix("owned_effects");
        String query = "UPDATE " + tableName + " SET is_active = ? WHERE player_uuid = ? AND effect_key = ?";
        this.withConnection(connection -> {
            Object var6_7;
            block8: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setBoolean(1, isActive);
                    stmt.setString(2, playerId.toString());
                    stmt.setString(3, effectKey);
                    stmt.executeUpdate();
                    var6_7 = null;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var6_7;
        });
    }

    public List<String> getOwnedEffectKeys(UUID playerId) throws SQLException {
        String tableName = this.applyPrefix("owned_effects");
        String query = "SELECT effect_key FROM " + tableName + " WHERE player_uuid = ?";
        return (List)this.withConnection(connection -> {
            ArrayList<String> arrayList;
            block16: {
                ArrayList<String> ownedEffects = new ArrayList<String>();
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, playerId.toString());
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            ownedEffects.add(rs.getString("effect_key"));
                        }
                    }
                    arrayList = ownedEffects;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return arrayList;
        });
    }

    @Nullable
    public String getPlayerActiveEffect(UUID playerId) throws SQLException {
        String tableName = this.applyPrefix("owned_effects");
        String query = "SELECT effect_key FROM " + tableName + " WHERE player_uuid = ? AND is_active = 1";
        return (String)this.withConnection(connection -> {
            try (PreparedStatement stmt = connection.prepareStatement(query);){
                stmt.setString(1, playerId.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    String string = rs.getString("effect_key");
                    return string;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public PlayerStats getPlayerStats(UUID uuid) throws SQLException {
        String tableName = this.applyPrefix("player_stats");
        String query = "SELECT * FROM " + tableName + " WHERE uuid = ?";
        return (PlayerStats)this.withConnection(connection -> {
            try (PreparedStatement stmt = connection.prepareStatement(query);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return new PlayerStats(uuid);
                    PlayerStats stats = new PlayerStats(uuid);
                    stats.setTotalDistance(rs.getDouble("total_distance"));
                    stats.setTotalTimeSeconds(rs.getLong("total_time_seconds"));
                    stats.setLongestFlight(rs.getDouble("longest_flight"));
                    stats.setBoostsUsed(rs.getInt("boosts_used"));
                    stats.setSuperBoostsUsed(rs.getInt("super_boosts_used"));
                    stats.setPluginSaves(rs.getInt("plugin_saves"));
                    PlayerStats playerStats = stats;
                    return playerStats;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void resetPlayerStats(UUID uuid) throws SQLException {
        String playerStatsTable = this.applyPrefix("player_stats");
        String flightTimeTable = this.applyPrefix("elytra_flight_time");
        String resetStatsQuery = "UPDATE " + playerStatsTable + " SET total_distance = 0, total_time_seconds = 0, longest_flight = 0, boosts_used = 0, super_boosts_used = 0, plugin_saves = 0 WHERE uuid = ?";
        String resetFlightTimeQuery = "UPDATE " + flightTimeTable + " SET flight_time = 0 WHERE uuid = ?";
        this.withConnection(connection -> {
            PreparedStatement stmt;
            try {
                stmt = connection.prepareStatement(resetStatsQuery);
                try {
                    stmt.setString(1, uuid.toString());
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            try {
                stmt = connection.prepareStatement(resetFlightTimeQuery);
                try {
                    stmt.setString(1, uuid.toString());
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public Map<UUID, Double> getTopStats(String statColumn, int limit) throws SQLException {
        String tableName = this.applyPrefix("player_stats");
        String query = "SELECT uuid, " + statColumn + " FROM " + tableName + " ORDER BY " + statColumn + " DESC LIMIT ?";
        return (Map)this.withConnection(connection -> {
            LinkedHashMap<UUID, Double> linkedHashMap;
            block16: {
                LinkedHashMap<UUID, Double> topStats = new LinkedHashMap<UUID, Double>();
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setInt(1, limit);
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            UUID uuid = UUID.fromString(rs.getString("uuid"));
                            double value = rs.getDouble(statColumn);
                            topStats.put(uuid, value);
                        }
                    }
                    linkedHashMap = topStats;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return linkedHashMap;
        });
    }

    public int getPlayerRank(UUID uuid, String statColumn) throws SQLException {
        String tableName = this.applyPrefix("player_stats");
        String query = "SELECT COUNT(*) FROM " + tableName + " WHERE " + statColumn + " > (SELECT " + statColumn + " FROM " + tableName + " WHERE uuid = ?)";
        return (Integer)this.withConnection(connection -> {
            try (PreparedStatement stmt = connection.prepareStatement(query);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        Integer n = rs.getInt(1) + 1;
                        return n;
                    }
                }
                Integer n = -1;
                return n;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void savePlayerStats(PlayerStats stats) throws SQLException {
        String tableName = this.applyPrefix("player_stats");
        String query = this.storageType == StorageType.MYSQL ? "INSERT INTO " + tableName + " (uuid, total_distance, total_time_seconds, longest_flight, boosts_used, super_boosts_used, plugin_saves) VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE total_distance = ?, total_time_seconds = ?, longest_flight = ?, boosts_used = ?, super_boosts_used = ?, plugin_saves = ?" : "REPLACE INTO " + tableName + " (uuid, total_distance, total_time_seconds, longest_flight, boosts_used, super_boosts_used, plugin_saves) VALUES (?, ?, ?, ?, ?, ?, ?)";
        this.withConnection(connection -> {
            Object var5_6;
            block9: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, stats.getUuid().toString());
                    stmt.setDouble(2, stats.getTotalDistance());
                    stmt.setLong(3, stats.getTotalTimeSeconds());
                    stmt.setDouble(4, stats.getLongestFlight());
                    stmt.setInt(5, stats.getBoostsUsed());
                    stmt.setInt(6, stats.getSuperBoostsUsed());
                    stmt.setInt(7, stats.getPluginSaves());
                    if (this.storageType == StorageType.MYSQL) {
                        stmt.setDouble(8, stats.getTotalDistance());
                        stmt.setLong(9, stats.getTotalTimeSeconds());
                        stmt.setDouble(10, stats.getLongestFlight());
                        stmt.setInt(11, stats.getBoostsUsed());
                        stmt.setInt(12, stats.getSuperBoostsUsed());
                        stmt.setInt(13, stats.getPluginSaves());
                    }
                    stmt.executeUpdate();
                    var5_6 = null;
                    if (stmt == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var5_6;
        });
    }

    public Set<String> getUnlockedAchievementIds(UUID playerUuid) throws SQLException {
        String tableName = this.applyPrefix("player_achievements");
        String query = "SELECT achievement_id FROM " + tableName + " WHERE player_uuid = ?";
        return (Set)this.withConnection(connection -> {
            HashSet<String> hashSet;
            block16: {
                HashSet<String> unlockedIds = new HashSet<String>();
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, playerUuid.toString());
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            unlockedIds.add(rs.getString("achievement_id"));
                        }
                    }
                    hashSet = unlockedIds;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return hashSet;
        });
    }

    public boolean hasAchievement(UUID playerUuid, String achievementId) throws SQLException {
        String tableName = this.applyPrefix("player_achievements");
        String query = "SELECT 1 FROM " + tableName + " WHERE player_uuid = ? AND achievement_id = ?";
        return (Boolean)this.withConnection(connection -> {
            try (PreparedStatement stmt = connection.prepareStatement(query);){
                Boolean bl;
                block14: {
                    stmt.setString(1, playerUuid.toString());
                    stmt.setString(2, achievementId);
                    ResultSet rs = stmt.executeQuery();
                    try {
                        bl = rs.next();
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return bl;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void addAchievement(UUID playerUuid, String achievementId) throws SQLException {
        String tableName = this.applyPrefix("player_achievements");
        String query = "INSERT INTO " + tableName + " (player_uuid, achievement_id) VALUES (?, ?)";
        if (this.hasAchievement(playerUuid, achievementId)) {
            return;
        }
        this.withConnection(connection -> {
            Object var5_6;
            block8: {
                PreparedStatement stmt = connection.prepareStatement(query);
                try {
                    stmt.setString(1, playerUuid.toString());
                    stmt.setString(2, achievementId);
                    stmt.executeUpdate();
                    var5_6 = null;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var5_6;
        });
    }

    private void migrateOldTables() throws SQLException {
        this.migrateIfNeeded("elytra_flight_time", this.applyPrefix("elytra_flight_time"));
        this.migrateIfNeeded("owned_effects", this.applyPrefix("owned_effects"));
        this.migrateIfNeeded("player_stats", this.applyPrefix("player_stats"));
        this.migrateIfNeeded("player_achievements", this.applyPrefix("player_achievements"));
    }

    private void migrateIfNeeded(String oldTable, String newTable) throws SQLException {
        if (this.tableExists(oldTable) && !this.tableExists(newTable)) {
            this.logger.info("Migrating data from old table: " + oldTable + " \u2192 " + newTable);
            this.executeTableQuery(newTable);
            this.withConnection(connection -> {
                Object var4_5;
                block8: {
                    Statement stmt = connection.createStatement();
                    try {
                        stmt.executeUpdate("INSERT INTO " + newTable + " SELECT * FROM " + oldTable + ";");
                        var4_5 = null;
                        if (stmt == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    stmt.close();
                }
                return var4_5;
            });
            this.logger.info("Migration complete for table: " + oldTable);
        }
    }

    private boolean tableExists(String tableName) throws SQLException {
        return (Boolean)this.withConnection(connection -> {
            Boolean bl;
            block8: {
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet rs = meta.getTables(null, null, tableName, null);
                try {
                    bl = rs.next();
                    if (rs == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                rs.close();
            }
            return bl;
        });
    }

    private void initializeTables() throws SQLException {
        this.executeTableQuery("elytra_flight_time");
        this.executeTableQuery("owned_effects");
        this.executeTableQuery("player_stats");
        this.executeTableQuery("player_achievements");
        this.logger.info("Database tables verified and initialized successfully.");
    }

    private void executeTableQuery(String tableName) throws SQLException {
        String query = this.getCreateTableQuery(this.applyPrefix(tableName));
        if (query == null) {
            this.plugin.getLogger().warning("A database setup issue was detected with table: " + tableName);
            return;
        }
        this.withConnection(connection -> {
            Object var3_4;
            block8: {
                Statement stmt = connection.createStatement();
                try {
                    stmt.executeUpdate(query);
                    var3_4 = null;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                stmt.close();
            }
            return var3_4;
        });
    }

    private String getCreateTableQuery(String tableName) {
        boolean isMysql = this.storageType == StorageType.MYSQL;
        String lower = tableName.toLowerCase();
        if (lower.contains("elytra_flight_time")) {
            return isMysql ? "CREATE TABLE IF NOT EXISTS " + tableName + " (uuid VARCHAR(36) PRIMARY KEY, flight_time INT DEFAULT 0);" : "CREATE TABLE IF NOT EXISTS " + tableName + " (uuid TEXT PRIMARY KEY, flight_time INTEGER DEFAULT 0);";
        }
        if (lower.contains("owned_effects")) {
            return isMysql ? "CREATE TABLE IF NOT EXISTS " + tableName + " (id INT AUTO_INCREMENT PRIMARY KEY, player_uuid VARCHAR(36) NOT NULL, effect_key VARCHAR(255) NOT NULL, is_active BOOLEAN NOT NULL DEFAULT FALSE, owned_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP);" : "CREATE TABLE IF NOT EXISTS " + tableName + " (id INTEGER PRIMARY KEY AUTOINCREMENT, player_uuid TEXT NOT NULL, effect_key TEXT NOT NULL, is_active INTEGER NOT NULL DEFAULT 0, owned_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
        }
        if (lower.contains("player_stats")) {
            return isMysql ? "CREATE TABLE IF NOT EXISTS " + tableName + " (uuid VARCHAR(36) PRIMARY KEY, total_distance DOUBLE DEFAULT 0, total_time_seconds BIGINT DEFAULT 0, longest_flight DOUBLE DEFAULT 0, boosts_used INT DEFAULT 0, super_boosts_used INT DEFAULT 0, plugin_saves INT DEFAULT 0);" : "CREATE TABLE IF NOT EXISTS " + tableName + " (uuid TEXT PRIMARY KEY, total_distance REAL DEFAULT 0, total_time_seconds INTEGER DEFAULT 0, longest_flight REAL DEFAULT 0, boosts_used INTEGER DEFAULT 0, super_boosts_used INTEGER DEFAULT 0, plugin_saves INTEGER DEFAULT 0);";
        }
        if (lower.contains("player_achievements")) {
            return isMysql ? "CREATE TABLE IF NOT EXISTS " + tableName + " (player_uuid VARCHAR(36) NOT NULL, achievement_id VARCHAR(255) NOT NULL, unlocked_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (player_uuid, achievement_id));" : "CREATE TABLE IF NOT EXISTS " + tableName + " (player_uuid TEXT NOT NULL, achievement_id TEXT NOT NULL, unlocked_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY (player_uuid, achievement_id));";
        }
        return null;
    }

    private String applyPrefix(String tableName) {
        return this.prefix + tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withConnection(Function<Connection, T> action) throws SQLException {
        Connection conn = null;
        conn = this.dataSource.getConnection();
        Object object = action.apply((Object)conn);
        return (T)object;
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static enum StorageType {
        SQLITE,
        MYSQL;

    }
}

