/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.TpsHandler;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.ElytraEffect;
import org.bruno.elytraEssentials.utils.ServerVersion;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EffectsHandler {
    private final ElytraEssentials plugin;
    private final FoliaHelper foliaHelper;
    private final DatabaseHandler databaseHandler;
    private final MessagesHelper messagesHelper;
    private final ServerVersion serverVersion;
    private final Economy economy;
    private final TpsHandler tpsHandler;
    private final MessagesHandler messagesHandler;
    private final Logger logger;
    private final Map<String, ElytraEffect> effectsRegistry = new HashMap<String, ElytraEffect>();
    private final Map<UUID, String> activePlayerEffects = new HashMap<UUID, String>();

    public EffectsHandler(ElytraEssentials plugin, FileConfiguration fileConfiguration, FoliaHelper foliaHelper, DatabaseHandler databaseHandler, MessagesHelper messagesHelper, ServerVersion serverVersion, Economy economy, TpsHandler tpsHandler, MessagesHandler messagesHandler, Logger logger) {
        this.plugin = plugin;
        this.foliaHelper = foliaHelper;
        this.databaseHandler = databaseHandler;
        this.messagesHelper = messagesHelper;
        this.serverVersion = serverVersion;
        this.economy = economy;
        this.tpsHandler = tpsHandler;
        this.messagesHandler = messagesHandler;
        this.logger = logger;
        this.registerEffects();
        this.loadEffectsConfig(fileConfiguration);
    }

    public boolean handlePurchase(Player player, String effectKey, String effectPermission) {
        try {
            List<String> ownedEffects = this.databaseHandler.getOwnedEffectKeys(player.getUniqueId());
            if (PermissionsHelper.hasAllEffectsPermission(player) || player.hasPermission(effectPermission) || ownedEffects.contains(effectKey)) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getEffectGuiOwned());
                return false;
            }
            ElytraEffect effect = this.effectsRegistry.get(effectKey);
            if (effect == null || this.economy == null) {
                return false;
            }
            if (!this.economy.has((OfflinePlayer)player, effect.getPrice())) {
                player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getNotEnoughMoney());
                return false;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, effect.getPrice());
            this.databaseHandler.addOwnedEffect(player.getUniqueId(), effectKey);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 0.8f);
            String message = this.messagesHandler.getPurchaseSuccessful().replace("{0}", ColorHelper.parse(effect.getName()));
            this.messagesHelper.sendPlayerMessage(player, message);
            return true;
        }
        catch (SQLException e) {
            this.handleSqlException(e, player, "&cAn error occurred while processing your purchase.");
            return false;
        }
    }

    public boolean handleSelection(Player player, String effectKey) {
        try {
            String currentActive = this.getActiveEffect(player.getUniqueId());
            if (effectKey.equals(currentActive)) {
                return false;
            }
            if (currentActive != null) {
                this.databaseHandler.updateOwnedEffect(player.getUniqueId(), currentActive, false);
            }
            this.databaseHandler.updateOwnedEffect(player.getUniqueId(), effectKey, true);
            this.setActiveEffect(player.getUniqueId(), effectKey);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 0.8f);
            String message = this.messagesHandler.getEffectSelected().replace("{0}", ColorHelper.parse(this.effectsRegistry.get(effectKey).getName()));
            this.messagesHelper.sendPlayerMessage(player, message);
            return true;
        }
        catch (SQLException e) {
            this.handleSqlException(e, player, "&cAn error occurred while trying to activate the effect!");
            return false;
        }
    }

    public boolean handleDeselection(Player player, String effectKey) {
        try {
            String activeEffect = this.getActiveEffect(player.getUniqueId());
            if (!effectKey.equals(activeEffect)) {
                return false;
            }
            this.databaseHandler.updateOwnedEffect(player.getUniqueId(), effectKey, false);
            this.setActiveEffect(player.getUniqueId(), null);
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 0.8f);
            String message = this.messagesHandler.getEffectDeselected().replace("{0}", ColorHelper.parse(this.effectsRegistry.get(effectKey).getName()));
            this.messagesHelper.sendPlayerMessage(player, message);
            return true;
        }
        catch (SQLException e) {
            this.handleSqlException(e, player, "&cAn error occurred while updating your effect.");
            return false;
        }
    }

    public ItemStack createShopItem(String effectKey, ElytraEffect effect, Player player) {
        List<String> ownedEffects;
        ItemStack item = new ItemStack(effect.getDisplayMaterial());
        ItemMeta meta = item.getItemMeta();
        try {
            ownedEffects = this.databaseHandler.getOwnedEffectKeys(player.getUniqueId());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a76Price: \u00a7e$" + effect.getPrice());
        lore.add("");
        for (String loreLine : effect.getLore()) {
            lore.add(ColorHelper.parse(loreLine));
        }
        lore.add("");
        if (player.hasPermission(effect.getPermission()) || ownedEffects.contains(effectKey)) {
            lore.add(ColorHelper.parse(this.messagesHandler.getEffectGuiOwned()));
        } else {
            lore.add(ColorHelper.parse(this.messagesHandler.getEffectGuiPurchase()));
        }
        if (meta != null) {
            meta.setDisplayName(ColorHelper.parse(effect.getName()));
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "effect_key"), PersistentDataType.STRING, (Object)effectKey);
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "effect_permission_key"), PersistentDataType.STRING, (Object)effect.getPermission());
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack createOwnedItem(String effectKey, ElytraEffect effect) {
        ItemStack item = new ItemStack(effect.getDisplayMaterial());
        ItemMeta meta = item.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("");
        for (String loreLine : effect.getLore()) {
            lore.add(ColorHelper.parse(loreLine));
        }
        lore.add("");
        if (effect.getIsActive().booleanValue()) {
            lore.add(ColorHelper.parse(this.messagesHandler.getEffectGuiDeselect()));
            if (meta != null) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
        } else {
            lore.add(ColorHelper.parse(this.messagesHandler.getEffectGuiSelect()));
        }
        if (meta != null) {
            meta.setDisplayName(ColorHelper.parse(effect.getName()));
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "effect_key"), PersistentDataType.STRING, (Object)effectKey);
        }
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack createEmptyItemStack() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7c\u00a7lPurchase Effects!");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add("\u00a7fYou don't own any elytra effect");
            lore.add("\u00a7fVisit the shop for more info");
            lore.add("");
            lore.add("\u00a77/ee shop");
            meta.setLore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public void spawnParticleTrail(Player player) {
        String activeEffectKey = this.getActiveEffect(player.getUniqueId());
        if (activeEffectKey == null) {
            return;
        }
        ElytraEffect effect = this.effectsRegistry.get(activeEffectKey);
        if (effect == null || this.tpsHandler.isLagProtectionActive()) {
            return;
        }
        Vector direction = player.getLocation().getDirection().normalize();
        Vector offset = direction.multiply(-1);
        Vector particleLocation = player.getLocation().toVector().add(offset);
        player.getWorld().spawnParticle(effect.getParticle(), particleLocation.toLocation(player.getWorld()), 10, 0.1, 0.1, 0.1, 0.05);
    }

    public String getActiveEffect(UUID playerUuid) {
        return this.activePlayerEffects.get(playerUuid);
    }

    public void setActiveEffect(UUID playerUuid, String effectKey) {
        if (effectKey == null) {
            this.activePlayerEffects.remove(playerUuid);
        } else {
            this.activePlayerEffects.put(playerUuid, effectKey);
        }
    }

    public void loadPlayerActiveEffect(Player player) {
        this.foliaHelper.runAsyncTask(() -> {
            try {
                String activeEffect = this.databaseHandler.getPlayerActiveEffect(player.getUniqueId());
                if (activeEffect != null) {
                    this.setActiveEffect(player.getUniqueId(), activeEffect);
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Could not load active effect for " + player.getName(), e);
            }
        });
    }

    public void clearPlayerActiveEffect(Player player) {
        this.activePlayerEffects.remove(player.getUniqueId());
    }

    private void loadEffectsConfig(FileConfiguration fileConfiguration) {
        for (String key : fileConfiguration.getConfigurationSection("shop").getKeys(false)) {
            ElytraEffect effect = this.effectsRegistry.get(key);
            if (effect != null) {
                effect.setPrice(fileConfiguration.getDouble("shop." + key + ".price"));
                effect.setPermission(fileConfiguration.getString("shop." + key + ".permission"));
                String effectName = fileConfiguration.getString("shop." + key + ".name");
                if (effectName != null) {
                    effect.setName(ColorHelper.parse(effectName));
                }
                List loreLines = fileConfiguration.getStringList("shop." + key + ".lore");
                ArrayList<String> translatedLore = new ArrayList<String>();
                for (String line : loreLines) {
                    translatedLore.add(ColorHelper.parse(line));
                }
                effect.setLore(translatedLore);
            }
            this.effectsRegistry.put(key, effect);
        }
    }

    private void registerEffects() {
        this.effectsRegistry.put("FIRE_TRAIL", new ElytraEffect("FIRE_TRAIL", "Fire Trail", Material.CAMPFIRE, Particle.FLAME, List.of("\u00a77Leave a fiery trail!"), 1000.0, "elytraessentials.effect.fire"));
        this.effectsRegistry.put("ICE_SHARDS", new ElytraEffect("ICE_SHARDS", "Ice Shards", Material.ICE, Particle.SNOWFLAKE, List.of("\u00a77Shards of ice behind you!"), 1500.0, "elytraessentials.effect.ice"));
        this.effectsRegistry.put("INKY_VOID", new ElytraEffect("INKY_VOID", "Inky Void", Material.INK_SAC, Particle.SQUID_INK, List.of("\u00a77Soar with a trail of darkness."), 1750.0, "elytraessentials.effect.void"));
        this.effectsRegistry.put("HEART_TRAIL", new ElytraEffect("HEART_TRAIL", "Heart Trail", Material.POPPY, Particle.HEART, List.of("\u00a77Spread love wherever you fly!"), 1250.0, "elytraessentials.effect.heart"));
        this.effectsRegistry.put("SOUL_FIRE", new ElytraEffect("SOUL_FIRE", "Soul Fire", Material.SOUL_LANTERN, Particle.SOUL_FIRE_FLAME, List.of("\u00a77A trail of eerie, blue soul fire."), 1800.0, "elytraessentials.effect.soulfire"));
        this.effectsRegistry.put("MUSICAL_FLIGHT", new ElytraEffect("MUSICAL_FLIGHT", "Musical Flight", Material.JUKEBOX, Particle.NOTE, List.of("\u00a77Leave a trail of musical notes as you fly."), 1300.0, "elytraessentials.effect.note"));
        this.effectsRegistry.put("CLOUD_SURFER", new ElytraEffect("CLOUD_SURFER", "Cloud Surfer", Material.WHITE_WOOL, Particle.CLOUD, List.of("\u00a77Fly on your own personal cloud."), 800.0, "elytraessentials.effect.cloud"));
        this.effectsRegistry.put("CRITICAL_AURA", new ElytraEffect("CRITICAL_AURA", "Critical Aura", Material.DIAMOND_SWORD, Particle.CRIT, List.of("\u00a77Fly with the power of a critical hit!"), 2100.0, "elytraessentials.effect.crit"));
        this.effectsRegistry.put("ENDERS_WAKE", new ElytraEffect("ENDERS_WAKE", "Ender's Wake", Material.ENDER_EYE, Particle.PORTAL, List.of("\u00a77A swirling vortex of the void follows you."), 2800.0, "elytraessentials.effect.portal"));
        this.effectsRegistry.put("SPORE_BLOOM", new ElytraEffect("SPORE_BLOOM", "Spore Bloom", Material.SPORE_BLOSSOM, Particle.SPORE_BLOSSOM_AIR, List.of("\u00a77A trail of beautiful, floating spores."), 2800.0, "elytraessentials.effect.spore"));
        this.effectsRegistry.put("BUBBLE_STREAM", new ElytraEffect("BUBBLE_STREAM", "Bubble Stream", Material.GLASS_BOTTLE, Particle.BUBBLE_POP, List.of("\u00a77A stream of popping bubbles."), 950.0, "elytraessentials.effect.bubble"));
        this.effectsRegistry.put("DRAGON_BREATH", new ElytraEffect("DRAGON_BREATH", "Dragon Breath", Material.DRAGON_EGG, Particle.DRAGON_BREATH, List.of("\u00a77The spark of dragon breath."), 2400.0, "elytraessentials.effect.dragon"));
        this.effectsRegistry.put("DOLPHINS_GRACE", new ElytraEffect("DOLPHINS_GRACE", "Dolphin's Grace", Material.HEART_OF_THE_SEA, Particle.DOLPHIN, List.of("\u00a77Swim through the air with a dolphin's help."), 3200.0, "elytraessentials.effect.dolphin"));
        this.effectsRegistry.put("DAMAGE_FLASH", new ElytraEffect("DAMAGE_FLASH", "Damage Flash", Material.REDSTONE, Particle.DAMAGE_INDICATOR, List.of("\u00a77A flash of red damage particles."), 1650.0, "elytraessentials.effect.damage"));
        this.effectsRegistry.put("WAXED_WINGS", new ElytraEffect("WAXED_WINGS", "Waxed Wings", Material.HONEYCOMB, Particle.WAX_ON, List.of("\u00a77A trail of waxy particles."), 1400.0, "elytraessentials.effect.wax"));
        this.registerVersionDependentEffect("SLIME_TRAIL", "\u00a72Slime Trail", Material.SLIME_BALL, Map.of(ServerVersion.V_1_18, "SLIME", ServerVersion.V_1_19, "SLIME", ServerVersion.V_1_20, "SLIME", ServerVersion.V_1_21, "ITEM_SLIME"), List.of("\u00a77Leave a gooey, green trail behind."), 900, "elytraessentials.effect.slime");
        this.registerVersionDependentEffect("WITCHES_BREW", "\u00a75Witches Brew", Material.BREWING_STAND, Map.of(ServerVersion.V_1_18, "SPELL_WITCH", ServerVersion.V_1_19, "SPELL_WITCH", ServerVersion.V_1_20, "SPELL_WITCH", ServerVersion.V_1_21, "WITCH"), List.of("\u00a77A swirling, magical concoction follows you."), 2200, "elytraessentials.effect.witch");
        this.registerVersionDependentEffect("EXPLOSIVE_TRAIL", "Explosive Trail", Material.TNT, Map.of(ServerVersion.V_1_18, "EXPLOSION_NORMAL", ServerVersion.V_1_19, "EXPLOSION_NORMAL", ServerVersion.V_1_20, "EXPLOSION_NORMAL", ServerVersion.V_1_21, "EXPLOSION"), List.of("\u00a77A trail of small explosions."), 1100, "elytraessentials.effect.explosion");
        this.registerVersionDependentEffect("SMOKE_SCREEN", "Smoke Screen", Material.BLACK_DYE, Map.of(ServerVersion.V_1_18, "SMOKE_LARGE", ServerVersion.V_1_19, "SMOKE_LARGE", ServerVersion.V_1_20, "SMOKE_LARGE", ServerVersion.V_1_21, "LARGE_SMOKE"), List.of("\u00a77Create a screen of thick smoke."), 1100, "elytraessentials.effect.smoke");
        this.registerVersionDependentEffect("TOTEM_BLESSING", "Totem's Blessing", Material.TOTEM_OF_UNDYING, Map.of(ServerVersion.V_1_18, "TOTEM", ServerVersion.V_1_19, "TOTEM", ServerVersion.V_1_20, "TOTEM", ServerVersion.V_1_21, "TOTEM_OF_UNDYING"), List.of("\u00a77Fly with the blessing of immortality!"), 3500, "elytraessentials.effect.totem");
        this.registerVersionDependentEffect("LAVA_DRIP", "Lava Trail", Material.LAVA_BUCKET, Map.of(ServerVersion.V_1_18, "DRIP_LAVA", ServerVersion.V_1_19, "DRIP_LAVA", ServerVersion.V_1_20, "DRIP_LAVA", ServerVersion.V_1_21, "DRIPPING_LAVA"), List.of("\u00a77Drips of hot magma follow you."), 1900, "elytraessentials.effect.lavadrip");
        this.registerVersionDependentEffect("WATER_TRAIL", "Water Trail", Material.WATER_BUCKET, Map.of(ServerVersion.V_1_18, "DRIP_WATER", ServerVersion.V_1_19, "DRIP_WATER", ServerVersion.V_1_20, "DRIP_WATER", ServerVersion.V_1_21, "DRIPPING_WATER"), List.of("\u00a77Trails of water follow you!"), 2000, "elytraessentials.effect.water");
        this.registerVersionDependentEffect("ARCANE_TRAIL", "Arcane Trail", Material.ENCHANTING_TABLE, Map.of(ServerVersion.V_1_18, "ENCHANTMENT_TABLE", ServerVersion.V_1_19, "ENCHANTMENT_TABLE", ServerVersion.V_1_20, "ENCHANTMENT_TABLE", ServerVersion.V_1_21, "ENCHANTMENT_TABLE"), List.of("\u00a77Leave a trail of mystical runes."), 2500, "elytraessentials.effect.arcane");
        this.registerVersionDependentEffect("EMERALD_SPARK", "Emerald Spark", Material.EMERALD, Map.of(ServerVersion.V_1_18, "VILLAGER_HAPPY", ServerVersion.V_1_19, "VILLAGER_HAPPY", ServerVersion.V_1_20, "VILLAGER_HAPPY", ServerVersion.V_1_21, "HAPPY_VILLAGER"), List.of("\u00a77Show off with a glittering green trail."), 3000, "elytraessentials.effect.emerald");
        if (ServerVersion.getCurrent().ordinal() > ServerVersion.V_1_19.ordinal()) {
            this.effectsRegistry.put("CHERRY_BLOSSOM", new ElytraEffect("CHERRY_BLOSSOM", "Waxed Cherry Blossom", Material.CHERRY_LEAVES, Particle.CHERRY_LEAVES, List.of("\u00a77A beautiful trail of cherry petals."), 1550.0, "elytraessentials.effect.cherry"));
        }
    }

    private void registerVersionDependentEffect(String key, String name, Material material, Map<ServerVersion, String> particleNames, List<String> lore, int price, String permission) {
        String particleNameToUse = particleNames.getOrDefault((Object)this.serverVersion, particleNames.get((Object)ServerVersion.V_1_21));
        if (particleNameToUse == null) {
            this.logger.warning("Could not register effect '" + name + "'. No valid particle name was defined for this version.");
            return;
        }
        try {
            Particle particle = Particle.valueOf((String)particleNameToUse.toUpperCase());
            this.effectsRegistry.put(key, new ElytraEffect(key, name, material, particle, lore, price, permission));
        }
        catch (IllegalArgumentException e) {
            this.logger.warning("Could not register effect '" + name + "'. Particle '" + particleNameToUse + "' is not valid on this server version.");
        }
    }

    public Map<String, ElytraEffect> getEffectsRegistry() {
        return this.effectsRegistry;
    }

    private void handleSqlException(SQLException e, Player player, String message) {
        player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 0.8f, 0.8f);
        this.messagesHelper.sendPlayerMessage(player, message);
        this.logger.log(Level.SEVERE, "A database error occurred for player " + player.getName(), e);
    }
}

