/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.HashMap;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ElytraEquipHandler {
    private final ConfigHandler configHandler;
    private final MessagesHelper messagesHelper;
    private final FoliaHelper foliaHelper;
    private final MessagesHandler messagesHandler;

    public ElytraEquipHandler(ConfigHandler configHandler, MessagesHelper messagesHelper, FoliaHelper foliaHelper, MessagesHandler messagesHandler) {
        this.configHandler = configHandler;
        this.messagesHelper = messagesHelper;
        this.foliaHelper = foliaHelper;
        this.messagesHandler = messagesHandler;
    }

    public void scheduleEquipCheck(Player player) {
        this.foliaHelper.runTask((Entity)player, () -> this.checkAndHandleElytraEquip(player));
    }

    private void checkAndHandleElytraEquip(Player player) {
        if (!this.configHandler.getIsElytraEquipDisabled()) {
            return;
        }
        if (PermissionsHelper.playerBypassElytraEquip(player)) {
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (chestplate != null && chestplate.getType() == Material.ELYTRA) {
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getElytraEquipDisabled());
            player.getInventory().setChestplate(null);
            HashMap leftovers = player.getInventory().addItem(new ItemStack[]{chestplate});
            if (!leftovers.isEmpty()) {
                player.getWorld().dropItemNaturally(player.getLocation(), chestplate);
                this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getElytraEquipDropped());
            }
        }
    }
}

