/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.handlers.BoostHandler;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.EffectsHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.handlers.UpgradeHandler;
import org.bruno.elytraEssentials.helpers.ArmoredElytraHelper;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.helpers.TimeHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bruno.elytraEssentials.utils.PlayerStats;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class FlightHandler {
    private static final int TICKS_IN_ONE_SECOND = 20;
    private static final double METERS_PER_SECOND_TO_KMH = 3.6;
    private static final double MAX_FLIGHT_SPEED = 200.0;
    private static final long DEPLOY_COOLDOWN_MS = 5000L;
    private static final int DEPLOY_MIN_FALL_DISTANCE = 5;
    private final Logger logger;
    private final ConfigHandler configHandler;
    private final EffectsHandler effectsHandler;
    private final BoostHandler boostHandler;
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private final DatabaseHandler databaseHandler;
    private final StatsHandler statsHandler;
    private final MessagesHandler messagesHandler;
    private final UpgradeHandler upgradeHandler;
    private final ArmoredElytraHelper armoredElytraHelper;
    private final Map<UUID, Integer> flightTimeData = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, BossBar> flightBossBars = new ConcurrentHashMap<UUID, BossBar>();
    private final Map<UUID, Double> currentFlightDistances = new ConcurrentHashMap<UUID, Double>();
    private final Set<UUID> noFallDamagePlayers = ConcurrentHashMap.newKeySet();
    private final Map<UUID, Integer> initialFlightTime = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> deployCooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, CancellableTask> activeFlightTasks = new HashMap<UUID, CancellableTask>();
    private CancellableTask globalFlightTask;
    private final Random random = new Random();

    public FlightHandler(Logger logger, ConfigHandler configHandler, EffectsHandler effectsHandler, BoostHandler boostHandler, FoliaHelper foliaHelper, MessagesHelper messagesHelper, DatabaseHandler databaseHandler, StatsHandler statsHandler, MessagesHandler messagesHandler, UpgradeHandler upgradeHandler, ArmoredElytraHelper armoredElytraHelper) {
        this.logger = logger;
        this.configHandler = configHandler;
        this.effectsHandler = effectsHandler;
        this.boostHandler = boostHandler;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.databaseHandler = databaseHandler;
        this.statsHandler = statsHandler;
        this.messagesHandler = messagesHandler;
        this.upgradeHandler = upgradeHandler;
        this.armoredElytraHelper = armoredElytraHelper;
    }

    public void start() {
        if (!this.configHandler.getIsTimeLimitEnabled()) {
            return;
        }
        if (!this.foliaHelper.isFolia()) {
            if (this.globalFlightTask != null) {
                return;
            }
            this.globalFlightTask = this.foliaHelper.runTaskTimerGlobal(this::handleGlobalFlightTimeCountdown, 20L, 20L);
        }
    }

    public void shutdown() {
        if (this.foliaHelper.isFolia()) {
            this.activeFlightTasks.values().forEach(CancellableTask::cancel);
            this.activeFlightTasks.clear();
        } else if (this.globalFlightTask != null) {
            this.globalFlightTask.cancel();
        }
        this.flightBossBars.values().forEach(bossBar -> bossBar.setVisible(false));
        this.flightBossBars.clear();
        this.saveAllFlightTimes();
    }

    public void loadPlayerData(Player player) {
        if (!this.configHandler.getIsTimeLimitEnabled()) {
            return;
        }
        try {
            int storedTime = this.databaseHandler.getPlayerFlightTime(player.getUniqueId());
            this.flightTimeData.put(player.getUniqueId(), storedTime);
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, "Failed to load flight time for " + player.getName(), e);
        }
    }

    public void unloadPlayerData(Player player) {
        this.savePlayerFlightTime(player.getUniqueId());
        this.flightTimeData.remove(player.getUniqueId());
        this.flightBossBars.remove(player.getUniqueId());
        this.currentFlightDistances.remove(player.getUniqueId());
        this.noFallDamagePlayers.remove(player.getUniqueId());
        this.initialFlightTime.remove(player.getUniqueId());
        this.deployCooldowns.remove(player.getUniqueId());
        if (this.foliaHelper.isFolia()) {
            this.stopTrackingPlayer(player);
        }
    }

    public void saveAllFlightTimes() {
        for (UUID playerId : new HashSet<UUID>(this.flightTimeData.keySet())) {
            this.savePlayerFlightTime(playerId);
        }
    }

    public boolean isProtectedFromFallDamage(UUID playerId) {
        return this.noFallDamagePlayers.contains(playerId);
    }

    public void removeFallProtection(UUID playerId) {
        this.noFallDamagePlayers.remove(playerId);
    }

    public boolean isKineticProtectionEnabled() {
        return this.configHandler.getIsKineticEnergyProtectionEnabled();
    }

    public int getCurrentFlightTime(UUID playerId) {
        return this.flightTimeData.getOrDefault(playerId, 0);
    }

    public boolean onGlideStartAttempt(Player player) {
        int currentFlightTime;
        if (this.configHandler.getIsTimeLimitEnabled() && !PermissionsHelper.playerBypassTimeLimit(player) && (currentFlightTime = this.flightTimeData.getOrDefault(player.getUniqueId(), 0).intValue()) <= 0) {
            this.messagesHelper.sendActionBarMessage(player, this.messagesHandler.getElytraFlightTimeExpired());
            return true;
        }
        if (this.configHandler.getIsGlobalFlightDisabled() || this.configHandler.getDisabledWorlds() != null && this.configHandler.getDisabledWorlds().contains(player.getWorld().getName())) {
            String msg = this.configHandler.getIsGlobalFlightDisabled() ? this.messagesHandler.getElytraUsageDisabledMessage() : this.messagesHandler.getElytraUsageWorldDisabledMessage();
            this.messagesHelper.sendPlayerMessage(player, msg);
            return true;
        }
        this.currentFlightDistances.put(player.getUniqueId(), 0.0);
        if (this.configHandler.getIsTimeLimitEnabled()) {
            this.createFlightTimeBossBar(player);
            if (this.foliaHelper.isFolia()) {
                this.startTrackingPlayer(player);
            }
        }
        return false;
    }

    public void handleGlideEnd(Player player) {
        PlayerStats stats = this.statsHandler.getStats(player);
        double flightDistance = this.currentFlightDistances.getOrDefault(player.getUniqueId(), 0.0);
        if (flightDistance > 0.0 && flightDistance > stats.getLongestFlight()) {
            stats.setLongestFlight(flightDistance);
            String message = this.messagesHandler.getNewPRLongestFlightMessage().replace("{0}", String.format("%.0f", flightDistance));
            this.messagesHelper.sendPlayerMessage(player, message);
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.2f);
        }
        this.currentFlightDistances.remove(player.getUniqueId());
        this.removeBossBar(player);
        if (this.foliaHelper.isFolia()) {
            this.stopTrackingPlayer(player);
        }
    }

    public void handlePlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        this.handleEmergencyDeploy(player);
        if (!player.isGliding()) {
            if (this.flightBossBars.containsKey(player.getUniqueId())) {
                this.removeBossBar(player);
            }
            return;
        }
        this.handleLiquidGlide(player);
        this.handleSpeedometer(player);
        this.handleDurabilityProtection(player);
        this.handleDistanceTracking(player, event);
        this.effectsHandler.spawnParticleTrail(player);
    }

    public void addFlightTime(UUID playerId, int secondsToAdd, CommandSender feedbackRecipient) {
        try {
            Player target = Bukkit.getPlayer((UUID)playerId);
            int currentFlightTime = target != null && target.isOnline() ? this.flightTimeData.getOrDefault(playerId, 0).intValue() : this.databaseHandler.getPlayerFlightTime(playerId);
            int maxTimeLimit = this.configHandler.getMaxTimeLimit();
            int amountToAdd = secondsToAdd;
            int sumFlightTime = currentFlightTime + secondsToAdd;
            if (maxTimeLimit > 0 && sumFlightTime > maxTimeLimit) {
                amountToAdd = maxTimeLimit - currentFlightTime;
                sumFlightTime = maxTimeLimit;
            }
            int finalAmount = amountToAdd;
            int newFlightTime = sumFlightTime;
            if (finalAmount <= 0) {
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(feedbackRecipient, "&cPlayer already has the maximum flight time."));
                return;
            }
            this.databaseHandler.setPlayerFlightTime(playerId, newFlightTime);
            if (target != null && target.isOnline()) {
                this.foliaHelper.runTaskOnMainThread(() -> {
                    this.flightTimeData.put(playerId, newFlightTime);
                    this.initialFlightTime.computeIfPresent(playerId, (key, currentInitial) -> currentInitial + finalAmount);
                    String message = this.messagesHandler.getElytraFlightTimeAdded().replace("{0}", TimeHelper.formatFlightTime(finalAmount));
                    this.messagesHelper.sendPlayerMessage(target, message);
                });
            }
        }
        catch (SQLException e) {
            this.handleSqlException(feedbackRecipient, "add flight time", playerId, e);
        }
    }

    public void removeFlightTime(UUID playerId, int secondsToRemove, CommandSender sender) {
        try {
            int currentFlightTime = this.databaseHandler.getPlayerFlightTime(playerId);
            int newFlightTime = Math.max(0, currentFlightTime - secondsToRemove);
            int actualAmountRemoved = currentFlightTime - newFlightTime;
            this.databaseHandler.setPlayerFlightTime(playerId, newFlightTime);
            Player target = Bukkit.getPlayer((UUID)playerId);
            if (target != null && target.isOnline()) {
                this.foliaHelper.runTaskOnMainThread(() -> {
                    this.flightTimeData.put(playerId, newFlightTime);
                    String message = this.messagesHandler.getElytraFlightTimeRemoved().replace("{0}", TimeHelper.formatFlightTime(actualAmountRemoved));
                    this.messagesHelper.sendPlayerMessage(target, message);
                });
            }
            if (sender != null) {
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&aRemoved " + TimeHelper.formatFlightTime(actualAmountRemoved) + " of flight time from " + Bukkit.getOfflinePlayer((UUID)playerId).getName() + "."));
            }
        }
        catch (SQLException e) {
            this.handleSqlException(sender, "remove flight time", playerId, e);
        }
    }

    public void setFlightTime(UUID playerId, int secondsToSet, CommandSender sender) {
        try {
            int maxTimeLimit = this.configHandler.getMaxTimeLimit();
            int finalAmount = maxTimeLimit > 0 ? Math.min(secondsToSet, maxTimeLimit) : secondsToSet;
            this.databaseHandler.setPlayerFlightTime(playerId, finalAmount);
            Player target = Bukkit.getPlayer((UUID)playerId);
            if (target != null && target.isOnline()) {
                this.foliaHelper.runTaskOnMainThread(() -> {
                    this.flightTimeData.put(playerId, finalAmount);
                    String message = this.messagesHandler.getElytraFlightTimeSet().replace("{0}", TimeHelper.formatFlightTime(finalAmount));
                    this.messagesHelper.sendPlayerMessage(target, message);
                });
            }
            this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&aSet " + Bukkit.getOfflinePlayer((UUID)playerId).getName() + "'s flight time to " + TimeHelper.formatFlightTime(finalAmount)));
        }
        catch (SQLException e) {
            this.handleSqlException(sender, "set flight time", playerId, e);
        }
    }

    public void handleVanillaMechanics(PlayerInteractEvent event) {
        ItemStack chestplate;
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = event.getItem();
        if (itemInHand == null) {
            return;
        }
        if (this.configHandler.getIsFireworkBoostingDisabled() && player.isGliding() && itemInHand.getType() == Material.FIREWORK_ROCKET) {
            event.setCancelled(true);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getFireworkBoostDisabled());
        }
        if (this.configHandler.getIsRiptideLaunchDisabled() && itemInHand.getType() == Material.TRIDENT && itemInHand.getEnchantmentLevel(Enchantment.RIPTIDE) > 0 && (chestplate = player.getInventory().getChestplate()) != null && chestplate.getType() == Material.ELYTRA && player.isInWaterOrRain()) {
            event.setCancelled(true);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getRiptideLaunchDisabled());
        }
    }

    public void protectPlayerFromFall(Player player) {
        this.noFallDamagePlayers.add(player.getUniqueId());
        this.foliaHelper.runTaskLater((Entity)player, () -> this.noFallDamagePlayers.remove(player.getUniqueId()), 60L);
    }

    public void clearFlightTime(UUID playerId, CommandSender sender) {
        try {
            Player onlineTarget;
            this.databaseHandler.setPlayerFlightTime(playerId, 0);
            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)playerId);
            if (target.isOnline() && (onlineTarget = target.getPlayer()) != null) {
                this.foliaHelper.runTaskOnMainThread(() -> {
                    this.flightTimeData.put(playerId, 0);
                    this.initialFlightTime.put(playerId, 0);
                    this.messagesHelper.sendPlayerMessage(onlineTarget, this.messagesHandler.getElytraFlightTimeCleared());
                });
            }
            this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&aCleared all flight time for " + target.getName() + "."));
        }
        catch (SQLException e) {
            this.handleSqlException(sender, "clear flight time", playerId, e);
        }
    }

    private void handleSqlException(CommandSender sender, String action, UUID targetId, SQLException e) {
        this.logger.log(Level.SEVERE, "Failed to " + action + " for " + String.valueOf(targetId), e);
        this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cA database error occurred. Please check the console."));
    }

    private void handleGlobalFlightTimeCountdown() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isGliding() || PermissionsHelper.playerBypassTimeLimit(player)) continue;
            if (!this.flightBossBars.containsKey(player.getUniqueId())) {
                this.createFlightTimeBossBar(player);
            }
            this.updatePlayerFlight(player);
        }
    }

    private void updatePlayerFlight(Player player) {
        double efficiencyChance;
        if (!player.isOnline()) {
            if (this.foliaHelper.isFolia()) {
                this.stopTrackingPlayer(player);
            }
            this.removeBossBar(player);
            return;
        }
        ItemStack chestplate = player.getInventory().getChestplate();
        if (this.armoredElytraHelper.isArmoredElytra(chestplate) && (efficiencyChance = this.upgradeHandler.getFlightEfficiencyChance(chestplate)) > 0.0 && this.random.nextDouble() * 100.0 < efficiencyChance) {
            this.updateBossBar(player, this.flightTimeData.getOrDefault(player.getUniqueId(), 0));
            return;
        }
        int currentFlightTime = this.flightTimeData.getOrDefault(player.getUniqueId(), 0);
        if (currentFlightTime <= 0) {
            player.setGliding(false);
            this.noFallDamagePlayers.add(player.getUniqueId());
            this.foliaHelper.runTaskLater((Entity)player, () -> this.noFallDamagePlayers.remove(player.getUniqueId()), 40L);
            this.messagesHelper.sendActionBarMessage(player, this.messagesHandler.getElytraFlightTimeExpired());
            if (!this.foliaHelper.isFolia()) {
                this.removeBossBar(player);
            }
            return;
        }
        this.flightTimeData.put(player.getUniqueId(), currentFlightTime - 1);
        this.updateBossBar(player, currentFlightTime);
    }

    private void startTrackingPlayer(Player player) {
        if (this.activeFlightTasks.containsKey(player.getUniqueId()) || PermissionsHelper.playerBypassTimeLimit(player)) {
            return;
        }
        CancellableTask task = this.foliaHelper.runTaskTimerForEntity((Entity)player, () -> this.updatePlayerFlight(player), 0L, 20L);
        this.activeFlightTasks.put(player.getUniqueId(), task);
    }

    private void stopTrackingPlayer(Player player) {
        CancellableTask task = this.activeFlightTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    private void handleSpeedometer(Player player) {
        double realSpeed;
        Vector velocity = player.getVelocity();
        double finalSpeed = realSpeed = velocity.length() * 20.0 * 3.6;
        double worldMaxSpeed = this.configHandler.getPerWorldSpeedLimits().getOrDefault(player.getWorld().getName(), this.configHandler.getDefaultSpeedLimit());
        ItemStack chestplate = player.getInventory().getChestplate();
        if (this.armoredElytraHelper.isArmoredElytra(chestplate)) {
            double bonusSpeed = this.upgradeHandler.getBonusSpeed(chestplate);
            worldMaxSpeed += bonusSpeed;
        }
        if (!PermissionsHelper.playerBypassSpeedLimit(player) && this.configHandler.getIsSpeedLimitEnabled() && realSpeed > worldMaxSpeed) {
            finalSpeed = worldMaxSpeed;
            player.setVelocity(velocity.normalize().multiply(worldMaxSpeed / 3.6 / 20.0));
        } else if (realSpeed > 200.0) {
            finalSpeed = 200.0;
            player.setVelocity(velocity.normalize().multiply(2.7777777777777777));
        }
        String format = this.boostHandler.isSuperBoostActive(player.getUniqueId()) ? this.messagesHandler.getSpeedoMeterSuperBoost() : (this.boostHandler.isBoostActive(player.getUniqueId()) ? this.messagesHandler.getSpeedoMeterBoost() : this.messagesHandler.getSpeedoMeterNormal());
        String color = this.calculateSpeedColor(finalSpeed);
        String message = format.replace("{0}", color).replace("{1}", String.format("%.1f", finalSpeed));
        this.messagesHelper.sendActionBarMessage(player, message);
    }

    private void handleDurabilityProtection(Player player) {
        Damageable damageable;
        ItemMeta itemMeta;
        if (!this.configHandler.getIsElytraBreakProtectionEnabled()) {
            return;
        }
        ItemStack elytra = player.getInventory().getChestplate();
        if (elytra != null && elytra.getType() == Material.ELYTRA && (itemMeta = elytra.getItemMeta()) instanceof Damageable && (damageable = (Damageable)itemMeta).getDamage() >= elytra.getType().getMaxDurability() - 1 && this.noFallDamagePlayers.add(player.getUniqueId())) {
            player.playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 0.8f, 0.8f);
            this.messagesHelper.sendActionBarMessage(player, this.messagesHandler.getFallProtectionEnabled());
        }
    }

    private void handleDistanceTracking(Player player, PlayerMoveEvent event) {
        if (event.getFrom().distanceSquared(event.getTo()) == 0.0) {
            return;
        }
        PlayerStats stats = this.statsHandler.getStats(player);
        double distanceMoved = event.getFrom().distance(event.getTo());
        stats.addDistance(distanceMoved);
        this.currentFlightDistances.compute(player.getUniqueId(), (uuid, dist) -> (dist == null ? 0.0 : dist) + distanceMoved);
    }

    private void handleEmergencyDeploy(Player player) {
        if (!this.configHandler.getIsEmergencyDeployEnabled() || player.isInsideVehicle() || player.getVelocity().getY() >= 0.0 || player.isGliding()) {
            return;
        }
        if (this.isOnEmergencyDeployCooldown(player.getUniqueId()) || player.getFallDistance() < 5.0f || !PermissionsHelper.hasAutoDeployPermission(player)) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        if (inventory.getChestplate() != null) {
            return;
        }
        for (int i = 0; i < 36; ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() != Material.ELYTRA) continue;
            inventory.setChestplate(item.clone());
            item.setAmount(item.getAmount() - 1);
            player.setGliding(true);
            player.setFallDistance(0.0f);
            Vector launchDirection = player.getLocation().getDirection().setY(0).normalize();
            Vector launchVelocity = launchDirection.multiply(0.6).setY(0.5);
            player.setVelocity(launchVelocity);
            this.deployCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + 5000L);
            player.playSound(player.getLocation(), Sound.ITEM_TOTEM_USE, 0.8f, 0.8f);
            this.messagesHelper.sendPlayerMessage(player, this.messagesHandler.getEmergencyDeploySuccess());
            break;
        }
    }

    private boolean isOnEmergencyDeployCooldown(UUID playerId) {
        if (!this.deployCooldowns.containsKey(playerId)) {
            return false;
        }
        if (System.currentTimeMillis() > this.deployCooldowns.get(playerId)) {
            this.deployCooldowns.remove(playerId);
            return false;
        }
        return true;
    }

    private String calculateSpeedColor(double speed) {
        if (speed > 180.0) {
            return "\u00a74";
        }
        if (speed > 125.0) {
            return "\u00a7c";
        }
        if (speed > 50.0) {
            return "\u00a76";
        }
        return "\u00a7a";
    }

    private void savePlayerFlightTime(UUID playerId) {
        if (!this.configHandler.getIsTimeLimitEnabled()) {
            return;
        }
        Integer time = this.flightTimeData.get(playerId);
        if (time != null) {
            try {
                this.databaseHandler.setPlayerFlightTime(playerId, time);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to save flight time for " + String.valueOf(playerId), e);
            }
        }
    }

    private void createFlightTimeBossBar(Player player) {
        if (this.flightBossBars.containsKey(player.getUniqueId())) {
            return;
        }
        if (PermissionsHelper.playerBypassTimeLimit(player)) {
            String message = this.messagesHandler.getElytraFlightTimeBypass();
            BossBar bossBar = Bukkit.createBossBar((String)ColorHelper.parse(message), (BarColor)BarColor.YELLOW, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bossBar.addPlayer(player);
            this.flightBossBars.put(player.getUniqueId(), bossBar);
        } else {
            int flightTime = this.flightTimeData.getOrDefault(player.getUniqueId(), 0);
            if (flightTime > 0) {
                String message = this.messagesHandler.getElytraTimeLimitMessage().replace("{0}", TimeHelper.formatFlightTime(flightTime));
                BossBar bossBar = Bukkit.createBossBar((String)ColorHelper.parse(message), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                bossBar.addPlayer(player);
                this.flightBossBars.put(player.getUniqueId(), bossBar);
                this.initialFlightTime.put(player.getUniqueId(), flightTime);
            }
        }
    }

    private void updateBossBar(Player player, int currentFlightTime) {
        BossBar bossBar = this.flightBossBars.get(player.getUniqueId());
        if (bossBar == null) {
            return;
        }
        int initialTime = this.initialFlightTime.getOrDefault(player.getUniqueId(), 1);
        double progress = Math.max(0.0, (double)currentFlightTime / (double)initialTime);
        bossBar.setProgress(progress);
        String title = this.messagesHandler.getElytraTimeLimitMessage().replace("{0}", TimeHelper.formatFlightTime(currentFlightTime));
        bossBar.setTitle(ColorHelper.parse(title));
        if (progress > 0.5) {
            bossBar.setColor(BarColor.GREEN);
        } else if (progress > 0.2) {
            bossBar.setColor(BarColor.YELLOW);
        } else {
            bossBar.setColor(BarColor.RED);
        }
    }

    private void removeBossBar(Player player) {
        BossBar bossBar = this.flightBossBars.remove(player.getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    private void handleLiquidGlide(Player player) {
        if (!this.configHandler.getIsLiquidGlideEnabled() && player.getLocation().getBlock().isLiquid()) {
            player.setGliding(false);
        }
    }
}

