/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class JumpAnimationHandler {
    private final FoliaHelper foliaHelper;
    private final Logger logger;
    private static int nextEntityId = 200000;

    public JumpAnimationHandler(FoliaHelper foliaHelper, Logger logger) {
        this.foliaHelper = foliaHelper;
        this.logger = logger;
    }

    public void playLaunchAnimation(Player player) {
        org.bukkit.Location center = player.getLocation();
        int radius = 1;
        ArrayList<Block> blocksToAnimate = new ArrayList<Block>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                Block block = center.clone().subtract(0.0, 1.0, 0.0).add((double)x, 0.0, (double)z).getBlock();
                if (!block.getType().isSolid()) continue;
                blocksToAnimate.add(block);
            }
        }
        if (blocksToAnimate.isEmpty()) {
            return;
        }
        for (Block block : blocksToAnimate) {
            org.bukkit.Location loc = block.getLocation();
            BlockData blockData = block.getBlockData();
            int entityId = JumpAnimationHandler.generateUniqueEntityId();
            WrappedBlockState state = SpigotConversionUtil.fromBukkitBlockData((BlockData)blockData);
            WrapperPlayServerSpawnEntity spawnPacket = new WrapperPlayServerSpawnEntity(entityId, UUID.randomUUID(), EntityTypes.FALLING_BLOCK, new Location(loc.getX(), loc.getY(), loc.getZ(), 0.0f, 0.0f), 0.0f, state.getGlobalId(), Vector3d.zero());
            Vector3d motion = this.randomExplosionVector(loc, center);
            spawnPacket.setVelocity(Optional.of(motion));
            PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)spawnPacket);
            this.foliaHelper.runTaskLater((Entity)player, () -> {
                WrapperPlayServerDestroyEntities destroyPacket = new WrapperPlayServerDestroyEntities(entityId);
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)player, (PacketWrapper)destroyPacket);
            }, 30L);
        }
    }

    private Vector3d randomExplosionVector(org.bukkit.Location loc, org.bukkit.Location center) {
        Vector direction = loc.clone().add(0.5, 0.0, 0.5).toVector().subtract(center.toVector()).normalize();
        double explosionStrength = 0.35;
        double upwardPop = 0.3 + ThreadLocalRandom.current().nextDouble() * 0.3;
        direction = direction.multiply(explosionStrength);
        return new Vector3d(direction.getX(), upwardPop, direction.getZ());
    }

    private static synchronized int generateUniqueEntityId() {
        return nextEntityId++;
    }
}

