/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import io.papermc.paper.plugin.configuration.PluginMeta;
import org.bruno.elytraEssentials.helpers.VersionHelper;
import org.bukkit.plugin.PluginDescriptionFile;

public class PluginInfoHandler {
    private final String currentVersion;
    private String latestVersion;
    private boolean isUpdateAvailable;

    public PluginInfoHandler(PluginMeta pluginMeta) {
        this.latestVersion = this.currentVersion = pluginMeta.getVersion();
        this.isUpdateAvailable = false;
    }

    public PluginInfoHandler(PluginDescriptionFile descriptionFile) {
        this.latestVersion = this.currentVersion = descriptionFile.getVersion();
        this.isUpdateAvailable = false;
    }

    public synchronized void setUpdateInfo(String latestVersion) {
        this.latestVersion = latestVersion;
        this.isUpdateAvailable = VersionHelper.isNewerVersion(this.currentVersion, this.latestVersion);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public synchronized String getLatestVersion() {
        return this.latestVersion;
    }

    public synchronized boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }
}

