/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.UUID;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RecoveryHandler {
    private final FlightHandler flightHandler;
    private final ConfigHandler configHandler;
    private final FoliaHelper foliaHelper;
    private CancellableTask task;

    public RecoveryHandler(FlightHandler flightHandler, ConfigHandler configHandler, FoliaHelper foliaHelper) {
        this.flightHandler = flightHandler;
        this.configHandler = configHandler;
        this.foliaHelper = foliaHelper;
    }

    public void start() {
        if (this.task != null) {
            return;
        }
        if (!this.configHandler.getIsTimeLimitEnabled() || !this.configHandler.getIsRecoveryEnabled()) {
            return;
        }
        int recoveryInterval = this.configHandler.getRecoveryInterval();
        this.task = this.foliaHelper.runTaskTimerGlobal(this::recoverFlightTime, (long)recoveryInterval * 20L, (long)recoveryInterval * 20L);
    }

    public void shutdown() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private void recoverFlightTime() {
        int maxTimeLimit = this.configHandler.getMaxTimeLimit();
        int timeToAddBase = this.configHandler.getRecoveryAmount();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (PermissionsHelper.playerBypassTimeLimit(player)) continue;
            UUID playerId = player.getUniqueId();
            int currentFlightTime = this.flightHandler.getCurrentFlightTime(playerId);
            if (maxTimeLimit > 0 && currentFlightTime >= maxTimeLimit) continue;
            int timeToAdd = timeToAddBase;
            if (maxTimeLimit > 0 && currentFlightTime + timeToAdd > maxTimeLimit) {
                timeToAdd = maxTimeLimit - currentFlightTime;
            }
            if (timeToAdd <= 0) continue;
            this.flightHandler.addFlightTime(playerId, timeToAdd, (CommandSender)player);
        }
    }
}

