/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.handlers.DatabaseHandler;
import org.bruno.elytraEssentials.handlers.EffectsHandler;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.helpers.TimeHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bruno.elytraEssentials.utils.PlayerStats;
import org.bruno.elytraEssentials.utils.StatType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsHandler {
    private static final double METERS_IN_ONE_KILOMETER = 1000.0;
    private static final double KMH_CONVERSION_FACTOR = 3.6;
    private final DatabaseHandler databaseHandler;
    private final FoliaHelper foliaHelper;
    private final Logger logger;
    private final MessagesHelper messagesHelper;
    private final EffectsHandler effectsHandler;
    private final Map<UUID, PlayerStats> statsCache = new ConcurrentHashMap<UUID, PlayerStats>();
    private final Set<UUID> glidingPlayers = new HashSet<UUID>();
    private CancellableTask task;

    public StatsHandler(Logger logger, DatabaseHandler databaseHandler, FoliaHelper foliaHelper, MessagesHelper messagesHelper, EffectsHandler effectsHandler) {
        this.logger = logger;
        this.databaseHandler = databaseHandler;
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
        this.effectsHandler = effectsHandler;
    }

    public void fetchAndDisplayStats(CommandSender sender, OfflinePlayer target) {
        this.messagesHelper.sendCommandSenderMessage(sender, "&eFetching stats for " + target.getName() + "...");
        this.foliaHelper.runAsyncTask(() -> {
            try {
                PlayerStats targetStats = target.isOnline() ? this.getStats(target.getPlayer()) : this.databaseHandler.getPlayerStats(target.getUniqueId());
                int distanceRank = this.databaseHandler.getPlayerRank(target.getUniqueId(), "total_distance");
                int timeRank = this.databaseHandler.getPlayerRank(target.getUniqueId(), "total_time_seconds");
                int longestFlightRank = this.databaseHandler.getPlayerRank(target.getUniqueId(), "longest_flight");
                PlayerRanks ranks = new PlayerRanks(distanceRank, timeRank, longestFlightRank);
                this.foliaHelper.runTaskOnMainThread(() -> {
                    Player p;
                    String titlePrefix = sender instanceof Player && (p = (Player)sender).getUniqueId().equals(target.getUniqueId()) ? "Your" : target.getName() + "'s";
                    this.displayStats(sender, targetStats, ranks, titlePrefix);
                });
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Could not fetch stats for " + target.getName(), e);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cAn error occurred while fetching stats."));
            }
        });
    }

    public void loadPlayerStats(Player player) {
        this.foliaHelper.runAsyncTask(() -> {
            try {
                PlayerStats stats = this.databaseHandler.getPlayerStats(player.getUniqueId());
                this.statsCache.put(player.getUniqueId(), stats);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Could not load stats for player " + player.getName(), e);
            }
        });
    }

    public void savePlayerStats(Player player) {
        PlayerStats stats = this.statsCache.remove(player.getUniqueId());
        this.glidingPlayers.remove(player.getUniqueId());
        if (stats != null) {
            try {
                this.databaseHandler.savePlayerStats(stats);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Could not save stats for player " + player.getName(), e);
            }
        }
    }

    public PlayerStats getStats(Player player) {
        return this.statsCache.getOrDefault(player.getUniqueId(), new PlayerStats(player.getUniqueId()));
    }

    public double getStatValue(Player player, StatType type) {
        PlayerStats stats = this.getStats(player);
        if (stats == null) {
            return 0.0;
        }
        return switch (type) {
            case StatType.TOTAL_DISTANCE -> stats.getTotalDistance();
            case StatType.LONGEST_FLIGHT -> stats.getLongestFlight();
            case StatType.TOTAL_FLIGHT_TIME -> stats.getTotalTimeSeconds();
            case StatType.BOOSTS_USED -> stats.getBoostsUsed();
            case StatType.SUPER_BOOSTS_USED -> stats.getSuperBoostsUsed();
            case StatType.SAVES -> stats.getPluginSaves();
            default -> 0.0;
        };
    }

    public void setGliding(Player player, boolean isGliding) {
        if (isGliding) {
            this.glidingPlayers.add(player.getUniqueId());
        } else {
            this.glidingPlayers.remove(player.getUniqueId());
        }
    }

    public void start() {
        if (this.task != null) {
            return;
        }
        this.task = this.foliaHelper.runTaskTimerGlobal(this::glidingTimeTracker, 20L, 20L);
    }

    public void shutdown() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.saveAllOnlinePlayers();
    }

    public void saveAllOnlinePlayers() {
        this.messagesHelper.sendDebugMessage("Saving stats for all online players...");
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerStats stats = this.statsCache.get(player.getUniqueId());
            if (stats == null) continue;
            try {
                this.databaseHandler.savePlayerStats(stats);
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to save stats for " + player.getName() + " during shutdown.", e);
            }
        }
        this.messagesHelper.sendDebugMessage("Finished saving all player stats.");
    }

    public void displayTopStats(CommandSender sender, String category) {
        String format;
        String title;
        String dbColumn;
        switch (category) {
            case "distance": {
                dbColumn = "total_distance";
                title = "Top Distance Flown";
                format = "\u00a7e#%d \u00a7f%s \u00a77- \u00a7b%.1f km";
                break;
            }
            case "time": {
                dbColumn = "total_time_seconds";
                title = "Top Flight Time";
                format = "\u00a7e#%d \u00a7f%s \u00a77- \u00a7b%s";
                break;
            }
            case "longest": {
                dbColumn = "longest_flight";
                title = "Longest Single Flights";
                format = "\u00a7e#%d \u00a7f%s \u00a77- \u00a7b%.0f blocks";
                break;
            }
            default: {
                this.messagesHelper.sendCommandSenderMessage(sender, "&cInvalid category. Use: distance, time, longest");
                return;
            }
        }
        this.foliaHelper.runAsyncTask(() -> {
            try {
                Map<UUID, Double> topData = this.databaseHandler.getTopStats(dbColumn, 5);
                ArrayList<String> formattedMessages = new ArrayList<String>();
                if (topData.isEmpty()) {
                    formattedMessages.add("\u00a77No statistics available for this category yet.");
                } else {
                    int rank = 1;
                    for (Map.Entry<UUID, Double> entry : topData.entrySet()) {
                        String formattedLine;
                        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)entry.getKey());
                        String playerName = player.getName() != null ? player.getName() : "Unknown";
                        Double value = entry.getValue();
                        if ((formattedLine = (switch (category) {
                            case "time" -> String.format(format, rank, playerName, TimeHelper.formatFlightTime(value.intValue()));
                            case "distance" -> String.format(format, rank, playerName, value / 1000.0);
                            case "longest" -> String.format(format, rank, playerName, value);
                            default -> "";
                        })).isBlank()) continue;
                        formattedMessages.add(formattedLine);
                        ++rank;
                    }
                }
                this.foliaHelper.runTaskOnMainThread(() -> {
                    sender.sendMessage("\u00a76--- " + title + " ---");
                    for (String message : formattedMessages) {
                        sender.sendMessage(message);
                    }
                    sender.sendMessage("\u00a76-------------------------------------");
                });
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "An error occurred while fetching the leaderboard.", e);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cAn error occurred while fetching the leaderboard."));
            }
        });
    }

    public void resetPlayerStats(OfflinePlayer target, CommandSender sender) {
        this.foliaHelper.runAsyncTask(() -> {
            try {
                this.databaseHandler.resetPlayerStats(target.getUniqueId());
                this.foliaHelper.runTaskOnMainThread(() -> {
                    Player onlinePlayer;
                    if (target.isOnline() && (onlinePlayer = target.getPlayer()) != null) {
                        this.statsCache.put(target.getUniqueId(), new PlayerStats(target.getUniqueId()));
                        this.messagesHelper.sendPlayerMessage(onlinePlayer, "&cYour ElytraEssentials stats have been reset by an administrator.");
                    }
                    this.messagesHelper.sendCommandSenderMessage(sender, "&aSuccessfully reset all stats for " + target.getName() + ".");
                });
            }
            catch (SQLException e) {
                this.logger.log(Level.SEVERE, "Failed to reset stats for " + target.getName(), e);
                this.foliaHelper.runTaskOnMainThread(() -> this.messagesHelper.sendCommandSenderMessage(sender, "&cAn error occurred while resetting stats."));
            }
        });
    }

    private void glidingTimeTracker() {
        for (UUID uuid : this.glidingPlayers) {
            PlayerStats stats = this.statsCache.get(uuid);
            if (stats == null) continue;
            stats.addTime(1L);
        }
    }

    private void displayStats(CommandSender sender, PlayerStats stats, PlayerRanks ranks, String titlePrefix) {
        if (stats == null) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cCould not load stats for this player.");
            return;
        }
        double totalDistance = stats.getTotalDistance();
        long totalTime = stats.getTotalTimeSeconds();
        double avgSpeedKmh = totalTime > 0L ? totalDistance / (double)totalTime * 3.6 : 0.0;
        String distanceRankStr = ranks.distanceRank > 0 ? ColorHelper.parse(" &#FFD700(#" + ranks.distanceRank + ")") : "";
        String timeRankStr = ranks.timeRank > 0 ? ColorHelper.parse(" &#FFD700(#" + ranks.timeRank + ")") : "";
        String longestFlightRankStr = ranks.longestFlightRank > 0 ? ColorHelper.parse(" &#FFD700(#" + ranks.longestFlightRank + ")") : "";
        int effectsOwned = 0;
        int totalEffects = this.effectsHandler.getEffectsRegistry().size();
        String activeEffect = "None";
        try {
            String storedEffect;
            if (sender instanceof Player) {
                Player player = (Player)sender;
                effectsOwned = PermissionsHelper.hasAllEffectsPermission(player) ? totalEffects : this.databaseHandler.getOwnedEffectKeys(stats.getUuid()).size();
            }
            if ((storedEffect = this.databaseHandler.getPlayerActiveEffect(stats.getUuid())) != null) {
                activeEffect = storedEffect;
            }
        }
        catch (SQLException e) {
            this.messagesHelper.sendCommandSenderMessage(sender, "&cCould not load effect data...");
            this.logger.log(Level.SEVERE, "Could not load effect data: ", e);
        }
        String primary = "\u00a76";
        String secondary = "\u00a7e";
        String text = "\u00a77";
        String value = "\u00a7f";
        String arrow = "\u00bb ";
        sender.sendMessage(primary + "\u00a7m----------------------------------------------------");
        sender.sendMessage("");
        sender.sendMessage(primary + "\u00a7l" + titlePrefix + " Elytra Statistics");
        sender.sendMessage("");
        sender.sendMessage(secondary + arrow + text + "Total Distance Flown: " + value + String.format("%.1f km", totalDistance / 1000.0) + distanceRankStr);
        sender.sendMessage(secondary + arrow + text + "Total Flight Time: " + value + TimeHelper.formatFlightTime((int)totalTime) + timeRankStr);
        sender.sendMessage(secondary + arrow + text + "Longest Flight: " + value + String.format("%.0f blocks", stats.getLongestFlight()) + longestFlightRankStr);
        sender.sendMessage(secondary + arrow + text + "Average Speed: " + value + String.format("%.1f km/h", avgSpeedKmh));
        sender.sendMessage("");
        sender.sendMessage(secondary + arrow + text + "Boosts Used: " + value + String.format("%d (%d Super Boosts)", stats.getBoostsUsed(), stats.getSuperBoostsUsed()));
        sender.sendMessage(secondary + arrow + text + "Saves: " + value + String.format("%d times", stats.getPluginSaves()));
        sender.sendMessage(secondary + arrow + text + "Effects Unlocked: " + value + String.format("%d/%d", effectsOwned, totalEffects));
        sender.sendMessage(secondary + arrow + text + "Active Effect: " + value + activeEffect);
        sender.sendMessage("");
        sender.sendMessage(primary + "\u00a7m----------------------------------------------------");
    }

    private record PlayerRanks(int distanceRank, int timeRank, int longestFlightRank) {
    }
}

