/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.handlers.MessagesHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TandemHandler {
    public static final int DISMOUNT_COUNTDOWN_SECONDS = 5;
    private final ConfigHandler configHandler;
    private final MessagesHelper messagesHelper;
    private final FoliaHelper foliaHelper;
    private final FlightHandler flightHandler;
    private final MessagesHandler messagesHandler;
    private final Map<UUID, UUID> activeTandems = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, UUID> pendingInvites = new ConcurrentHashMap<UUID, UUID>();
    private final Map<UUID, CancellableTask> inviteExpirations = new ConcurrentHashMap<UUID, CancellableTask>();
    private final Map<UUID, CancellableTask> takeoffTimers = new ConcurrentHashMap<UUID, CancellableTask>();
    private final Map<UUID, CancellableTask> dismountTimers = new ConcurrentHashMap<UUID, CancellableTask>();
    private final Map<UUID, CancellableTask> mountTimers = new ConcurrentHashMap<UUID, CancellableTask>();
    private CancellableTask passengerUpdateTask;

    public TandemHandler(ConfigHandler configHandler, MessagesHelper messagesHelper, FoliaHelper foliaHelper, FlightHandler flightHandler, MessagesHandler messagesHandler) {
        this.configHandler = configHandler;
        this.messagesHelper = messagesHelper;
        this.foliaHelper = foliaHelper;
        this.flightHandler = flightHandler;
        this.messagesHandler = messagesHandler;
    }

    public void start() {
        if (!this.configHandler.getIsTandemFlightEnabled()) {
            return;
        }
        this.passengerUpdateTask = this.foliaHelper.runTaskTimerGlobal(this::updatePassengers, 1L, 1L);
    }

    public void shutdown() {
        if (this.passengerUpdateTask != null) {
            this.passengerUpdateTask.cancel();
            this.passengerUpdateTask = null;
        }
    }

    private void updatePassengers() {
        for (Map.Entry<UUID, UUID> entry : this.activeTandems.entrySet()) {
            int extraSecondsToConsume;
            double costMultiplier;
            Player passenger = Bukkit.getPlayer((UUID)entry.getKey());
            Player driver = Bukkit.getPlayer((UUID)entry.getValue());
            if (passenger == null || driver == null) {
                this.dismountPassenger(passenger, driver, false);
                continue;
            }
            if (driver.isGliding()) {
                this.cancelAndRemoveTask(this.takeoffTimers, passenger.getUniqueId());
                this.cancelAndRemoveTask(this.dismountTimers, passenger.getUniqueId());
            } else if (!this.takeoffTimers.containsKey(passenger.getUniqueId())) {
                this.startDismountCountdown(passenger, driver);
                continue;
            }
            if (driver.getPassengers().isEmpty() || !driver.getPassengers().contains(passenger)) {
                driver.addPassenger((Entity)passenger);
            }
            if (!driver.isGliding() || Bukkit.getCurrentTick() % 20 != 0 || !this.configHandler.getIsTimeLimitEnabled() || PermissionsHelper.playerBypassTimeLimit(driver) || !((costMultiplier = this.configHandler.getTandemFlightTimeCostMultiplier()) > 1.0) || (extraSecondsToConsume = (int)Math.round(costMultiplier - 1.0)) <= 0) continue;
            this.flightHandler.removeFlightTime(driver.getUniqueId(), extraSecondsToConsume, null);
        }
    }

    public void invitePlayer(Player driver, Player invitee) {
        if (this.activeTandems.containsValue(driver.getUniqueId())) {
            this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverAlreadyHasPassenger());
            return;
        }
        if (this.activeTandems.containsKey(invitee.getUniqueId()) || this.pendingInvites.containsKey(invitee.getUniqueId())) {
            this.messagesHelper.sendPlayerMessage(driver, "&c" + invitee.getName() + " is already busy or has a pending invite.");
            return;
        }
        ItemStack inviteeChestplate = invitee.getInventory().getChestplate();
        if (inviteeChestplate != null && inviteeChestplate.getType() == Material.ELYTRA) {
            this.messagesHelper.sendPlayerMessage(driver, "&c" + invitee.getName() + " cannot be invited as they are wearing an elytra.");
            return;
        }
        this.pendingInvites.put(invitee.getUniqueId(), driver.getUniqueId());
        int timeout = this.configHandler.getTandemInviteTimeout();
        CancellableTask expirationTask = this.foliaHelper.runTaskLater((Entity)invitee, () -> {
            if (this.pendingInvites.remove(invitee.getUniqueId()) != null) {
                this.messagesHelper.sendPlayerMessage(invitee, this.messagesHandler.getPassengerInvitationExpired().replace("{0}", driver.getName()));
                this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverInvitationExpired().replace("{0}", invitee.getName()));
            }
        }, (long)timeout * 20L);
        this.inviteExpirations.put(invitee.getUniqueId(), expirationTask);
        this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverInvitationSent().replace("{0}", invitee.getName()));
        TextComponent message = new TextComponent("\u00a7e" + driver.getName() + " \u00a77has invited you to a tandem flight! ");
        TextComponent commandComponent = new TextComponent("\u00a7a\u00a7l[ACCEPT]");
        commandComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ee tandem accept"));
        commandComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text("Click here to accept the invitation.")}));
        message.addExtra((BaseComponent)commandComponent);
        invitee.spigot().sendMessage((BaseComponent)message);
    }

    public void acceptInvite(Player passenger) {
        UUID driverUUID = this.pendingInvites.remove(passenger.getUniqueId());
        if (driverUUID == null) {
            this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getNoPendingInvitation());
            return;
        }
        this.cancelAndRemoveTask(this.inviteExpirations, passenger.getUniqueId());
        Player driver = Bukkit.getPlayer((UUID)driverUUID);
        if (driver == null || !driver.isOnline()) {
            this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getDriverNotAvailable());
            return;
        }
        int countdownSeconds = this.configHandler.getTandemMountCountdown();
        if (countdownSeconds <= 0) {
            this.mountPlayer(passenger, driver);
        } else {
            this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getPassengerTandemInvitationAccepted().replace("{0}", String.valueOf(countdownSeconds)));
            this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverTandemInvitationAccepted().replace("{0}", passenger.getName()).replace("{1}", String.valueOf(countdownSeconds)));
            AtomicInteger countdown = new AtomicInteger(countdownSeconds);
            CancellableTask mountTask = this.foliaHelper.runTaskTimerGlobal(() -> {
                Player currentPassenger = Bukkit.getPlayer((UUID)passenger.getUniqueId());
                Player currentDriver = Bukkit.getPlayer((UUID)driver.getUniqueId());
                if (currentPassenger == null || currentDriver == null) {
                    this.cancelAndRemoveTask(this.mountTimers, passenger.getUniqueId());
                    return;
                }
                int remaining = countdown.getAndDecrement();
                if (remaining > 0) {
                    this.messagesHelper.sendPlayerMessage(currentPassenger, this.messagesHandler.getMountingCountdown().replace("{0}", String.valueOf(remaining)));
                    this.messagesHelper.sendPlayerMessage(currentDriver, this.messagesHandler.getMountingCountdown().replace("{0}", String.valueOf(remaining)));
                } else {
                    this.mountPlayer(currentPassenger, currentDriver);
                    this.cancelAndRemoveTask(this.mountTimers, passenger.getUniqueId());
                }
            }, 0L, 20L);
            this.mountTimers.put(passenger.getUniqueId(), mountTask);
        }
    }

    public void dismountPassenger(Player passenger, Player driver, boolean voluntary) {
        UUID driverUUID;
        if (passenger == null) {
            return;
        }
        CancellableTask takeoffTask = this.takeoffTimers.remove(passenger.getUniqueId());
        if (takeoffTask != null) {
            takeoffTask.cancel();
        }
        if ((driverUUID = this.activeTandems.remove(passenger.getUniqueId())) == null) {
            return;
        }
        if (driver == null) {
            driver = Bukkit.getPlayer((UUID)driverUUID);
        }
        if (driver != null && driver.isOnline()) {
            driver.removePassenger((Entity)passenger);
            if (voluntary) {
                this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverVoluntaryDismount().replace("{0}", passenger.getName()));
            }
        }
        if (voluntary) {
            this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getPassengerVoluntaryDismount());
        }
        if (this.configHandler.getTandemFallDamageProtection() && !passenger.isOnGround()) {
            this.flightHandler.protectPlayerFromFall(passenger);
        }
    }

    public boolean isPassenger(Player player) {
        return this.activeTandems.containsKey(player.getUniqueId());
    }

    public void clearPlayerData(Player player) {
        this.dismountPassenger(player, null, false);
        if (this.activeTandems.containsValue(player.getUniqueId())) {
            this.activeTandems.entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(player.getUniqueId())).findFirst().ifPresent(entry -> this.dismountPassenger(Bukkit.getPlayer((UUID)((UUID)entry.getKey())), player, false));
        }
        this.pendingInvites.remove(player.getUniqueId());
        CancellableTask task = this.inviteExpirations.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    private void startDismountCountdown(Player passenger, Player driver) {
        if (this.dismountTimers.containsKey(passenger.getUniqueId())) {
            return;
        }
        AtomicInteger countdown = new AtomicInteger(5);
        CancellableTask task = this.foliaHelper.runTaskTimerGlobal(() -> {
            int remaining = countdown.getAndDecrement();
            if (remaining > 0) {
                String message = this.messagesHandler.getDismountCountdown().replace("{0}", String.valueOf(remaining));
                this.messagesHelper.sendPlayerMessage(passenger, message);
                this.messagesHelper.sendPlayerMessage(driver, message);
            } else {
                this.dismountPassenger(passenger, driver, false);
                this.cancelAndRemoveTask(this.dismountTimers, passenger.getUniqueId());
            }
        }, 0L, 20L);
        this.dismountTimers.put(passenger.getUniqueId(), task);
    }

    private void cancelAndRemoveTask(Map<UUID, CancellableTask> map, UUID key) {
        CancellableTask task = map.remove(key);
        if (task != null) {
            task.cancel();
        }
    }

    private void mountPlayer(Player passenger, Player driver) {
        this.activeTandems.put(passenger.getUniqueId(), driver.getUniqueId());
        driver.addPassenger((Entity)passenger);
        this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getPassengerMountedSuccess().replace("{0}", driver.getName()));
        this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverMountedSuccess().replace("{0}", passenger.getName()));
        if (!driver.isGliding()) {
            this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverTandemFlightCountdown().replace("{0}", "10"));
            CancellableTask takeoffTask = this.foliaHelper.runTaskLater((Entity)driver, () -> {
                if (this.activeTandems.containsKey(passenger.getUniqueId()) && !driver.isGliding()) {
                    this.messagesHelper.sendPlayerMessage(driver, this.messagesHandler.getDriverTandemFlightFailed());
                    this.messagesHelper.sendPlayerMessage(passenger, this.messagesHandler.getPassengerTandemFlightFailed());
                    this.dismountPassenger(passenger, driver, false);
                }
                this.takeoffTimers.remove(passenger.getUniqueId());
            }, 200L);
            this.takeoffTimers.put(passenger.getUniqueId(), takeoffTask);
        }
    }
}

